/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import java.util.List;
import net.atlas.combatify.item.WeaponType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class KnifeItem
extends TieredItem {
    public KnifeItem(Tier tier, Item.Properties properties) {
        super(tier, properties.component(DataComponents.TOOL, (Object)KnifeItem.createToolProperties()).attributes(KnifeItem.baseAttributeModifiers(tier)));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers baseAttributeModifiers(Tier tier) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        WeaponType.KNIFE.addCombatAttributes(0, tier, builder);
        return builder.build();
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }
}

