/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import java.util.Collections;
import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.custom.Blocker;
import net.atlas.combatify.item.CombatifyItems;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.neoforge.registries.DeferredItem;

public class TieredShieldItem
extends ShieldItem {
    public final Tier tier;
    public static final DeferredItem<Item> IRON_SHIELD = CombatifyItems.registerItem("iron_shield", properties -> new TieredShieldItem((Tier)Tiers.IRON, (Item.Properties)properties, 3, Blocker.NEW_SHIELD), new Item.Properties());
    public static final DeferredItem<Item> GOLD_SHIELD = CombatifyItems.registerItem("golden_shield", properties -> new TieredShieldItem((Tier)Tiers.GOLD, (Item.Properties)properties, 1, Blocker.NEW_SHIELD), new Item.Properties());
    public static final DeferredItem<Item> DIAMOND_SHIELD = CombatifyItems.registerItem("diamond_shield", properties -> new TieredShieldItem((Tier)Tiers.DIAMOND, (Item.Properties)properties, 5, Blocker.NEW_SHIELD), new Item.Properties());
    public static final DeferredItem<Item> NETHERITE_SHIELD = CombatifyItems.registerItem("netherite_shield", properties -> new TieredShieldItem((Tier)Tiers.NETHERITE, (Item.Properties)properties, 5, Blocker.NEW_SHIELD.withKnockback(Collections.singletonList(BlockingTypeInit.SHIELD_KNOCKBACK)).withProtection(List.of(BlockingTypeInit.NETHERITE_SHIELD_PROTECTION, BlockingTypeInit.NEW_SHIELD_PROTECTION))), new Item.Properties().fireResistant());

    public TieredShieldItem(Tier tier, Item.Properties properties, int lvl, Blocker baseBlocker) {
        super(properties.durability(tier.getUses() * 2).component(CustomDataComponents.BLOCKING_LEVEL, (Object)lvl).component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY).component(CustomDataComponents.BLOCKER, (Object)baseBlocker));
        this.tier = tier;
        Combatify.shields.add((Item)this);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.registerModelPredicate();
        }
    }

    private void registerModelPredicate() {
        ItemProperties.register((Item)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.isBlocking() && MethodHandler.getBlockingItem(livingEntity).stack() == itemStack ? 1.0f : 0.0f);
    }

    public boolean isValidRepairItem(ItemStack itemStack, ItemStack itemStack2) {
        return this.tier.getRepairIngredient().test(itemStack2);
    }

    public int getEnchantmentValue() {
        return this.tier.getEnchantmentValue();
    }

    public static void init() {
    }
}

