/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.IUpdateAttributesPacket;
import net.atlas.combatify.item.WeaponType;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ClientboundUpdateAttributesPacket.class})
public class ClientboundUpdateAttributesPacketMixin
implements IUpdateAttributesPacket {
    @Shadow
    @Final
    private List<ClientboundUpdateAttributesPacket.AttributeSnapshot> attributes;

    @Override
    public void combatify$changeAttributes(ServerPlayer reciever) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        HashMap<Integer, AttributeModifier> modifierMap = new HashMap<Integer, AttributeModifier>();
        for (ClientboundUpdateAttributesPacket.AttributeSnapshot attributeSnapshot : this.attributes) {
            if (attributeSnapshot.attribute() != Attributes.ATTACK_SPEED) continue;
            double speed = this.calculateValue(attributeSnapshot.base(), attributeSnapshot.modifiers(), (Holder<Attribute>)attributeSnapshot.attribute());
            double mod = Combatify.CONFIG.hasteFix() == false ? 1.5 : this.calculateValueFromBase(1.5, attributeSnapshot.modifiers(), (Holder<Attribute>)attributeSnapshot.attribute());
            boolean hasVanilla = !attributeSnapshot.modifiers().stream().filter(attributeModifier -> attributeModifier.id().equals((Object)Item.BASE_ATTACK_SPEED_ID)).toList().isEmpty() && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C);
            int mul = Combatify.CONFIG.chargedAttacks() != false ? 2 : 1;
            double newSpeed = speed - mod;
            if (hasVanilla || newSpeed <= 0.0) {
                newSpeed += mod;
            }
            while (newSpeed > 0.0) {
                if (ClientboundUpdateAttributesPacketMixin.vanillaMath(newSpeed / (double)mul) == ClientboundUpdateAttributesPacketMixin.CTSMath(speed, hasVanilla, mod) * mul) {
                    modifierMap.put(this.attributes.indexOf(attributeSnapshot), new AttributeModifier(WeaponType.BASE_ATTACK_SPEED_CTS_ID, newSpeed / (double)mul - 2.5, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                if (ClientboundUpdateAttributesPacketMixin.vanillaMath(newSpeed) == ClientboundUpdateAttributesPacketMixin.CTSMath(speed, hasVanilla, mod) * mul) {
                    modifierMap.put(this.attributes.indexOf(attributeSnapshot), new AttributeModifier(WeaponType.BASE_ATTACK_SPEED_CTS_ID, newSpeed - 2.5, AttributeModifier.Operation.ADD_VALUE));
                    break;
                }
                newSpeed -= 1.0E-4;
            }
            indexes.add(this.attributes.indexOf(attributeSnapshot));
        }
        if (!indexes.isEmpty()) {
            for (Integer index : indexes) {
                AttributeModifier modifierToSend = (AttributeModifier)modifierMap.get(index);
                List<AttributeModifier> newModifiers = Collections.singletonList(modifierToSend);
                ClientboundUpdateAttributesPacket.AttributeSnapshot attributeSnapshot = this.attributes.remove(index);
                this.attributes.add(index, new ClientboundUpdateAttributesPacket.AttributeSnapshot(attributeSnapshot.attribute(), attributeSnapshot.base() - 1.5, newModifiers));
            }
        }
    }

    @Unique
    public final double calculateValue(double baseValue, Collection<AttributeModifier> modifiers, Holder<Attribute> attribute) {
        double attributeInstanceBaseValue = baseValue;
        List<AttributeModifier> additionList = modifiers.stream().filter(attributeModifier -> attributeModifier.operation() == AttributeModifier.Operation.ADD_VALUE).toList();
        for (AttributeModifier attributeModifier2 : additionList) {
            attributeInstanceBaseValue += attributeModifier2.amount();
        }
        return this.calculateValueFromBase(attributeInstanceBaseValue, modifiers, attribute);
    }

    @Unique
    public final double calculateValueFromBase(double attributeInstanceBaseValue, Collection<AttributeModifier> modifiers, Holder<Attribute> attribute) {
        List<AttributeModifier> multiplyBaseList = modifiers.stream().filter(attributeModifier -> attributeModifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toList();
        List<AttributeModifier> multiplyTotalList = modifiers.stream().filter(attributeModifier -> attributeModifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).toList();
        double attributeInstanceFinalValue = attributeInstanceBaseValue;
        for (AttributeModifier attributeModifier2 : multiplyBaseList) {
            attributeInstanceFinalValue += attributeInstanceBaseValue * attributeModifier2.amount();
        }
        for (AttributeModifier attributeModifier2 : multiplyTotalList) {
            attributeInstanceFinalValue *= 1.0 + attributeModifier2.amount();
        }
        return ((Attribute)attribute.value()).sanitizeValue(attributeInstanceFinalValue);
    }

    @Unique
    private static int CTSMath(double attackSpeed, boolean hasVanilla, double mod) {
        double d = attackSpeed - mod;
        if (hasVanilla || d <= 0.0) {
            d += mod;
        }
        d = Mth.clamp((double)d, (double)0.1, (double)1024.0);
        d = 1.0 / d * 20.0 + (hasVanilla ? 0.0 : 0.5);
        return (int)d;
    }

    @Unique
    private static int vanillaMath(double attackSpeed) {
        return (int)(1.0 / attackSpeed * 20.0);
    }
}

