/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.atlas.combatify.Combatify;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Entity {
    public FishingHookMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    @Nullable
    public abstract Player getPlayerOwner();

    @WrapOperation(method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;multiply(DDD)Lnet/minecraft/world/phys/Vec3;")})
    public Vec3 modifyMovement(Vec3 instance, double d, double e, double f, Operation<Vec3> original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.CONFIG.fishingHookKB().booleanValue()) {
            float playerXRotRadians = player.getXRot() * ((float)Math.PI / 180);
            float playerYRotRadians = player.getYRot() * ((float)Math.PI / 180);
            double xRotFactor = Mth.cos((float)playerXRotRadians);
            Vec3 newDelta = new Vec3((double)(-Mth.sin((float)playerYRotRadians)) * xRotFactor * 0.4, (double)(-Mth.sin((float)playerXRotRadians)) * 0.4, (double)Mth.cos((float)playerYRotRadians) * xRotFactor * 0.4);
            return newDelta.normalize().add(this.random.nextGaussian() * (double)0.0075f, this.random.nextGaussian() * (double)0.0075f, this.random.nextGaussian() * (double)0.0075f).scale(1.5);
        }
        return (Vec3)original.call(new Object[]{instance, d, e, f});
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="TAIL")})
    protected void onHitEntity(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity;
        if (Combatify.CONFIG.fishingHookKB().booleanValue() && (entity = entityHitResult.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(this.damageSources().thrown((Entity)FishingHook.class.cast((Object)this), (Entity)this.getPlayerOwner()), 0.0f);
        }
    }
}

