/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Unique
    public ItemStack stack = (ItemStack)ItemStack.class.cast(this);

    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract String toString();

    @Shadow
    public abstract <T extends TooltipProvider> void addToTooltip(DataComponentType<T> var1, Item.TooltipContext var2, Consumer<Component> var3, TooltipFlag var4);

    @Shadow
    public abstract boolean isEmpty();

    @Shadow
    public abstract DataComponentPatch getComponentsPatch();

    @Shadow
    public abstract int getUseDuration(LivingEntity var1);

    @Inject(method={"getTooltipLines(Lnet/minecraft/world/item/Item$TooltipContext;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/common/util/AttributeUtil;addAttributeTooltips(Lnet/minecraft/world/item/ItemStack;Ljava/util/function/Consumer;Lnet/neoforged/neoforge/common/util/AttributeTooltipContext;)V")})
    public void appendCanSweepTooltip(Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag, CallbackInfoReturnable<List<Component>> cir, @Local(ordinal=0) Consumer<Component> consumer) {
        this.addToTooltip((Supplier)CustomDataComponents.CAN_SWEEP, tooltipContext, consumer, tooltipFlag);
    }

    @ModifyReturnValue(method={"getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="RETURN")})
    public int getUseDuration(int original) {
        if (MethodHandler.getBlocking(this.stack).canOverrideUseDurationAndAnimation(this.stack)) {
            return MethodHandler.getBlocking(this.stack).useTicks();
        }
        if (this.getComponentsPatch().get(DataComponents.FOOD) != null) {
            return original;
        }
        ConfigurableItemData configurableItemData = MethodHandler.forItem(this.getItem());
        if (configurableItemData != null && configurableItemData.useDuration() != null) {
            return (int)(configurableItemData.useDuration() * 20.0);
        }
        return original;
    }

    @ModifyReturnValue(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="RETURN")})
    public InteractionResult addBlockAbility(InteractionResult original, @Local(ordinal=0, argsOnly=true) UseOnContext useOnContext) {
        ItemStack stack = Objects.requireNonNull(useOnContext.getPlayer()).getItemInHand(useOnContext.getHand());
        InteractionResult result = MethodHandler.getBlocking(stack).use(stack, useOnContext.getLevel(), useOnContext.getPlayer(), useOnContext.getHand(), original);
        ConfigurableItemData configurableItemData = MethodHandler.forItem(this.getItem());
        if (configurableItemData != null && this.getUseDuration((LivingEntity)useOnContext.getPlayer()) == 0 && (original.consumesAction() || result != null && result.consumesAction()) && configurableItemData.cooldownSeconds() != null) {
            MethodHandler.getCooldowns((LivingEntity)useOnContext.getPlayer()).addCooldown(this.getItem(), (int)(configurableItemData.cooldownSeconds() * 20.0));
        }
        if (result != null) {
            return result;
        }
        return original;
    }

    @ModifyReturnValue(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="RETURN")})
    public InteractionResultHolder<ItemStack> addBlockAbility(InteractionResultHolder<ItemStack> original, @Local(ordinal=0, argsOnly=true) Level world, @Local(ordinal=0, argsOnly=true) Player player, @Local(ordinal=0, argsOnly=true) InteractionHand hand) {
        InteractionResult result = MethodHandler.getBlocking(this.stack).use(this.stack, world, player, hand, original.getResult());
        ConfigurableItemData configurableItemData = MethodHandler.forItem(this.getItem());
        if (configurableItemData != null && this.getUseDuration((LivingEntity)player) == 0 && (original.getResult().consumesAction() || result != null && result.consumesAction()) && configurableItemData.cooldownSeconds() != null) {
            MethodHandler.getCooldowns((LivingEntity)player).addCooldown(this.getItem(), (int)(configurableItemData.cooldownSeconds() * 20.0));
        }
        if (result != null) {
            return new InteractionResultHolder(result, (Object)this.stack);
        }
        return original;
    }

    @Inject(method={"releaseUsing(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="RETURN")})
    public void addCooldown(Level level, LivingEntity livingEntity, int i, CallbackInfo ci) {
        ConfigurableItemData configurableItemData = MethodHandler.forItem(this.getItem());
        if (configurableItemData != null && configurableItemData.cooldownSeconds() != null) {
            MethodHandler.getCooldowns(livingEntity).addCooldown(this.getItem(), (int)(configurableItemData.cooldownSeconds() * 20.0));
        }
    }

    @ModifyReturnValue(method={"getUseAnimation()Lnet/minecraft/world/item/UseAnim;"}, at={@At(value="RETURN")})
    public UseAnim addBlockAnim(UseAnim original) {
        if (MethodHandler.getBlocking(this.stack).canOverrideUseDurationAndAnimation(this.stack)) {
            return UseAnim.BLOCK;
        }
        return original;
    }
}

