/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.lang.runtime.SwitchBootstraps;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.EatingInterruptionMode;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1400)
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityExtensions {
    @Unique
    private double piercingNegation;
    @Unique
    private ItemCooldowns fallbackCooldowns = MethodHandler.createItemCooldowns();
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    LivingEntity thisEntity = (LivingEntity)LivingEntity.class.cast(this);
    @Shadow
    protected int useItemRemaining;
    @Shadow
    public int attackStrengthTicker;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getUseItem();

    @Shadow
    public abstract void indicateDamage(double var1, double var3);

    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @Override
    public ItemCooldowns combatify$getFallbackCooldowns() {
        return this.fallbackCooldowns;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void tickCooldowns(CallbackInfo ci) {
        this.fallbackCooldowns.tick();
        if (!(this.thisEntity instanceof Player)) {
            ++this.attackStrengthTicker;
        }
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(false);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(force);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean force) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return;
        }
        if (Combatify.CONFIG.attackSpeed() == false && this.getAttributeValue((Holder<Attribute>)Attributes.ATTACK_SPEED) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack().booleanValue()) {
            return;
        }
        int chargeTicks = MethodHandler.getCurrentItemAttackStrengthDelay((LivingEntity)LivingEntity.class.cast(this));
        if (force || chargeTicks > this.attackStrengthMaxValue - this.attackStrengthTicker) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
            this.attackStrengthTicker = 0;
        }
    }

    @Override
    public boolean combatify$isAttackAvailable(float baseTime) {
        return (float)this.attackStrengthMaxValue - ((float)this.attackStrengthTicker + baseTime) <= 0.0f;
    }

    @ModifyReturnValue(method={"isBlocking()Z"}, at={@At(value="RETURN")})
    public boolean isBlocking(boolean original) {
        return !MethodHandler.getBlockingItem(this.thisEntity).stack().isEmpty();
    }

    @Inject(method={"blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedByShield(LivingEntity target, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void combatify$setPiercingNegation(double negation) {
        this.piercingNegation = negation;
    }

    @Override
    public double combatify$getPiercingNegation() {
        return this.piercingNegation;
    }

    @ModifyConstant(method={"handleDamageEvent(Lnet/minecraft/world/damagesource/DamageSource;)V"}, constant={@Constant(intValue=20, ordinal=0)})
    private int syncInvulnerability(int x) {
        return 10;
    }

    @WrapOperation(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public boolean shield(LivingEntity instance, DamageSource source, Operation<Boolean> original, @Local(ordinal=0, argsOnly=true) LocalFloatRef amount, @Local(ordinal=2) LocalFloatRef protectedDamage, @Local(ordinal=0) LocalBooleanRef wasBlocked, @Share(value="blocked") LocalBooleanRef blocked) {
        ItemStack itemStack = MethodHandler.getBlockingItem(this.thisEntity).stack();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (amount.get() > 0.0f && ((Boolean)original.call(new Object[]{instance, source})).booleanValue()) {
                MethodHandler.getBlocking(itemStack).block(serverLevel, instance, source, itemStack, amount, protectedDamage, wasBlocked);
            }
        }
        blocked.set(wasBlocked.get());
        return false;
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;invulnerableTime:I", ordinal=1, shift=At.Shift.AFTER)})
    public void injectEatingInterruption(DamageSource source, float f, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        boolean canInterrupt;
        Entity entity = source.getEntity();
        boolean bl = canInterrupt = this.thisEntity.isUsingItem() && (this.getUseItem().getUseAnimation() == UseAnim.EAT || this.getUseItem().getUseAnimation() == UseAnim.DRINK);
        if (entity instanceof LivingEntity && (object = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            if (canInterrupt) {
                object = Combatify.CONFIG.eatingInterruptionMode();
                int n = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FULL_RESET", "DELAY"}, (EatingInterruptionMode)((Object)object), n)) {
                    case 0: {
                        int n2 = this.thisEntity.getUseItem().getUseDuration(this.thisEntity);
                        break;
                    }
                    case 1: {
                        int n2 = this.useItemRemaining + this.invulnerableTime;
                        break;
                    }
                    default: {
                        int n2 = this.useItemRemaining = this.useItemRemaining;
                    }
                }
                if (Combatify.CONFIG.eatingInterruptionMode() != EatingInterruptionMode.OFF) {
                    for (UUID playerUUID : Combatify.moddedPlayers) {
                        Player player = serverLevel.getPlayerByUUID(playerUUID);
                        if (!(player instanceof ServerPlayer)) continue;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)new NetworkingHandler.RemainingUseSyncPacket(this.getId(), this.useItemRemaining));
                    }
                }
            }
        }
    }

    @ModifyExpressionValue(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="CONSTANT", args={"floatValue=10.0F"}, ordinal=0)})
    public float changeIFrames(float constant) {
        return constant - 10.0f;
    }

    @WrapOperation(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void modifyKB(LivingEntity instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0, argsOnly=true) DamageSource source, @Local(argsOnly=true) float amount, @Share(value="blocked") LocalBooleanRef bl) {
        if (bl.get() && amount > 0.0f) {
            this.indicateDamage(e, f);
        }
        Combatify.CONFIG.knockbackMode().runKnockback(instance, source, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @ModifyExpressionValue(method={"startUsingItem(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isUsingItem()Z")})
    public boolean addCooldownCheck(boolean original, @Local(ordinal=0) ItemStack itemStack) {
        return original || MethodHandler.getCooldowns(this.thisEntity).isOnCooldown(itemStack.getItem());
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;getPierceLevel()B")})
    public byte isDamageSourceBlocked(byte original) {
        return Combatify.CONFIG.arrowDisableMode().pierceArrowsBlocked() ? (byte)0 : original;
    }

    @ModifyReturnValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="RETURN", ordinal=0)})
    public boolean isDamageSourceBlocked(boolean original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 360.0 || original;
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;dot(Lnet/minecraft/world/phys/Vec3;)D")})
    public double modifyDotResultToGetRadians(double original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 180.0 ? original : Math.acos(original) / -1.0;
    }

    @ModifyExpressionValue(method={"isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="CONSTANT", args={"doubleValue=0.0"}, ordinal=1)})
    public double modifyCompareValue(double original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return Combatify.CONFIG.shieldProtectionArc() == 180.0 ? original : Math.toRadians(Combatify.CONFIG.shieldProtectionArc()) / -1.0;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return true;
    }

    @Override
    public void combatify$setUseItemRemaining(int ticks) {
        this.useItemRemaining = ticks;
    }
}

