/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    public static final Multimap<String, MatchingMods> incompatibleMixins;
    public static final Multimap<String, MatchingMods> modSpecificMixins;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Logger logger = LogManager.getLogger((String)"Combatify");
        if (this.mentionsActiveMods(incompatibleMixins, mixinClassName)) {
            logger.warn("[{}] {} marked incompatible with mixin \"{}\", cancelling application.", (Object)this.getClass().getSimpleName(), (Object)this.getFirstMentionedActiveMod(incompatibleMixins, mixinClassName).forIncompatible(), (Object)mixinClassName);
            return false;
        }
        if (modSpecificMixins.containsKey((Object)mixinClassName)) {
            if (this.mentionsActiveMods(modSpecificMixins, mixinClassName)) {
                logger.info("[{}] Loading mod-specific mixin \"{}\" since {}.", (Object)this.getClass().getSimpleName(), (Object)mixinClassName, (Object)this.getFirstMentionedActiveMod(modSpecificMixins, mixinClassName).forModSpecific());
                return true;
            }
            return false;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public MatchingMods getFirstMentionedActiveMod(Multimap<String, MatchingMods> toRead, String mixinClassName) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (toRead.containsKey((Object)mixinClassName)) {
            for (MatchingMods modId : toRead.get((Object)mixinClassName)) {
                if (!modId.areModsLoaded(fabricLoader)) continue;
                return modId;
            }
        }
        return null;
    }

    public boolean mentionsActiveMods(Multimap<String, MatchingMods> toRead, String mixinClassName) {
        return this.getFirstMentionedActiveMod(toRead, mixinClassName) != null;
    }

    static {
        ImmutableMultimap.Builder incompatible = ImmutableMultimap.builder();
        ImmutableMultimap.Builder modSpecific = ImmutableMultimap.builder();
        incompatible.put((Object)"net.atlas.combatify.mixin.client.ArmHeightMixin", (Object)new MatchingMods("cookeymod"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.appleskin.FoodHelperMixin", (Object)new MatchingMods("appleskin"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.appleskin.HUDOverlayHandlerMixin", (Object)new MatchingMods("appleskin"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.appleskin.HungerOverlayMixin", (Object)new MatchingMods("appleskin"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.appleskin.SaturationOverlayMixin", (Object)new MatchingMods("appleskin"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.cookeymod.AddForce100PercentRechargeMixin", (Object)new MatchingMods("cookeymod"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.cookeymod.ArmHeightFixMixin", (Object)new MatchingMods("cookeymod"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.cookeymod.DisableMissedAttackRecoveryMixin", (Object)new MatchingMods("cookeymod"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.polymer.PolymerComponentMixin", (Object)new MatchingMods("polymer-core"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.sodium.SodiumGameOptionPagesMixin", (Object)new MatchingMods("sodium"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.viafabricplus.Attributes1_20_5Mixin", (Object)new MatchingMods("viafabricplus"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.viafabricplus.EntityPacketRewriter1_20_5Mixin", (Object)new MatchingMods("viafabricplus"));
        modSpecific.put((Object)"net.atlas.combatify.mixin.compatibility.viafabricplus.ProtocolCombatTest8cTo1_16_2PacketHandlersMixin", (Object)new MatchingMods("viafabricplus"));
        incompatibleMixins = incompatible.build();
        modSpecificMixins = modSpecific.build();
    }

    public record MatchingMods(String[] mods) {
        public boolean areModsLoaded(FabricLoader fabricLoader) {
            for (String mod : this.mods) {
                if (fabricLoader.isModLoaded(mod)) continue;
                return false;
            }
            return true;
        }

        public String forModSpecific() {
            return this.mods.length == 1 ? "mod \"" + this.mods[0] + "\" is present" : "mods \"" + Arrays.toString(this.mods) + "\" are present";
        }

        public String forIncompatible() {
            return this.mods.length == 1 ? "Mod \"" + this.mods[0] + "\" is" : "Mods \"" + Arrays.toString(this.mods) + "\" are";
        }
    }
}

