/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.MobExtensions;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.mixin.accessor.CombatTrackerAccessor;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity
implements MobExtensions {
    @Unique
    private double targetDist = 2.147483647E9;
    @Unique
    private boolean overrideSprintLogic = false;
    @Shadow
    @Final
    private static EntityDataAccessor<Byte> DATA_MOB_FLAGS_ID;
    @Shadow
    @Final
    private static double DEFAULT_ATTACK_REACH;

    @Shadow
    @Nullable
    public abstract LivingEntity getTarget();

    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        AttributeInstance attackSpeed = this.getAttribute(Attributes.ATTACK_SPEED);
        if (attackSpeed != null && this.getType().is(Combatify.HAS_BOOSTED_SPEED)) {
            attackSpeed.setBaseValue(Combatify.CONFIG.baseHandAttackSpeed() - 0.5);
        }
    }

    @ModifyReturnValue(method={"createMobAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder createAttributes(AttributeSupplier.Builder original) {
        return original.add(Attributes.ENTITY_INTERACTION_RANGE, DEFAULT_ATTACK_REACH).add(Attributes.ATTACK_SPEED, 1.0);
    }

    @Inject(method={"baseTick()V"}, at={@At(value="HEAD")})
    public void addReachUpdate(CallbackInfo ci) {
        AttributeInstance attackSpeed;
        if (this.firstTick && (attackSpeed = this.getAttribute(Attributes.ATTACK_SPEED)) != null && this.getType().is(Combatify.HAS_BOOSTED_SPEED)) {
            attackSpeed.setBaseValue(Combatify.CONFIG.baseHandAttackSpeed() - 0.5);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    public void updateSprinting(CallbackInfo ci) {
        if (this.isBlocking()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.4, 1.0, 0.4));
            this.setSprinting(false);
        }
        if (!this.level().isClientSide) {
            Object difficulty;
            LivingEntity target = this.getTarget();
            if (!this.overrideSprintLogic) {
                if (target != null && !this.isBaby()) {
                    double targetDistO = this.targetDist;
                    this.targetDist = this.distanceToSqr((Entity)target);
                    if (this.tickCount % 10 == 0) {
                        sprintingMob = this;
                        if (sprintingMob.isPassenger() && (vehicle = sprintingMob.getVehicle()) != null) {
                            sprintingMob = vehicle;
                        }
                        boolean meetsSprintConditions = !this.isUsingItem() && !this.isBlocking() && !this.hasEffect(MobEffects.BLINDNESS) && sprintingMob.canSprint() && !this.isFallFlying();
                        double change = targetDistO - this.targetDist;
                        difficulty = this.level().getDifficulty();
                        sprintingMob.setSprinting((this.getHealth() <= MethodHandler.getPinchHealth(this, (Difficulty)difficulty) || MethodHandler.shouldSprintToCloseInOnTarget((Difficulty)difficulty, change) || MethodHandler.shouldSprintFromDistance((Difficulty)difficulty, this.targetDist)) && meetsSprintConditions);
                    }
                } else {
                    this.targetDist = 2.147483647E9;
                    sprintingMob = this;
                    if (sprintingMob.isPassenger() && (vehicle = sprintingMob.getVehicle()) != null) {
                        sprintingMob = vehicle;
                    }
                    sprintingMob.setSprinting(false);
                }
            }
            if (Combatify.CONFIG.mobsCanGuard().booleanValue() && this.tickCount % 5 == 0) {
                boolean shouldGuard = ((CombatTrackerAccessor)this.getCombatTracker()).isInCombat();
                boolean isInHittingRange = false;
                for (CombatEntry combatEntry : ((CombatTrackerAccessor)this.getCombatTracker()).getEntries()) {
                    Mob mob;
                    if (combatEntry.source().is(DamageTypeTags.IS_PROJECTILE)) {
                        isInHittingRange = true;
                        break;
                    }
                    difficulty = combatEntry.source().getEntity();
                    if (!(difficulty instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)difficulty;
                    for (EquipmentSlot equipmentSlot : Arrays.stream(EquipmentSlot.values()).filter(arg_0 -> ((EquipmentSlotGroup)EquipmentSlotGroup.HAND).test(arg_0)).toList()) {
                        Item heldItem = livingEntity.getItemBySlot(equipmentSlot).getItem();
                        if (!(heldItem instanceof ProjectileItem) && !(heldItem instanceof ProjectileWeaponItem)) continue;
                        isInHittingRange = true;
                        break;
                    }
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        double distanceToAttacker = Math.sqrt(player.distanceToSqr(MethodHandler.getNearestPointTo(this.getBoundingBox(), player.getEyePosition())));
                        double d = MethodHandler.getCurrentAttackReachWithoutChargedReach(player);
                        double d2 = Combatify.CONFIG.chargedReach() != false ? MethodHandler.getChargedReach(player.getItemInHand(InteractionHand.MAIN_HAND)) : 0.0;
                        double reach = d + d2;
                        if (!(distanceToAttacker <= reach)) continue;
                        isInHittingRange = true;
                        continue;
                    }
                    if (!(livingEntity instanceof Mob) || !(mob = (Mob)livingEntity).isWithinMeleeAttackRange((LivingEntity)this)) continue;
                    isInHittingRange = true;
                    break;
                }
                if (!(this.canGuard() && (shouldGuard &= isInHittingRange) || !this.combatify$isGuarding())) {
                    this.stopGuarding();
                } else if (this.canGuard() && shouldGuard && !this.combatify$isGuarding()) {
                    this.startGuarding();
                }
            }
        }
    }

    @Override
    public boolean combatify$overrideSprintLogic() {
        return this.overrideSprintLogic;
    }

    @Override
    public void combatify$setOverrideSprintLogic(boolean overrideSprintLogic) {
        this.overrideSprintLogic = overrideSprintLogic;
    }

    @WrapOperation(method={"getAttackBoundingBox()Lnet/minecraft/world/phys/AABB;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;")})
    public AABB modReach(AABB instance, double d, double e, double f, Operation<AABB> original) {
        AttributeInstance attackReach = this.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        if (Combatify.CONFIG.mobsUsePlayerAttributes().booleanValue() && attackReach != null) {
            return (AABB)original.call(new Object[]{instance, attackReach.getValue(), e, attackReach.getValue()});
        }
        return (AABB)original.call(new Object[]{instance, d, e, f});
    }

    @WrapOperation(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;modifyDamage(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    public float getDamageBonus(ServerLevel serverLevel, ItemStack itemStack, Entity entity, DamageSource damageSource, float f, Operation<Float> original) {
        return CustomEnchantmentHelper.modifyDamage(serverLevel, itemStack, entity, damageSource, f, original);
    }

    @WrapOperation(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void knockback(LivingEntity instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0) DamageSource damageSource) {
        Combatify.CONFIG.knockbackMode().runKnockback(instance, damageSource, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @Unique
    protected boolean canGuard() {
        return Combatify.CONFIG.mobsCanGuard() != false && this.onGround() && !MethodHandler.getBlockingType(this.getOffhandItem()).isEmpty() && !MethodHandler.getCooldowns((LivingEntity)Mob.class.cast(this)).isOnCooldown(this.getOffhandItem().getItem());
    }

    @Unique
    public void startGuarding() {
        this.startUsingItem(InteractionHand.OFF_HAND);
        this.setSprinting(false);
        this.setGuarding(true);
    }

    @Unique
    public void stopGuarding() {
        this.stopUsingItem();
        this.setGuarding(false);
    }

    @Unique
    public void setGuarding(boolean p_21562_) {
        byte b0 = (Byte)this.entityData.get(DATA_MOB_FLAGS_ID);
        this.entityData.set(DATA_MOB_FLAGS_ID, (Object)(p_21562_ ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    @Override
    public boolean combatify$isGuarding() {
        return ((Byte)this.entityData.get(DATA_MOB_FLAGS_ID) & 8) != 0;
    }

    @ModifyExpressionValue(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;getKnockback(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;)F")})
    public float addSprintKB(float original) {
        return original + (Combatify.CONFIG.mobsCanSprint() != false && this.isSprinting() ? 1.0f : 0.0f);
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")})
    public void resetSprint(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (this.isSprinting()) {
            this.setSprinting(false);
        }
    }

    @WrapOperation(method={"populateDefaultEquipmentSlots(Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/DifficultyInstance;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EquipmentSlot;getType()Lnet/minecraft/world/entity/EquipmentSlot$Type;")})
    public EquipmentSlot.Type fakeType(EquipmentSlot instance, Operation<EquipmentSlot.Type> original) {
        if (Combatify.CONFIG.mobsCanGuard().booleanValue() && instance == EquipmentSlot.OFFHAND) {
            return EquipmentSlot.Type.HUMANOID_ARMOR;
        }
        return (EquipmentSlot.Type)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"populateDefaultEquipmentEnchantments(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/util/RandomSource;Lnet/minecraft/world/DifficultyInstance;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EquipmentSlot;getType()Lnet/minecraft/world/entity/EquipmentSlot$Type;")})
    public EquipmentSlot.Type fakeType1(EquipmentSlot instance, Operation<EquipmentSlot.Type> original) {
        if (Combatify.CONFIG.mobsCanGuard().booleanValue() && instance == EquipmentSlot.OFFHAND) {
            return EquipmentSlot.Type.HUMANOID_ARMOR;
        }
        return (EquipmentSlot.Type)original.call(new Object[]{instance});
    }

    @ModifyReturnValue(method={"getEquipmentForSlot(Lnet/minecraft/world/entity/EquipmentSlot;I)Lnet/minecraft/world/item/Item;"}, at={@At(value="RETURN")})
    private static Item enableShields(Item original, @Local(ordinal=0, argsOnly=true) EquipmentSlot equipmentSlot, @Local(ordinal=0, argsOnly=true) int level) {
        if (Combatify.CONFIG.mobsCanGuard().booleanValue() && equipmentSlot == EquipmentSlot.OFFHAND) {
            if (Combatify.CONFIG.tieredShields().booleanValue()) {
                return switch (level) {
                    case 1 -> (Item)TieredShieldItem.GOLD_SHIELD.get();
                    case 3 -> (Item)TieredShieldItem.IRON_SHIELD.get();
                    case 4 -> (Item)TieredShieldItem.DIAMOND_SHIELD.get();
                    default -> Items.SHIELD;
                };
            }
            return Items.SHIELD;
        }
        return original;
    }
}

