/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.ServerPlayerExtensions;
import net.atlas.combatify.mixin.PlayerMixin;
import net.atlas.combatify.util.CombatUtil;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements ServerPlayerExtensions {
    @Unique
    private boolean retainAttack;
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Unique
    public final ServerPlayer player = (ServerPlayer)ServerPlayer.class.cast(this);

    @Shadow
    public abstract void swing(InteractionHand var1);

    @Shadow
    public abstract Entity getCamera();

    public ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"getEnchantedDamage(Lnet/minecraft/world/entity/Entity;FLnet/minecraft/world/damagesource/DamageSource;)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;modifyDamage(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    public float modTrident(ServerLevel serverLevel, ItemStack itemStack, Entity target, DamageSource damageSource, float f, Operation<Float> original) {
        return CustomEnchantmentHelper.modifyDamage(serverLevel, itemStack, target, damageSource, f, original);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void hitreg(CallbackInfo ci) {
        CombatUtil.setPosition((ServerPlayer)this);
        if (Combatify.unmoddedPlayers.contains(this.getUUID()) && this.player.combatify$isAttackAvailable(-1.0f) && this.retainAttack) {
            this.retainAttack = false;
            this.combatify$customSwing(InteractionHand.MAIN_HAND);
            Entity entity = this.getCamera();
            Vec3 eyePos = entity.getEyePosition(1.0f);
            Vec3 viewVector = entity.getViewVector(1.0f);
            double reach = this.entityInteractionRange();
            double sqrReach = reach * reach;
            Vec3 adjPos = eyePos.add(viewVector.x * reach, viewVector.y * reach, viewVector.z * reach);
            AABB rayBB = entity.getBoundingBox().expandTowards(viewVector.scale(reach)).inflate(1.0, 1.0, 1.0);
            Object hitResult = entity.pick(reach, 1.0f, false);
            double i = hitResult.getLocation().distanceToSqr(eyePos);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)adjPos, (AABB)rayBB, entityx -> !entityx.isSpectator() && entityx.isPickable(), (double)sqrReach);
            hitResult = entityHitResult != null && entityHitResult.getLocation().distanceToSqr(eyePos) < i ? entityHitResult : MethodHandler.redirectResult((Player)this.player, hitResult);
            if (hitResult.getType() == HitResult.Type.ENTITY) {
                this.connection.handleInteract(ServerboundInteractPacket.createAttackPacket((Entity)((EntityHitResult)hitResult).getEntity(), (boolean)this.isShiftKeyDown()));
            } else if (hitResult.getType() == HitResult.Type.MISS) {
                this.combatify$attackAir();
            }
        }
    }

    @Inject(method={"drop(Z)Z"}, at={@At(value="HEAD")})
    public void disableOnDropItem(boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (Combatify.unmoddedPlayers.contains(this.getUUID())) {
            Combatify.isPlayerAttacking.put(this.getUUID(), false);
        }
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeReset(InteractionHand hand, CallbackInfo ci) {
        super.swing(hand);
        if (Combatify.unmoddedPlayers.contains(this.getUUID())) {
            if (Combatify.isPlayerAttacking.get(this.getUUID()).booleanValue()) {
                this.handleInteract();
            }
            Combatify.isPlayerAttacking.put(this.getUUID(), true);
        }
        ci.cancel();
    }

    @Unique
    public void handleInteract() {
        if (this.retainAttack) {
            return;
        }
        if (!this.combatify$isAttackAvailable(0.0f)) {
            float var1 = this.player.getAttackStrengthScale(0.0f);
            if (var1 < 0.8f) {
                this.combatify$resetAttackStrengthTicker(!this.combatify$getMissedAttackRecovery());
                return;
            }
            if (var1 < 1.0f) {
                this.retainAttack = true;
                return;
            }
        }
        this.combatify$attackAir();
    }

    @Inject(method={"updatePlayerAttributes()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getAttribute(Lnet/minecraft/core/Holder;)Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;", ordinal=1)}, cancellable=true)
    public void removeCreativeReach(CallbackInfo ci) {
        AttributeInstance attackRange = this.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        float strengthScale = this.player.getAttackStrengthScale(1.0f);
        MethodHandler.updatePlayerReach((Player)this.player, attackRange, strengthScale);
        if (!Combatify.CONFIG.creativeAttackReach().booleanValue()) {
            ci.cancel();
        }
    }

    @Override
    public boolean combatify$isRetainingAttack() {
        return this.retainAttack;
    }

    @Override
    public void combatify$setRetainAttack(boolean retain) {
        this.retainAttack = retain;
    }
}

