/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.CombatifyClient;
import net.atlas.combatify.extensions.MinecraftExtensions;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftExtensions {
    @Unique
    public boolean retainAttack;
    @Unique
    public HitResult aimAssistHitResult;
    @Unique
    public int aimAssistTicks;
    @Shadow
    @Final
    public Options options;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    public int missTime;
    @Shadow
    @Nullable
    public Screen screen;
    @Shadow
    @Final
    public MouseHandler mouseHandler;

    @Shadow
    protected abstract boolean startAttack();

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;pick(F)V")})
    public void injectAimAssistDecrement(CallbackInfo ci) {
        if (--this.aimAssistTicks <= 0) {
            this.aimAssistHitResult = null;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void injectSomething(CallbackInfo ci) {
        if (this.screen != null) {
            this.retainAttack = false;
        }
    }

    @ModifyExpressionValue(method={"handleKeybinds()V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z", ordinal=0))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;consumeClick()Z", ordinal=0)})
    public boolean allowBlockHitting(boolean original) {
        if (!original || !Combatify.getState().equals((Object)Combatify.CombatifyState.COMBATIFY)) {
            return false;
        }
        if (this.player != null) {
            boolean bl;
            ItemStack stack = this.player.getUseItem();
            boolean bl2 = bl = MethodHandler.getBlockingType(stack).canBlockHit() && !MethodHandler.getBlockingType(stack).isEmpty();
            if (bl && this.player.combatify$isAttackAvailable(0.0f) && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK) {
                this.startAttack();
            }
            return bl;
        }
        return true;
    }

    @ModifyExpressionValue(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    public boolean checkIfCrouch(boolean original) {
        if (this.player != null && !Combatify.CONFIG.canInteractWhenCrouchShield().booleanValue()) {
            original |= this.player.isBlocking();
        }
        return original;
    }

    @ModifyExpressionValue(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isDown()Z", ordinal=4)})
    public boolean redirectContinue(boolean original) {
        return original || this.retainAttack;
    }

    @WrapOperation(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;startAttack()Z")})
    public boolean redirectAttack(Minecraft instance, Operation<Boolean> original) {
        if (this.missTime <= 0 && this.hitResult != null) {
            assert (this.player != null);
            if (!this.player.combatify$isAttackAvailable(0.0f) && this.hitResult.getType() != HitResult.Type.BLOCK) {
                float var1 = this.player.getAttackStrengthScale(0.0f);
                if (var1 < 0.8f) {
                    return false;
                }
                if (var1 < 1.0f) {
                    this.retainAttack = true;
                    return false;
                }
            }
        }
        return (Boolean)original.call(new Object[]{instance}) != false && Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA);
    }

    @ModifyExpressionValue(method={"startAttack()Z"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;"))}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;hitResult:Lnet/minecraft/world/phys/HitResult;")})
    public HitResult modifyHitResult(HitResult original) {
        if (this.aimAssistHitResult != null && original.getType() != HitResult.Type.ENTITY) {
            original = this.aimAssistHitResult;
        }
        return original;
    }

    @WrapOperation(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;attack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V")})
    public void addReachCheck(MultiPlayerGameMode instance, Player player, Entity entity, Operation<Void> original) {
        if (player.getEyePosition().distanceTo(MethodHandler.getNearestPointTo(entity.getBoundingBox(), player.getEyePosition())) <= MethodHandler.getCurrentAttackReach(player, 0.0f)) {
            original.call(new Object[]{instance, player, entity});
        } else {
            instance.combatify$swingInAir(player);
        }
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private void startAttack(CallbackInfoReturnable<Boolean> cir) {
        this.retainAttack = false;
    }

    @ModifyExpressionValue(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;hasMissTime()Z")})
    public boolean removeMissTime(boolean original) {
        if (Combatify.CONFIG.hasMissTime().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return false;
    }

    @ModifyExpressionValue(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", ordinal=0)})
    public boolean ensureNotReachingAround(boolean original) {
        if (original) {
            return true;
        }
        assert (this.hitResult != null);
        return ((BlockHitResult)this.hitResult).combatify$isLedgeEdge();
    }

    @WrapOperation(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;resetAttackStrengthTicker()V")})
    public void redirectReset(LocalPlayer instance, Operation<Void> original) {
        if (this.gameMode != null) {
            this.gameMode.combatify$swingInAir((Player)instance);
        }
    }

    @Inject(method={"continueAttack(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void continueAttack(boolean bl, CallbackInfo ci) {
        boolean bl2;
        boolean bl1 = this.screen == null && (this.options.keyAttack.isDown() || this.retainAttack) && this.mouseHandler.isMouseGrabbed();
        boolean bl3 = bl2 = (Boolean)CombatifyClient.autoAttack.get() != false && Combatify.CONFIG.autoAttackAllowed() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || this.retainAttack;
        if (this.player != null && this.missTime <= 0) {
            boolean cannotPerform;
            boolean bl4 = cannotPerform = this.player.isUsingItem() || Combatify.CONFIG.canInteractWhenCrouchShield() == false && this.player.isBlocking();
            if (!cannotPerform) {
                boolean canAutoAttack;
                boolean bl5 = Combatify.CONFIG.canAttackEarly() == false ? this.player.combatify$isAttackAvailable(-1.0f) : (canAutoAttack = this.player.getAttackStrengthScale(-1.0f) >= 1.0f);
                if (bl1 && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK && this.aimAssistHitResult == null) {
                    this.retainAttack = false;
                } else if (bl1 && canAutoAttack && bl2) {
                    this.startAttack();
                    ci.cancel();
                }
            }
        }
    }

    @ModifyExpressionValue(method={"continueAttack(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z", ordinal=0)})
    public boolean ensureNotReachingAroundContinue(boolean original) {
        if (original) {
            return true;
        }
        assert (this.hitResult != null);
        return ((BlockHitResult)this.hitResult).combatify$isLedgeEdge() || this.aimAssistHitResult != null;
    }

    @ModifyExpressionValue(method={"continueAttack(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    public boolean alterResult(boolean original) {
        if (this.player != null && !Combatify.CONFIG.canInteractWhenCrouchShield().booleanValue()) {
            original |= this.player.isBlocking();
        }
        return original;
    }

    @Override
    public void combatify$setAimAssistHitResult(@Nullable HitResult aimAssistHitResult) {
        this.aimAssistHitResult = aimAssistHitResult;
        this.aimAssistTicks = aimAssistHitResult != null ? Combatify.CONFIG.aimAssistTicks() : 0;
    }
}

