/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CombatUtil {
    public static int savedLocationTicks = 9;

    public static boolean allowReach(ServerPlayer attacker, ServerPlayer target) {
        Vec3 eyePosition = attacker.getEyePosition(0.0f);
        double reach = MethodHandler.getCurrentAttackReach((Player)attacker, 1.0f);
        reach += 0.75;
        reach *= reach;
        if (CombatUtil.canReach(eyePosition, target.getBoundingBox(), reach)) {
            return true;
        }
        PlayerData victimData = PlayerData.get(target);
        for (AABB boundingBox : victimData.previousPositions) {
            if (boundingBox == null || !CombatUtil.canReach(eyePosition, boundingBox, reach)) continue;
            return true;
        }
        return false;
    }

    private static boolean canReach(Vec3 eyePosition, AABB boundingBox, double reach) {
        return eyePosition.distanceToSqr(MethodHandler.getNearestPointTo(boundingBox, eyePosition)) < reach;
    }

    public static void setPosition(ServerPlayer player) {
        PlayerData playerData = PlayerData.get(player);
        ++playerData.positionIndex;
        if (playerData.positionIndex >= playerData.previousPositions.length) {
            playerData.positionIndex = 0;
        }
        playerData.previousPositions[playerData.positionIndex] = player.getBoundingBox();
    }
}

