/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.custom.Blocker;
import net.atlas.combatify.component.custom.CanSweep;
import net.atlas.combatify.config.ConfigurableEntityData;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.item.LongSwordItem;
import net.atlas.combatify.mixin.accessor.LivingEntityAccessor;
import net.atlas.combatify.util.FakeUseItem;
import net.atlas.combatify.util.blocking.BlockingType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class MethodHandler {
    public static boolean checkSweepAttack(Player player) {
        boolean sweep;
        float charge = Combatify.CONFIG.chargedAttacks() != false ? 1.95f : 0.9f;
        boolean sweepingItem = ((CanSweep)player.getMainHandItem().getOrDefault(CustomDataComponents.CAN_SWEEP, (Object)CanSweep.DISABLED)).enabled();
        boolean bl = sweep = MethodHandler.getAttackStrengthScale((LivingEntity)player, 1.0f) > charge && (player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) > 0.0 || sweepingItem);
        if (!Combatify.CONFIG.sweepWithSweeping().booleanValue()) {
            return sweepingItem && sweep;
        }
        return sweep;
    }

    public static void tryAirSweep(Player attacker) {
        float attackDamage = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        if (attackDamage > 0.0f && MethodHandler.checkSweepAttack(attacker) && Combatify.CONFIG.canSweepOnMiss().booleanValue()) {
            float currentAttackReach = (float)MethodHandler.getCurrentAttackReach(attacker, 1.0f);
            double dirX = (double)(-Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180)))) * 2.0;
            double dirZ = (double)Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180))) * 2.0;
            AABB sweepBox = attacker.getBoundingBox().inflate(1.0, 0.25, 1.0).move(dirX, 0.0, dirZ);
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Swept");
            }
            MethodHandler.sweepAttack(attacker, sweepBox, currentAttackReach, attackDamage, (TriFunction<LivingEntity, Float, DamageSource, Float>)((TriFunction)(arg_0, arg_1, arg_2) -> attacker.combatify$enchantedDamageForSweep(arg_0, arg_1, arg_2)), null);
        }
    }

    public static int changeIFrames(int original, DamageSource source) {
        LivingEntity livingEntity;
        Entity entity2 = source.getEntity();
        int invulnerableTime = original - 10;
        if (!Combatify.CONFIG.instaAttack().booleanValue() && Combatify.CONFIG.iFramesBasedOnWeapon().booleanValue() && entity2 instanceof LivingEntity && (!((livingEntity = (LivingEntity)entity2).getAttributeValue(Attributes.ATTACK_SPEED) - 1.5 >= 20.0) || Combatify.CONFIG.attackSpeed().booleanValue())) {
            int base = Math.min(MethodHandler.getCurrentItemAttackStrengthDelay(livingEntity), invulnerableTime);
            int n = invulnerableTime = livingEntity instanceof Player && Combatify.CONFIG.canAttackEarly() == false ? Math.max(2, base - 2) : base;
        }
        if (source.is(DamageTypeTags.IS_PROJECTILE) && !Combatify.CONFIG.projectilesHaveIFrames().booleanValue()) {
            invulnerableTime = 0;
        }
        if (source.is(DamageTypes.MAGIC) && !Combatify.CONFIG.magicHasIFrames().booleanValue()) {
            invulnerableTime = 0;
        }
        return invulnerableTime;
    }

    public static float getAttackStrengthScale(LivingEntity entity, float baseTime) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getAttackStrengthScale(baseTime);
        }
        return Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f;
    }

    public static Vec3 getNearestPointTo(AABB box, Vec3 vec3) {
        double x = Mth.clamp((double)vec3.x, (double)box.minX, (double)box.maxX);
        double y = Mth.clamp((double)vec3.y, (double)box.minY, (double)box.maxY);
        double z = Mth.clamp((double)vec3.z, (double)box.minZ, (double)box.maxZ);
        return new Vec3(x, y, z);
    }

    public static double calculateValueBlacklistChargedReachModifier(@Nullable AttributeInstance attributeInstance) {
        double attributeInstanceBaseValue = attributeInstance.getBaseValue();
        for (AttributeModifier attributeModifier : attributeInstance.getModifiersOrEmpty(AttributeModifier.Operation.ADD_VALUE)) {
            if (attributeModifier.is(Combatify.CHARGED_REACH_ID)) continue;
            attributeInstanceBaseValue += attributeModifier.amount();
        }
        return MethodHandler.calculateValueFromBase(attributeInstance, attributeInstanceBaseValue);
    }

    public static double calculateValue(@Nullable AttributeInstance attributeInstance, float damageBonus) {
        if (attributeInstance == null) {
            return damageBonus;
        }
        double attributeInstanceBaseValue = attributeInstance.getBaseValue() + (double)damageBonus;
        for (AttributeModifier attributeModifier : attributeInstance.getModifiersOrEmpty(AttributeModifier.Operation.ADD_VALUE)) {
            attributeInstanceBaseValue += attributeModifier.amount();
        }
        return MethodHandler.calculateValueFromBase(attributeInstance, attributeInstanceBaseValue);
    }

    public static double calculateValueFromBase(@Nullable AttributeInstance attributeInstance, double attributeInstanceBaseValue) {
        if (attributeInstance == null) {
            return attributeInstanceBaseValue;
        }
        double attributeInstanceFinalValue = attributeInstanceBaseValue;
        for (AttributeModifier attributeModifier2 : attributeInstance.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
            attributeInstanceFinalValue += attributeInstanceBaseValue * attributeModifier2.amount();
        }
        for (AttributeModifier attributeModifier2 : attributeInstance.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
            attributeInstanceFinalValue *= 1.0 + attributeModifier2.amount();
        }
        return ((Attribute)attributeInstance.getAttribute().value()).sanitizeValue(attributeInstanceFinalValue);
    }

    public static float getFatigueForTime(int f) {
        if (f < 60 || !Combatify.CONFIG.bowFatigue().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return 0.5f;
        }
        return f >= 200 ? 10.5f : 0.5f + 10.0f * (float)(f - 60) / 140.0f;
    }

    public static void sweepAttack(Player player, AABB box, float reach, float damage, TriFunction<LivingEntity, Float, DamageSource, Float> enchantFunction, Entity entity) {
        float sweepingDamageRatio = (float)(1.0 + player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * (double)damage);
        List livingEntities = player.level().getEntitiesOfClass(LivingEntity.class, box);
        DamageSource damageSource = player.damageSources().playerAttack(player);
        for (LivingEntity livingEntity : livingEntities) {
            Level level;
            ArmorStand armorStand;
            if (livingEntity == player || livingEntity == entity || player.isAlliedTo((Entity)livingEntity) || livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).isMarker()) continue;
            if (Combatify.CONFIG.sweepingNegatedForTamed().booleanValue()) {
                if (livingEntity instanceof OwnableEntity) {
                    OwnableEntity ownableEntity = (OwnableEntity)livingEntity;
                    if (player.getUUID().equals(ownableEntity.getOwnerUUID())) continue;
                }
                if (livingEntity.is(player.getVehicle()) || livingEntity.isPassengerOfSameVehicle((Entity)player)) continue;
            }
            float correctReach = reach + livingEntity.getBbWidth() * 0.5f;
            livingEntity.hurt(damageSource, ((Float)enchantFunction.apply((Object)livingEntity, (Object)Float.valueOf(sweepingDamageRatio), (Object)damageSource)).floatValue());
            if (!(player.distanceToSqr((Entity)livingEntity) < (double)(correctReach * correctReach)) || !((level = player.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            Combatify.CONFIG.knockbackMode().runKnockback(livingEntity, damageSource, 0.4, Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), -Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))), LivingEntity::knockback);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)livingEntity, (DamageSource)damageSource);
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
        player.sweepAttack();
    }

    public static double getKnockbackResistance(LivingEntity entity) {
        boolean delay;
        double knockbackRes = entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        ItemStack blockingItem = MethodHandler.getBlockingItem(entity).stack();
        boolean bl = delay = MethodHandler.getBlockingType(blockingItem).hasDelay() && Combatify.CONFIG.shieldDelay() > 0 && blockingItem.getUseDuration(entity) - entity.getUseItemRemainingTicks() < Combatify.CONFIG.shieldDelay();
        if (!blockingItem.isEmpty() && !delay) {
            Blocker blocker = MethodHandler.getBlocking(blockingItem);
            knockbackRes = !blocker.blockingType().defaultKbMechanics() ? Math.max(knockbackRes, (double)blocker.tooltip().getShieldKnockbackResistanceValue(blockingItem, entity.getRandom())) : Math.min(1.0, knockbackRes + (double)blocker.tooltip().getShieldKnockbackResistanceValue(blockingItem, entity.getRandom()));
        }
        return knockbackRes;
    }

    public static void knockback(LivingEntity entity, double strength, double x, double z) {
        double knockbackRes = MethodHandler.getKnockbackResistance(entity);
        if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
            entity.hasImpulse = true;
            Vec3 delta = entity.getDeltaMovement();
            while (x * x + z * z < 1.0E-5) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 diff = new Vec3(x, 0.0, z).normalize().scale(strength);
            entity.setDeltaMovement(delta.x / 2.0 - diff.x, entity.onGround() ? Math.min(0.4, strength * 0.75) : Math.min(0.4, delta.y + strength * 0.5), delta.z / 2.0 - diff.z);
        }
    }

    public static void midairKnockback(LivingEntity entity, double strength, double x, double z) {
        double knockbackRes = MethodHandler.getKnockbackResistance(entity);
        if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
            entity.hasImpulse = true;
            Vec3 delta = entity.getDeltaMovement();
            while (x * x + z * z < 1.0E-5) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 diff = new Vec3(x, 0.0, z).normalize().scale(strength);
            entity.setDeltaMovement(delta.x / 2.0 - diff.x, Math.min(0.4, strength * 0.75), delta.z / 2.0 - diff.z);
        }
    }

    public static void oldKnockback(LivingEntity entity, double strength, double x, double z) {
        double knockbackRes = MethodHandler.getKnockbackResistance(entity);
        if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
            entity.hasImpulse = true;
            Vec3 scaledDelta = entity.getDeltaMovement().scale(0.5);
            while (x * x + z * z < 1.0E-5) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 diff = new Vec3(x, 0.0, z).normalize().scale(strength);
            entity.setDeltaMovement(scaledDelta.x - diff.x, Math.min(0.4, scaledDelta.y + strength), scaledDelta.z - diff.z);
        }
    }

    public static void combatTest5Knockback(LivingEntity entity, double strength, double x, double z) {
        double knockbackRes = MethodHandler.getKnockbackResistance(entity);
        if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
            entity.hasImpulse = true;
            Vec3 delta = entity.getDeltaMovement();
            while (x * x + z * z < 1.0E-5) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            Vec3 diff = new Vec3(x, 0.0, z).normalize().scale(strength);
            entity.setDeltaMovement(delta.x / 2.0 - diff.x, entity.onGround() ? Math.min(0.4, strength) : Math.max(0.4, delta.y + strength * 0.5), delta.z / 2.0 - diff.z);
        }
    }

    public static HitResult pickCollisions(Entity entity, double reach) {
        Vec3 viewVector = entity.getViewVector(1.0f);
        Vec3 pos = entity.getEyePosition(1.0f);
        Vec3 endPos = pos.add(viewVector.scale(reach));
        return entity.level().clip(new ClipContext(pos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static EntityHitResult rayTraceEntity(Entity entity, float partialTicks, double blockReachDistance) {
        Vec3 from = entity.getEyePosition(partialTicks);
        Vec3 look = entity.getViewVector(partialTicks);
        Vec3 to = from.add(look.x * blockReachDistance, look.y * blockReachDistance, look.z * blockReachDistance);
        return ProjectileUtil.getEntityHitResult((Level)entity.level(), (Entity)entity, (Vec3)from, (Vec3)to, (AABB)new AABB(from, to), EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(e -> e != null && e.isPickable() && e instanceof LivingEntity));
    }

    public static HitResult redirectResult(Player player, HitResult instance) {
        if (Combatify.CONFIG.swingThroughGrass().booleanValue() && instance.getType() == HitResult.Type.BLOCK) {
            Entity entity;
            double reach = MethodHandler.getCurrentAttackReachWithoutChargedReach(player) + (Combatify.CONFIG.chargedReach() != false && !player.isCrouching() ? MethodHandler.getChargedReach(player.getItemInHand(InteractionHand.MAIN_HAND)) + 0.25 : 0.25);
            EntityHitResult rayTraceResult = MethodHandler.rayTraceEntity((Entity)player, 1.0f, reach);
            Entity entity2 = entity = rayTraceResult != null ? rayTraceResult.getEntity() : null;
            if (entity != null) {
                double dist = player.getEyePosition().distanceToSqr(MethodHandler.getNearestPointTo(entity.getBoundingBox(), player.getEyePosition()));
                if (dist > (reach *= reach)) {
                    return instance;
                }
                double distanceTo = player.distanceTo(rayTraceResult.getEntity());
                HitResult newResult = MethodHandler.pickCollisions((Entity)player, distanceTo);
                if (newResult.getType() != HitResult.Type.MISS) {
                    return instance;
                }
                return rayTraceResult;
            }
            return instance;
        }
        return instance;
    }

    public static void hurtCurrentlyUsedShield(LivingEntity livingEntity, float f) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        FakeUseItem fakeUseItem = MethodHandler.getBlockingItem((LivingEntity)player);
        ItemStack blockingItem = fakeUseItem.stack();
        if (!blockingItem.isEmpty()) {
            if (!player.level().isClientSide) {
                player.awardStat(Stats.ITEM_USED.get((Object)blockingItem.getItem()));
            }
            if (f >= 3.0f) {
                int i = 1 + Mth.floor((float)f);
                InteractionHand interactionHand = fakeUseItem.useHand();
                blockingItem.hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
                fakeUseItem = MethodHandler.getBlockingItem((LivingEntity)player);
                if (fakeUseItem.stack().isEmpty()) {
                    if (interactionHand == InteractionHand.MAIN_HAND) {
                        player.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    } else {
                        player.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    }
                    if (fakeUseItem.isReal()) {
                        ((LivingEntityAccessor)player).setUseItem(ItemStack.EMPTY);
                    }
                    player.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + player.level().random.nextFloat() * 0.4f);
                }
            }
        }
    }

    public static void disableShield(LivingEntity attacker, LivingEntity target, DamageSource damageSource, ItemStack blockingItem) {
        Level level;
        ItemStack attackingItem = attacker.getMainHandItem();
        double piercingLevel = MethodHandler.getPiercingLevel(attackingItem);
        Level level2 = target.level();
        if (!(level2 instanceof ServerLevel)) {
            piercingLevel += (double)CustomEnchantmentHelper.getBreach(attackingItem, attacker.getRandom());
        } else {
            ServerLevel serverLevel = (ServerLevel)level2;
            piercingLevel += (double)CustomEnchantmentHelper.getArmorModifier(serverLevel, attackingItem, (Entity)target, damageSource);
        }
        if (!Combatify.CONFIG.armorPiercingDisablesShields().booleanValue() && !(attacker.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof LongSwordItem)) {
            piercingLevel = 0.0;
        }
        boolean canDisable = attacker.canDisableShield() || piercingLevel > 0.0;
        float damage = Combatify.CONFIG.shieldDisableTime().floatValue();
        ConfigurableEntityData configurableEntityData = MethodHandler.forEntity((Entity)target);
        if (configurableEntityData != null && configurableEntityData.shieldDisableTime() != null) {
            damage = configurableEntityData.shieldDisableTime().floatValue();
        }
        if ((level = attacker.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (canDisable) {
                damage = CustomEnchantmentHelper.modifyShieldDisable(serverLevel, null, (Entity)target, (Entity)attacker, damageSource, damage);
            } else {
                float newDamage = CustomEnchantmentHelper.modifyShieldDisable(serverLevel, null, (Entity)target, (Entity)attacker, damageSource, 0.0f);
                if (newDamage > 0.0f) {
                    damage = newDamage;
                    canDisable = true;
                }
            }
        }
        if (canDisable && damage > 0.0f && MethodHandler.getBlockingType(blockingItem).canBeDisabled()) {
            if (piercingLevel > 0.0) {
                attacker.combatify$setPiercingNegation(piercingLevel);
            }
            MethodHandler.disableShield(target, damage, blockingItem);
        }
    }

    public static void arrowDisable(LivingEntity target, DamageSource damageSource, AbstractArrow abstractArrow, ItemStack blockingItem) {
        Level level;
        if (!MethodHandler.getBlockingType(blockingItem).canBeDisabled()) {
            return;
        }
        float damage = Combatify.CONFIG.shieldDisableTime().floatValue();
        ConfigurableEntityData configurableEntityData = MethodHandler.forEntity((Entity)target);
        if (configurableEntityData != null && configurableEntityData.shieldDisableTime() != null) {
            damage = configurableEntityData.shieldDisableTime().floatValue();
        }
        if ((level = target.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = CustomEnchantmentHelper.modifyShieldDisable(serverLevel, abstractArrow.getWeaponItem(), (Entity)target, (Entity)abstractArrow, damageSource, damage);
        }
        MethodHandler.disableShield(target, Math.max(damage, 0.0f), blockingItem);
    }

    public static void disableShield(LivingEntity target, float damage, ItemStack item) {
        MethodHandler.getCooldowns(target).addCooldown(item.getItem(), (int)(damage * 20.0f));
        if (Combatify.shields.contains(item.getItem())) {
            for (Item shield : Combatify.shields) {
                if (item.getItem() == shield) continue;
                MethodHandler.getCooldowns(target).addCooldown(shield, (int)(damage * 20.0f));
            }
        }
        target.stopUsingItem();
        target.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + target.level().random.nextFloat() * 0.4f);
        target.level().broadcastEntityEvent((Entity)target, (byte)30);
    }

    /*
     * Unable to fully structure code
     */
    public static FakeUseItem getBlockingItem(LivingEntity entity) {
        block5: {
            block4: {
                if (!entity.isUsingItem() || entity.getUseItem().isEmpty()) break block4;
                if (entity.getUseItem().getUseAnimation() == UseAnim.BLOCK) {
                    return new FakeUseItem(entity.getUseItem(), entity.getUsedItemHand(), true);
                }
                break block5;
            }
            if ((!entity.onGround() || !entity.isCrouching()) && !entity.isPassenger() || !entity.combatify$hasEnabledShieldOnCrouch() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) break block5;
            for (InteractionHand hand : InteractionHand.values()) {
                stack = entity.getItemInHand(hand);
                v0 = stillRequiresCharge = Combatify.CONFIG.shieldOnlyWhenCharged() != false && entity instanceof Player != false && (player = (Player)entity).getAttackStrengthScale(1.0f) < (float)Combatify.CONFIG.shieldChargePercentage().intValue() / 100.0f && MethodHandler.getBlockingType(stack).requireFullCharge() != false;
                if (!(entity instanceof Player)) ** GOTO lbl-1000
                player = (Player)entity;
                if (MethodHandler.getBlocking(stack).canUse(stack, entity.level(), player, hand)) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = canUse = false;
                }
                if (stillRequiresCharge || stack.isEmpty() || stack.getUseAnimation() != UseAnim.BLOCK || MethodHandler.isItemOnCooldown(entity, stack) || !MethodHandler.getBlockingType(stack).canCrouchBlock() || !canUse) continue;
                return new FakeUseItem(stack, hand, false);
            }
        }
        return new FakeUseItem(ItemStack.EMPTY, null, true);
    }

    public static boolean isItemOnCooldown(LivingEntity entity, ItemStack itemStack) {
        return MethodHandler.getCooldowns(entity).isOnCooldown(itemStack.getItem());
    }

    public static double updatePlayerReach(Player player, AttributeInstance attackRange, float strengthScale) {
        float charge;
        double chargedBonus = 0.0;
        float f = charge = Combatify.CONFIG.chargedAttacks() != false ? 1.95f : 0.9f;
        if (attackRange != null) {
            ItemStack item = player.getItemInHand(InteractionHand.MAIN_HAND);
            chargedBonus = MethodHandler.getChargedReach(item);
            AttributeModifier modifier = new AttributeModifier(Combatify.CHARGED_REACH_ID, chargedBonus, AttributeModifier.Operation.ADD_VALUE);
            if (strengthScale > charge && !player.isCrouching() && Combatify.CONFIG.chargedReach().booleanValue()) {
                attackRange.addOrUpdateTransientModifier(modifier);
            } else {
                attackRange.removeModifier(modifier);
            }
        }
        return chargedBonus;
    }

    public static double getCurrentAttackReach(Player player, float baseTime) {
        AttributeInstance attackRange = player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return attackRange != null ? attackRange.getValue() : 3.0;
        }
        double baseAttackRange = Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0;
        float strengthScale = player.getAttackStrengthScale(baseTime);
        double chargedBonus = MethodHandler.updatePlayerReach(player, attackRange, strengthScale);
        double d = strengthScale;
        double d2 = Combatify.CONFIG.chargedAttacks() != false ? 1.95 : 0.9;
        if (d < d2 || player.isCrouching() || !Combatify.CONFIG.chargedReach().booleanValue()) {
            chargedBonus = 0.0;
        }
        return attackRange != null ? attackRange.getValue() : baseAttackRange + chargedBonus;
    }

    public static double getCurrentAttackReachWithoutChargedReach(Player player) {
        AttributeInstance attackRange = player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE);
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return attackRange != null ? attackRange.getValue() : 3.0;
        }
        double baseAttackRange = Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0;
        return attackRange != null ? MethodHandler.calculateValueBlacklistChargedReachModifier(attackRange) : baseAttackRange;
    }

    public static void voidReturnLogic(ThrownTrident trident, EntityDataAccessor<Byte> ID_LOYALTY) {
        byte j = (Byte)trident.getEntityData().get(ID_LOYALTY);
        if (Combatify.CONFIG.tridentVoidReturn().booleanValue() && trident.getY() < (double)trident.level().getMinBuildHeight() && j > 0) {
            if (!trident.isAcceptibleReturnOwner()) {
                trident.discard();
            } else {
                trident.setNoPhysics(true);
                Vec3 vec3 = trident.getEyePosition().subtract(trident.position());
                trident.setPosRaw(trident.getX(), trident.getY() + vec3.y * 0.015 * (double)j, trident.getZ());
                if (trident.level().isClientSide) {
                    trident.yOld = trident.getY();
                }
                double d = 0.05 * (double)j;
                trident.setDeltaMovement(trident.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d)));
                if (trident.clientSideReturnTridentTickCount == 0) {
                    trident.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++trident.clientSideReturnTridentTickCount;
            }
        }
    }

    public static Vec3 project(Vec3 originalVec, Vec3 newVec) {
        Vec3 normalized = newVec.normalize();
        double d = originalVec.dot(newVec);
        return normalized.multiply(d, d, d);
    }

    public static void blockedByShield(ServerLevel serverLevel, LivingEntity target, LivingEntity attacker, DamageSource damageSource) {
        ItemStack blockingItem = MethodHandler.getBlockingItem(target).stack();
        EquipmentSlot equipmentSlot = target.getEquipmentSlotForItem(blockingItem);
        MethodHandler.getBlocking(blockingItem).doEffect(serverLevel, equipmentSlot, blockingItem, target, attacker, damageSource);
    }

    public static ItemCooldowns createItemCooldowns() {
        return new ItemCooldowns();
    }

    public static ItemCooldowns getCooldowns(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player.getCooldowns();
        }
        return livingEntity.combatify$getFallbackCooldowns();
    }

    public static boolean isMobGuarding(Mob mob) {
        return mob.combatify$isGuarding();
    }

    public static float getPinchHealth(LivingEntity livingEntity, Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case Difficulty.PEACEFUL, Difficulty.EASY -> 0.0f;
            case Difficulty.NORMAL -> livingEntity.getMaxHealth() / 4.0f;
            case Difficulty.HARD -> livingEntity.getMaxHealth() / 2.0f;
        };
    }

    public static boolean shouldSprintToCloseInOnTarget(Difficulty difficulty, double change) {
        if (difficulty == Difficulty.PEACEFUL || difficulty == Difficulty.EASY) {
            return false;
        }
        return change < (difficulty == Difficulty.NORMAL ? -0.25 : 0.0);
    }

    public static boolean shouldSprintFromDistance(Difficulty difficulty, double dist) {
        double minDistToSprintFrom = 25.0;
        if (difficulty == Difficulty.PEACEFUL || difficulty == Difficulty.EASY) {
            minDistToSprintFrom = 64.0;
        }
        if (difficulty == Difficulty.NORMAL) {
            minDistToSprintFrom = 36.0;
        }
        return dist > minDistToSprintFrom;
    }

    public static boolean processSprintAbility(Entity entity, Operation<Boolean> base) {
        Entity entity2 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractPiglin.class, AbstractSkeleton.class, Zombie.class}, (Object)entity2, n)) {
            case 0 -> {
                AbstractPiglin ignored = (AbstractPiglin)entity2;
                yield true;
            }
            case 1 -> {
                AbstractSkeleton skeleton = (AbstractSkeleton)entity2;
                ItemStack itemstack = skeleton.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)skeleton, (Item)Items.BOW));
                if (!itemstack.is(Items.BOW)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Zombie zombie = (Zombie)entity2;
                if (!zombie.isEyeInFluid(FluidTags.WATER) && !zombie.isEyeInFluid(FluidTags.LAVA)) {
                    yield true;
                }
                yield false;
            }
            default -> (Boolean)base.call(new Object[0]);
        };
    }

    public static double getPiercingLevel(ItemStack itemStack) {
        return ((Float)itemStack.getOrDefault(CustomDataComponents.PIERCING_LEVEL, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static double getChargedReach(ItemStack itemStack) {
        return ((Float)itemStack.getOrDefault(CustomDataComponents.CHARGED_REACH, (Object)Float.valueOf(1.0f))).floatValue();
    }

    public static int getCurrentItemAttackStrengthDelay(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return (int)player.getCurrentItemAttackStrengthDelay();
        }
        AttributeInstance attackSpeed = livingEntity.getAttribute(Attributes.ATTACK_SPEED);
        if (!Combatify.CONFIG.mobsUsePlayerAttributes().booleanValue() || attackSpeed == null) {
            return 10;
        }
        boolean hasVanilla = (attackSpeed.getModifier(Item.BASE_ATTACK_SPEED_ID) != null || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C);
        double speed = attackSpeed.getValue();
        speed = Mth.clamp((double)speed, (double)1.0, (double)1024.0);
        double result = 1.0 / speed * 20.0;
        return hasVanilla ? (int)result : (int)Math.round(result);
    }

    public static ConfigurableItemData forItem(Item item) {
        if (Combatify.ITEMS != null && !Combatify.ITEMS.isModifying) {
            ArrayList results = new ArrayList();
            ((List)Combatify.ITEMS.items.get()).forEach(configDataWrapper -> {
                ConfigurableItemData result = (ConfigurableItemData)configDataWrapper.match(item.builtInRegistryHolder());
                if (result != null) {
                    results.add(result);
                }
            });
            Double useSeconds = null;
            Double cooldownSeconds = null;
            for (ConfigurableItemData configurableItemData : results) {
                useSeconds = MethodHandler.conditionalChange(configurableItemData.useDuration(), useSeconds);
                cooldownSeconds = MethodHandler.conditionalChange(configurableItemData.cooldownSeconds(), cooldownSeconds);
            }
            ConfigurableItemData configurableItemData = new ConfigurableItemData(useSeconds, cooldownSeconds);
            if (configurableItemData.equals(ConfigurableItemData.EMPTY)) {
                return null;
            }
            return configurableItemData;
        }
        return null;
    }

    public static ConfigurableEntityData forEntityType(EntityType<?> entityType) {
        if (Combatify.ITEMS != null && !Combatify.ITEMS.isModifying) {
            ArrayList results = new ArrayList();
            ((List)Combatify.ITEMS.entities.get()).forEach(configDataWrapper -> {
                ConfigurableEntityData result = (ConfigurableEntityData)configDataWrapper.match(entityType.builtInRegistryHolder());
                if (result != null) {
                    results.add(result);
                }
            });
            Integer attackInterval = null;
            Double shieldDisableTime = null;
            Boolean isMiscEntity = null;
            for (ConfigurableEntityData configurableEntityData : results) {
                attackInterval = MethodHandler.conditionalChange(configurableEntityData.attackInterval(), attackInterval);
                shieldDisableTime = MethodHandler.conditionalChange(configurableEntityData.shieldDisableTime(), shieldDisableTime);
                isMiscEntity = MethodHandler.conditionalChange(configurableEntityData.isMiscEntity(), isMiscEntity);
            }
            ConfigurableEntityData configurableEntityData = new ConfigurableEntityData(Optional.ofNullable(attackInterval), Optional.ofNullable(shieldDisableTime), Optional.ofNullable(isMiscEntity));
            if (configurableEntityData.equals(ConfigurableEntityData.EMPTY)) {
                return null;
            }
            return configurableEntityData;
        }
        return null;
    }

    public static ConfigurableEntityData forEntity(Entity entity) {
        return MethodHandler.forEntityType(entity.getType());
    }

    public static <T> T conditionalChange(T source, T destination) {
        return source == null ? destination : source;
    }

    public static BlockingType getBlockingType(ItemStack itemStack) {
        return MethodHandler.getBlocking(itemStack).blockingType();
    }

    public static Blocker getBlocking(ItemStack itemStack) {
        return (Blocker)itemStack.getOrDefault(CustomDataComponents.BLOCKER, (Object)Blocker.EMPTY);
    }
}

