/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.atlas.combatify.Combatify;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record BlockingType(ResourceLocation name, BlockingTypeData data) {
    public static final Codec<ResourceLocation> ID_CODEC = ResourceLocation.CODEC.validate(blocking_type -> blocking_type.equals((Object)ResourceLocation.parse((String)"empty")) || !Combatify.registeredTypes.containsKey(blocking_type) ? DataResult.error(() -> "Attempted to retrieve a Blocking Type that does not exist: " + String.valueOf(blocking_type)) : DataResult.success((Object)blocking_type));
    public static final Codec<BlockingType> SIMPLE_CODEC = ID_CODEC.xmap(blocking_type -> Combatify.registeredTypes.get(blocking_type), BlockingType::name);
    public static final Codec<BlockingType> MODIFY = RecordCodecBuilder.create(instance -> instance.group((App)SIMPLE_CODEC.fieldOf("name").forGetter(blockingType -> blockingType), (App)Codec.BOOL.optionalFieldOf("can_be_disabled").forGetter(blockingType -> Optional.of(blockingType.canBeDisabled())), (App)Codec.BOOL.optionalFieldOf("can_crouch_block").forGetter(blockingType -> Optional.of(blockingType.canCrouchBlock())), (App)Codec.BOOL.optionalFieldOf("can_block_hit").forGetter(blockingType -> Optional.of(blockingType.canBlockHit())), (App)Codec.BOOL.optionalFieldOf("require_full_charge").forGetter(blockingType -> Optional.of(blockingType.requireFullCharge())), (App)Codec.BOOL.optionalFieldOf("default_kb_mechanics").forGetter(blockingType -> Optional.of(blockingType.defaultKbMechanics())), (App)Codec.BOOL.optionalFieldOf("has_shield_delay").forGetter(blockingType -> Optional.of(blockingType.hasDelay()))).apply((Applicative)instance, (blockingType, canBeDisabled, canCrouchBlock, canBlockHit, requireFullCharge, defaultKbMechanics, hasDelay) -> blockingType.copy(canBeDisabled.orElse(null), canCrouchBlock.orElse(null), canBlockHit.orElse(null), requireFullCharge.orElse(null), defaultKbMechanics.orElse(null), hasDelay.orElse(null))));
    public static final Codec<BlockingType> CREATE = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").validate(blocking_type -> blocking_type.equals((Object)ResourceLocation.parse((String)"empty")) ? DataResult.error(() -> "Unable to create a blank Blocking Type!") : DataResult.success((Object)blocking_type)).forGetter(BlockingType::name), (App)BlockingTypeData.CREATE.forGetter(BlockingType::data)).apply((Applicative)instance, BlockingType::new));
    public static final Codec<BlockingType> CODEC = Codec.withAlternative(CREATE, MODIFY);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockingType> FULL_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BlockingType::name, BlockingTypeData.STREAM_CODEC, BlockingType::data, BlockingType::new);

    public static Builder builder() {
        return new Builder();
    }

    public boolean canCrouchBlock() {
        return this.data.canCrouchBlock;
    }

    public boolean canBlockHit() {
        return this.data.canBlockHit;
    }

    public boolean canBeDisabled() {
        return this.data.canBeDisabled;
    }

    public boolean requireFullCharge() {
        return this.data.requireFullCharge;
    }

    public boolean defaultKbMechanics() {
        return this.data.defaultKbMechanics;
    }

    public boolean hasDelay() {
        return this.data.hasDelay;
    }

    public BlockingType copy(Boolean canBeDisabled, Boolean canCrouchBlock, Boolean canBlockHit, Boolean requireFullCharge, Boolean defaultKbMechanics, Boolean hasDelay) {
        BlockingTypeData newData = this.data.copy(canBeDisabled, canCrouchBlock, canBlockHit, requireFullCharge, defaultKbMechanics, hasDelay);
        return new BlockingType(this.name, newData);
    }

    public boolean isEmpty() {
        return this.name.equals((Object)ResourceLocation.withDefaultNamespace((String)"empty"));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingType)) {
            return false;
        }
        BlockingType that = (BlockingType)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.data);
    }

    public record BlockingTypeData(boolean canBeDisabled, boolean canCrouchBlock, boolean canBlockHit, boolean requireFullCharge, boolean defaultKbMechanics, boolean hasDelay) {
        public static final StreamCodec<FriendlyByteBuf, BlockingTypeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::canBeDisabled, (StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::canCrouchBlock, (StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::canBlockHit, (StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::requireFullCharge, (StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::defaultKbMechanics, (StreamCodec)ByteBufCodecs.BOOL, BlockingTypeData::hasDelay, BlockingTypeData::new);
        public static final MapCodec<BlockingTypeData> CREATE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("can_be_disabled", (Object)true).forGetter(BlockingTypeData::canBeDisabled), (App)Codec.BOOL.optionalFieldOf("can_crouch_block", (Object)true).forGetter(BlockingTypeData::canCrouchBlock), (App)Codec.BOOL.optionalFieldOf("can_block_hit", (Object)false).forGetter(BlockingTypeData::canBlockHit), (App)Codec.BOOL.optionalFieldOf("require_full_charge", (Object)true).forGetter(BlockingTypeData::requireFullCharge), (App)Codec.BOOL.optionalFieldOf("default_kb_mechanics", (Object)true).forGetter(BlockingTypeData::defaultKbMechanics), (App)Codec.BOOL.optionalFieldOf("has_shield_delay", (Object)true).forGetter(BlockingTypeData::hasDelay)).apply((Applicative)instance, BlockingTypeData::new));

        public BlockingTypeData copy(Boolean canBeDisabled, Boolean canCrouchBlock, Boolean canBlockHit, Boolean requireFullCharge, Boolean defaultKbMechanics, Boolean hasDelay) {
            return new BlockingTypeData(canBeDisabled == null ? this.canBeDisabled : canBeDisabled, canCrouchBlock == null ? this.canCrouchBlock : canCrouchBlock, canBlockHit == null ? this.canBlockHit : canBlockHit, requireFullCharge == null ? this.requireFullCharge : requireFullCharge, defaultKbMechanics == null ? this.defaultKbMechanics : defaultKbMechanics, hasDelay == null ? this.hasDelay : hasDelay);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockingTypeData)) {
                return false;
            }
            BlockingTypeData that = (BlockingTypeData)o;
            return this.canBeDisabled == that.canBeDisabled && this.canCrouchBlock == that.canCrouchBlock && this.canBlockHit == that.canBlockHit && this.requireFullCharge == that.requireFullCharge && this.defaultKbMechanics == that.defaultKbMechanics && this.hasDelay == that.hasDelay;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.canBeDisabled, this.canCrouchBlock, this.canBlockHit, this.requireFullCharge, this.defaultKbMechanics, this.hasDelay);
        }
    }

    public static class Builder {
        private boolean canBeDisabled = true;
        private boolean canCrouchBlock = true;
        private boolean canBlockHit = false;
        private boolean requireFullCharge = true;
        private boolean defaultKbMechanics = true;
        private boolean hasDelay = true;

        public Builder setCrouchable(boolean crouchable) {
            this.canCrouchBlock = crouchable;
            return this;
        }

        public Builder setBlockHit(boolean blockHit) {
            this.canBlockHit = blockHit;
            return this;
        }

        public Builder setDisablement(boolean canDisable) {
            this.canBeDisabled = canDisable;
            return this;
        }

        public Builder setRequireFullCharge(boolean needsFullCharge) {
            this.requireFullCharge = needsFullCharge;
            return this;
        }

        public Builder setKbMechanics(boolean defaultKbMechanics) {
            this.defaultKbMechanics = defaultKbMechanics;
            return this;
        }

        public Builder setDelay(boolean hasDelay) {
            this.hasDelay = hasDelay;
            return this;
        }

        public BlockingType build(String name) {
            return this.build(ResourceLocation.parse((String)name));
        }

        public BlockingType build(ResourceLocation name) {
            return new BlockingType(name, new BlockingTypeData(this.canBeDisabled, this.canCrouchBlock, this.canBlockHit, this.requireFullCharge, this.defaultKbMechanics, this.hasDelay));
        }
    }
}

