/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.damage_parsers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.damage_parsers.Nullify;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageBase;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageLimit;
import net.atlas.defaulted.extension.LateBoundIdMapper;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;

public interface DamageParser {
    public static final LateBoundIdMapper<ResourceLocation, MapCodec<? extends DamageParser>> ID_MAPPER = new LateBoundIdMapper();
    public static final Codec<DamageParser> CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(DamageParser::codec, mapCodec -> mapCodec);

    public static void bootstrap() {
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"percentage_base"), PercentageBase.CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"percentage_limit"), PercentageLimit.CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"nullify"), Nullify.CODEC);
    }

    public float parse(float var1, ComponentModifier.DataSet var2, Holder<DamageType> var3);

    public MapCodec<? extends DamageParser> codec();

    public List<TagPredicate<DamageType>> requirements();

    public boolean enforceAll();

    default public boolean allAre(Holder<DamageType> damageType) {
        if (this.requirements().isEmpty()) {
            return true;
        }
        boolean enforce = this.enforceAll();
        for (TagPredicate<DamageType> requirement : this.requirements()) {
            boolean matches = requirement.matches(damageType);
            if (matches == enforce) continue;
            return matches;
        }
        return enforce;
    }

    public static <D extends DamageParser> MapCodec<D> mapCodec(BiFunction<List<TagPredicate<DamageType>>, Boolean, D> creator) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)TagPredicate.codec((ResourceKey)Registries.DAMAGE_TYPE).listOf().optionalFieldOf("damage_types", Collections.emptyList()).forGetter(DamageParser::requirements), (App)Codec.BOOL.optionalFieldOf("enforce_all", (Object)true).forGetter(DamageParser::enforceAll)).apply((Applicative)instance, creator));
    }
}

