/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.damage_parsers;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.damage_parsers.DamageParser;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageType;

public record PercentageLimit(List<TagPredicate<DamageType>> requirements, boolean enforceAll) implements DamageParser
{
    public static final DamageParser ALL = new PercentageLimit(Collections.emptyList(), true);
    public static final MapCodec<PercentageLimit> CODEC = DamageParser.mapCodec(PercentageLimit::new);

    @Override
    public float parse(float originalValue, ComponentModifier.DataSet protection, Holder<DamageType> damageType) {
        if (!this.allAre(damageType)) {
            return 0.0f;
        }
        float subVal = originalValue - protection.addValue();
        subVal = Math.max(subVal, 0.0f);
        return Math.min(protection.addValue() + Math.max(subVal - (subVal + Math.clamp(2.0f * protection.multiplyValue(), 0.0f, 1.0f)) * (1.0f - protection.multiplyValue()), 0.0f), originalValue);
    }

    @Override
    public MapCodec<? extends DamageParser> codec() {
        return CODEC;
    }
}

