/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record ApplyEffect(HolderSet<MobEffect> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements PostBlockEffect
{
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"apply_effect");
    public static final MapCodec<ApplyEffect> PARTIAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ApplyEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("amplifier").forGetter(ApplyEffect::minAmplifier)).apply((Applicative)instance, ApplyEffect::new));
    public static final MapCodec<ApplyEffect> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyEffect::maxAmplifier)).apply((Applicative)instance, ApplyEffect::new));
    public static final MapCodec<ApplyEffect> MAP_CODEC = Codec.mapEither(FULL_CODEC, PARTIAL_CODEC).xmap(Either::unwrap, Either::left);

    public ApplyEffect(HolderSet<MobEffect> toApply, LevelBasedValue duration, LevelBasedValue amplifier) {
        this(toApply, duration, duration, amplifier, amplifier);
    }

    @Override
    public void doEffect(ServerLevel serverLevel, EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, DamageSource damageSource, int enchantmentLevel, LivingEntity toApply, Vec3 position) {
        assert (enchantedItemInUse.owner() != null);
        @NotNull LivingEntity target = enchantedItemInUse.owner();
        RandomSource randomSource = target.getRandom();
        Optional optional = this.toApply.getRandomElement(randomSource);
        if (optional.isPresent()) {
            int duration = Math.round(Mth.randomBetween((RandomSource)randomSource, (float)this.minDuration.calculate(enchantmentLevel), (float)this.maxDuration.calculate(enchantmentLevel)) * 20.0f);
            int amp = Math.max(0, Math.round(Mth.randomBetween((RandomSource)randomSource, (float)this.minAmplifier.calculate(enchantmentLevel), (float)this.maxAmplifier.calculate(enchantmentLevel))));
            if (((MobEffect)((Holder)optional.get()).value()).isInstantenous()) {
                ((MobEffect)((Holder)optional.get()).value()).applyInstantenousEffect((Entity)target, (Entity)target, toApply, amp, 1.0);
                return;
            }
            toApply.addEffect(new MobEffectInstance((Holder)optional.get(), duration, amp));
        }
    }

    @Override
    public MapCodec<? extends PostBlockEffect> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

