/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;

public record ChangeItemDamage(LevelBasedValue amount) implements PostBlockEffect
{
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"change_item_damage");
    public static final MapCodec<ChangeItemDamage> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(changeItemDamage -> changeItemDamage.amount)).apply((Applicative)instance, ChangeItemDamage::new));

    @Override
    public void doEffect(ServerLevel serverLevel, EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, DamageSource damageSource, int enchantmentLevel, LivingEntity toApply, Vec3 position) {
        ItemStack itemStack = enchantedItemInUse.itemStack();
        if (itemStack.has(DataComponents.MAX_DAMAGE) && itemStack.has(DataComponents.DAMAGE)) {
            ServerPlayer serverPlayer;
            LivingEntity livingEntity = enchantedItemInUse.owner();
            ServerPlayer serverPlayer2 = livingEntity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)livingEntity) : null;
            int calculated = (int)this.amount.calculate(enchantmentLevel);
            itemStack.hurtAndBreak(calculated, serverLevel, serverPlayer2, enchantedItemInUse.onBreak());
        }
    }

    @Override
    public MapCodec<? extends PostBlockEffect> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

