/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;

public record HurtEntity(Holder<DamageType> damageType, LevelBasedValue minDamage, LevelBasedValue maxDamage) implements PostBlockEffect
{
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"hurt_entity");
    public static final MapCodec<HurtEntity> PARTIAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(HurtEntity::damageType), (App)LevelBasedValue.CODEC.fieldOf("damage").forGetter(HurtEntity::maxDamage)).apply((Applicative)instance, HurtEntity::new));
    public static final MapCodec<HurtEntity> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(HurtEntity::damageType), (App)LevelBasedValue.CODEC.fieldOf("min_damage").forGetter(HurtEntity::minDamage), (App)LevelBasedValue.CODEC.fieldOf("max_damage").forGetter(HurtEntity::maxDamage)).apply((Applicative)instance, HurtEntity::new));
    public static final MapCodec<HurtEntity> MAP_CODEC = Codec.mapEither(FULL_CODEC, PARTIAL_CODEC).xmap(Either::unwrap, Either::left);

    public HurtEntity(Holder<DamageType> damageType, LevelBasedValue damage) {
        this(damageType, damage, damage);
    }

    @Override
    public void doEffect(ServerLevel serverLevel, EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, DamageSource damageSource, int enchantmentLevel, LivingEntity toApply, Vec3 position) {
        float maxDamage;
        float damage;
        assert (enchantedItemInUse.owner() != null);
        float minDamage = this.minDamage.calculate(enchantmentLevel);
        float f = damage = minDamage == (maxDamage = this.maxDamage.calculate(enchantmentLevel)) ? minDamage : Mth.randomBetween((RandomSource)enchantedItemInUse.owner().getRandom(), (float)minDamage, (float)maxDamage);
        if (!damageSource.combatify$originatedFromBlockedAttack()) {
            toApply.hurt(new DamageSource(this.damageType, (Entity)enchantedItemInUse.owner()).combatify$originatesFromBlockedAttack(true), damage);
        }
    }

    @Override
    public MapCodec<? extends PostBlockEffect> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

