/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.function.Function;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.wrapper.FoodDataWrapper;
import net.atlas.combatify.config.wrapper.GenericAPIWrapper;
import net.atlas.combatify.config.wrapper.PlayerWrapper;
import net.atlas.combatify.config.wrapper.SimpleAPIWrapper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSImpl {
    public final String fileName;
    public String cachedFile = null;
    public static final Codec<JSImpl> CODEC = Codec.STRING.validate(str -> str.contains(".") ? DataResult.error(() -> "File loc not expected to contain a file extension!") : DataResult.success((Object)str)).xmap(JSImpl::new, JSImpl::fileName);

    public JSImpl(String fileName) {
        this.fileName = fileName;
    }

    public String fileName() {
        return this.fileName;
    }

    public static void initIncluded(String fileName) {
        File included = new File(FabricLoader.getInstance().getConfigDirectory().getAbsolutePath() + "/" + fileName + ".js");
        if (!included.exists()) {
            try {
                included.createNewFile();
                try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName + ".js");){
                    Files.write(included.toPath(), inputStream.readAllBytes(), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                throw new class_148(new class_128("Failed to clone base JS files!", (Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execFunc(String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            Boolean bool;
            Object ret = this.invokeFunc(name, args, rhinoContext, (Scriptable)scope);
            boolean bl = !(ret instanceof Boolean) || (bool = (Boolean)ret) != false;
            return bl;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double execGetterFunc(double fallback, String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            double d;
            Object ret = this.invokeFunc(name, args, rhinoContext, (Scriptable)scope);
            if (!(ret instanceof Number)) {
                d = fallback;
            } else {
                Number number = (Number)ret;
                d = number.doubleValue();
            }
            double d2 = d;
            return d2;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execPlayerFunc(class_1657 player, String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            Boolean bool;
            Object ret = this.handlePlayerBindings(player, name, args, rhinoContext, (Scriptable)scope);
            boolean bl = !(ret instanceof Boolean) || (bool = (Boolean)ret) != false;
            return bl;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double execPlayerGetterFunc(double fallback, class_1657 player, String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            double d;
            Object ret = this.handlePlayerBindings(player, name, args, rhinoContext, (Scriptable)scope);
            if (!(ret instanceof Number)) {
                d = fallback;
            } else {
                Number number = (Number)ret;
                d = number.doubleValue();
            }
            double d2 = d;
            return d2;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execFoodFunc(class_1702 foodData, class_1657 player, String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            Boolean bool;
            Object ret = this.handleFoodBindings(foodData, player, name, args, rhinoContext, (Scriptable)scope);
            boolean bl = !(ret instanceof Boolean) || (bool = (Boolean)ret) != false;
            return bl;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double execFoodGetterFunc(double fallback, class_1702 foodData, class_1657 player, String name, Reference<?, ?> ... args) {
        Context rhinoContext = Context.enter();
        ScriptableObject scope = rhinoContext.initStandardObjects();
        try {
            double d;
            Object ret = this.handleFoodBindings(foodData, player, name, args, rhinoContext, (Scriptable)scope);
            if (!(ret instanceof Number)) {
                d = fallback;
            } else {
                Number number = (Number)ret;
                d = number.doubleValue();
            }
            double d2 = d;
            return d2;
        }
        catch (Exception e) {
            Combatify.JS_LOGGER.error("Error executing " + name + " function: " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        return fallback;
    }

    public Object handleFoodBindings(class_1702 foodData, class_1657 player, String name, Reference<?, ?>[] args, Context rhinoContext, Scriptable scope) throws IOException {
        if (ScriptableObject.hasProperty((Scriptable)scope, (String)"foodData")) {
            ScriptableObject.deleteProperty((Scriptable)scope, (String)"foodData");
        }
        if (ScriptableObject.hasProperty((Scriptable)scope, (String)"player")) {
            ScriptableObject.deleteProperty((Scriptable)scope, (String)"player");
        }
        ScriptableObject.putProperty((Scriptable)scope, (String)"foodData", (Object)new FoodDataWrapper(foodData));
        if (player != null) {
            ScriptableObject.putProperty((Scriptable)scope, (String)"player", new PlayerWrapper<class_1657>(player));
        }
        return this.invokeFunc(name, args, rhinoContext, scope);
    }

    public Object handlePlayerBindings(class_1657 player, String name, Reference<?, ?>[] args, Context rhinoContext, Scriptable scope) throws IOException {
        if (ScriptableObject.hasProperty((Scriptable)scope, (String)"player")) {
            ScriptableObject.deleteProperty((Scriptable)scope, (String)"player");
        }
        ScriptableObject.putProperty((Scriptable)scope, (String)"player", new PlayerWrapper<class_1657>(player));
        return this.invokeFunc(name, args, rhinoContext, scope);
    }

    private Object invokeFunc(String name, Reference<?, ?>[] args, Context rhinoContext, Scriptable scope) throws IOException {
        this.cleanUpBindings(scope, args);
        for (Reference<?, ?> ref : args) {
            Object value = ref.value;
            if (value instanceof SimpleAPIWrapper) {
                SimpleAPIWrapper simple = (SimpleAPIWrapper)value;
                value = simple.unwrap();
            }
            ScriptableObject.putProperty((Scriptable)scope, (String)ref.name, value);
        }
        if (this.cachedFile == null) {
            BufferedReader reader = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDirectory().getAbsolutePath() + "/" + this.fileName + ".js"));
            this.cachedFile = Kit.readReader((Reader)reader);
        }
        rhinoContext.evaluateString(scope, this.cachedFile, this.fileName, 1, null);
        return rhinoContext.evaluateString(scope, name + ";", this.fileName, 1, null);
    }

    private void cleanUpBindings(Scriptable scope, Reference<?, ?> ... args) {
        for (Reference<?, ?> ref : args) {
            if (!ScriptableObject.hasProperty((Scriptable)scope, (String)ref.name)) continue;
            ScriptableObject.deleteProperty((Scriptable)scope, (String)ref.name);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof JSImpl)) {
            return false;
        }
        JSImpl js = (JSImpl)o;
        return Objects.equals(this.fileName(), js.fileName());
    }

    public int hashCode() {
        return Objects.hash(this.fileName());
    }

    static {
        JSImpl.initIncluded("vanilla_food_impl");
        JSImpl.initIncluded("cts_food_impl");
        JSImpl.initIncluded("combatify_food_impl");
        JSImpl.initIncluded("vanilla_crit_impl");
        JSImpl.initIncluded("cts_crit_impl");
        JSImpl.initIncluded("combatify_crit_impl");
        JSImpl.initIncluded("armor_calculations");
    }

    public record Reference<T extends GenericAPIWrapper<O>, O>(String name, T value) {
        public Reference(String name, O value, Function<O, T> mapper) {
            this(name, (GenericAPIWrapper)mapper.apply(value));
        }
    }
}

