/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.google.common.base.Suppliers;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.Cleaner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.atlas.atlascore.util.ArrayListExtensions;
import net.atlas.atlascore.util.PrefixLogger;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.CustomEnchantmentEffectComponents;
import net.atlas.combatify.component.custom.Blocker;
import net.atlas.combatify.component.custom.CanSweep;
import net.atlas.combatify.component.generators.CombatifyPatchGenerators;
import net.atlas.combatify.config.CombatifyGeneralConfig;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.critereon.ItemSubPredicateInit;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.item.CombatifyItemTags;
import net.atlas.combatify.item.CombatifyItems;
import net.atlas.combatify.item.ItemRegistry;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingType;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.atlas.combatify.util.blocking.effect.PostBlockEffects;
import net.atlas.defaulted.DefaultComponentPatchesManager;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;

@Mod(value="combatify")
@EventBusSubscriber(modid="combatify")
public class Combatify {
    public static final String MOD_ID = "combatify";
    public static final PrefixLogger LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify"));
    public static final PrefixLogger JS_LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify|JavaScript"));
    public static final Cleaner CLEANER = Cleaner.create();
    public static CombatifyGeneralConfig CONFIG = new CombatifyGeneralConfig();
    public static ItemConfig ITEMS;
    public static ResourceLocation modDetectionNetworkChannel;
    public NetworkingHandler networkingHandler;
    public static Supplier<CombatifyState> state;
    public static boolean isLoaded;
    public static boolean mobConfigIsDirty;
    public static final List<Item> shields;
    public static final List<UUID> unmoddedPlayers;
    public static final List<UUID> moddedPlayers;
    public static final Map<Holder<Item>, ItemAttributeModifiers> originalModifiers;
    public static final Map<UUID, Boolean> isPlayerAttacking;
    public static final Map<String, WeaponType> defaultWeaponTypes;
    public static final Map<ResourceLocation, BlockingType> defaultTypes;
    public static Map<ResourceLocation, BlockingType> registeredTypes;
    public static final ResourceLocation CHARGED_REACH_ID;
    public static final TagKey<EntityType<?>> HAS_BOOSTED_SPEED;

    public static void markState(Supplier<CombatifyState> state) {
        Combatify.state = state;
    }

    public static CombatifyState getState() {
        return state.get();
    }

    public Combatify(ModContainer container) {
        Event event;
        CLEANER.register(this, Context::exit);
        isLoaded = true;
        BlockingConditions.bootstrap();
        PostBlockEffects.bootstrap();
        WeaponType.init();
        this.networkingHandler = new NetworkingHandler();
        AttackEntityCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, pos, direction) -> {
            if (unmoddedPlayers.contains(player.getUUID())) {
                isPlayerAttacking.put(player.getUUID(), false);
            }
            return InteractionResult.PASS;
        });
        AttackBlockCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, pos, direction) -> {
            if (unmoddedPlayers.contains(player.getUUID())) {
                isPlayerAttacking.put(player.getUUID(), false);
                BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), direction, pos, false);
                hitResult = MethodHandler.redirectResult(player, (HitResult)hitResult);
                if (hitResult.getType() == HitResult.Type.ENTITY && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.handleInteract(ServerboundInteractPacket.createAttackPacket((Entity)((EntityHitResult)hitResult).getEntity(), (boolean)player.isShiftKeyDown()));
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.PASS;
        });
        UseBlockCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, hitResult) -> {
            if (unmoddedPlayers.contains(player.getUUID())) {
                isPlayerAttacking.put(player.getUUID(), false);
            }
            return InteractionResult.PASS;
        });
        UseEntityCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, entity, hitResult) -> {
            if (unmoddedPlayers.contains(player.getUUID())) {
                isPlayerAttacking.put(player.getUUID(), false);
            }
            return InteractionResult.PASS;
        });
        UseItemCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand) -> {
            if (unmoddedPlayers.contains(player.getUUID())) {
                isPlayerAttacking.put(player.getUUID(), false);
            }
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        });
        LOGGER.info("Init started.");
        IEventBus eventBus = container.getEventBus();
        CustomDataComponents.registerDataComponents(eventBus);
        CustomEnchantmentEffectComponents.registerEnchantmentEffectComponents(eventBus);
        ItemSubPredicateInit.init(eventBus);
        BlockingTypeInit.init();
        if (FabricLoader.getInstance().isModLoaded("polymer-core")) {
            PolymerItemUtils.ITEM_CHECK.register(itemStack -> Combatify.isPatched(itemStack.getItem()) || itemStack.has(CustomDataComponents.BLOCKER) || itemStack.has(CustomDataComponents.CAN_SWEEP) || itemStack.has(CustomDataComponents.BLOCKING_LEVEL) || itemStack.has(CustomDataComponents.PIERCING_LEVEL) || itemStack.has(CustomDataComponents.CHARGED_REACH));
            PolymerItemUtils.ITEM_MODIFICATION_EVENT.register((itemStack, itemStack1, player) -> {
                if (player == null || moddedPlayers.contains(player.getUUID())) {
                    if (itemStack.has(CustomDataComponents.BLOCKER)) {
                        itemStack1.set(CustomDataComponents.BLOCKER, (Object)((Blocker)itemStack.get(CustomDataComponents.BLOCKER)));
                    }
                    if (itemStack.has(CustomDataComponents.CAN_SWEEP)) {
                        itemStack1.set(CustomDataComponents.CAN_SWEEP, (Object)((CanSweep)itemStack.get(CustomDataComponents.CAN_SWEEP)));
                    }
                    if (itemStack.has(CustomDataComponents.BLOCKING_LEVEL)) {
                        itemStack1.set(CustomDataComponents.BLOCKING_LEVEL, (Object)((Integer)itemStack.get(CustomDataComponents.BLOCKING_LEVEL)));
                    }
                    if (itemStack.has(CustomDataComponents.PIERCING_LEVEL)) {
                        itemStack1.set(CustomDataComponents.PIERCING_LEVEL, (Object)((Float)itemStack.get(CustomDataComponents.PIERCING_LEVEL)));
                    }
                    if (itemStack.has(CustomDataComponents.CHARGED_REACH)) {
                        itemStack1.set(CustomDataComponents.CHARGED_REACH, (Object)((Float)itemStack.get(CustomDataComponents.CHARGED_REACH)));
                    }
                }
                return itemStack1;
            });
        }
        CombatifyItemTags.init();
        if (CONFIG.dispensableTridents().booleanValue()) {
            DispenserBlock.registerProjectileBehavior((ItemLike)Items.TRIDENT);
        }
        DefaultItemComponentEvents.MODIFY.register(modDetectionNetworkChannel, modifyContext -> {
            modifyContext.modify(Items.WOODEN_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)1));
            modifyContext.modify(Items.GOLDEN_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)1));
            modifyContext.modify(Items.STONE_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)2));
            modifyContext.modify(Items.IRON_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)3));
            modifyContext.modify(Items.DIAMOND_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)4));
            modifyContext.modify(Items.NETHERITE_SWORD, builder -> builder.set(CustomDataComponents.BLOCKING_LEVEL, (Object)5));
            modifyContext.modify(Items.SHIELD, builder -> builder.set(CustomDataComponents.BLOCKER, (Object)Blocker.VANILLA_SHIELD));
        });
        if (CONFIG.configOnlyWeapons().booleanValue()) {
            ItemRegistry.registerWeapons();
            event = ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.COMBAT);
            event.register(entries -> entries.addAfter((ItemLike)Items.NETHERITE_SWORD, new ItemLike[]{ItemRegistry.WOODEN_KNIFE, ItemRegistry.STONE_KNIFE, ItemRegistry.IRON_KNIFE, ItemRegistry.GOLD_KNIFE, ItemRegistry.DIAMOND_KNIFE, ItemRegistry.NETHERITE_KNIFE, ItemRegistry.WOODEN_LONGSWORD, ItemRegistry.STONE_LONGSWORD, ItemRegistry.IRON_LONGSWORD, ItemRegistry.GOLD_LONGSWORD, ItemRegistry.DIAMOND_LONGSWORD, ItemRegistry.NETHERITE_LONGSWORD}));
        }
        if (CONFIG.tieredShields().booleanValue()) {
            TieredShieldItem.init();
            shields.add(Items.SHIELD);
            event = ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.COMBAT);
            event.register(entries -> entries.addAfter((ItemLike)Items.SHIELD, new ItemLike[]{TieredShieldItem.IRON_SHIELD, TieredShieldItem.GOLD_SHIELD, TieredShieldItem.DIAMOND_SHIELD, TieredShieldItem.NETHERITE_SHIELD}));
        }
        if (CONFIG.configOnlyWeapons().booleanValue() || CONFIG.tieredShields().booleanValue()) {
            CombatifyItems.register(eventBus);
        }
        CombatifyPatchGenerators.init(eventBus);
        net.fabricmc.loader.api.ModContainer modContainer = (net.fabricmc.loader.api.ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get();
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("alternate_mace"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.alternate_mace"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("combatify_extras"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.combatify_extras"), (ResourcePackActivationType)(CONFIG.configOnlyWeapons() != false || CONFIG.tieredShields() != false ? ResourcePackActivationType.ALWAYS_ENABLED : ResourcePackActivationType.NORMAL));
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("copper_age_rebalance"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.copper_age_rebalance"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("default_mace"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.default_mace"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("default_shield"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.default_shield"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("default_shield_attacker_kb"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.default_shield_attacker_knockback"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("old_sword_blocking"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.old_sword_blocking"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("percentage_shield"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.percentage_shield"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("shield_enchantments"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.shield_enchantments"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("shield_no_banner"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.shield_no_banner"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("sword_blocking"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.sword_blocking"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("vanilla_attack_balancing"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.vanilla_attack_balancing"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("weapon_types"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.weapon_types"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)Combatify.id("wooden_shield_recipe"), (net.fabricmc.loader.api.ModContainer)modContainer, (Component)Component.translatable((String)"pack.combatify.wooden_shield_recipe"), (ResourcePackActivationType)(CONFIG.tieredShields() != false ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL));
        if (CONFIG.percentageDamageEffects().booleanValue()) {
            ((MobEffect)MobEffects.DAMAGE_BOOST.value()).addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.withDefaultNamespace((String)"effect.strength"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            ((MobEffect)MobEffects.WEAKNESS.value()).addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.withDefaultNamespace((String)"effect.weakness"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    @SubscribeEvent
    public static void onFinishedLoading(FMLLoadCompleteEvent event) {
        CustomDataComponents.postInit();
        CustomEnchantmentEffectComponents.postInit();
        ItemSubPredicateInit.postInit();
    }

    @SubscribeEvent
    static void onRegisterConfigurationTasks(RegisterConfigurationTasksEvent event) {
        if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)((ServerConfigurationPacketListenerImpl)event.getListener()), NetworkingHandler.ClientboundClientInformationRetrievalPacket.TYPE)) {
            event.register((ConfigurationTask)new NetworkingHandler.ClientRetrievalTask());
        }
    }

    @SubscribeEvent
    public static void addPiercingTooltip(AddAttributeTooltipsEvent event) {
        @Nullable Player player = event.getContext().player();
        ItemStack stack = event.getStack();
        Consumer<Component> consumer = xva$0 -> event.addTooltipLines(new Component[]{xva$0});
        ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        if (itemAttributeModifiers.showInTooltip() && player != null) {
            double piercingLevel = MethodHandler.getPiercingLevel(stack);
            if (CONFIG.configOnlyWeapons().booleanValue()) {
                piercingLevel += (double)CustomEnchantmentHelper.getBreach(stack, player.getRandom());
            }
            if ((piercingLevel = Mth.clamp((double)piercingLevel, (double)0.0, (double)1.0)) > 0.0) {
                consumer.accept(CommonComponents.EMPTY);
                consumer.accept((Component)Component.translatable((String)"item.modifiers.mainhand").withStyle(ChatFormatting.GRAY));
                consumer.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)("attribute.modifier.equals." + AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL.id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(piercingLevel * 100.0), Component.translatableWithFallback((String)"attribute.name.armor_piercing", (String)"Armor Piercing")})).withStyle(ChatFormatting.DARK_GREEN));
            }
            if (MethodHandler.getBlocking(stack).canShowInTooltip(stack, player)) {
                MethodHandler.getBlocking(stack).tooltip().appendTooltipInfo(consumer, player, stack);
            }
        }
    }

    public static void setDurability(DataComponentPatch.Builder builder, @NotNull Item item, int value) {
        builder.set(DataComponents.DAMAGE, (Object)0);
        builder.set(DataComponents.MAX_DAMAGE, (Object)value);
        builder.set(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    public static BlockingType registerBlockingType(BlockingType blockingType) {
        registeredTypes.put(blockingType.name(), blockingType);
        return blockingType;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void defineDefaultWeaponType(WeaponType type) {
        defaultWeaponTypes.put(type.name(), type);
    }

    public static BlockingType defineDefaultBlockingType(BlockingType blockingType) {
        defaultTypes.put(blockingType.name(), blockingType);
        return Combatify.registerBlockingType(blockingType);
    }

    public static boolean isPatched(Item item) {
        List patches = DefaultComponentPatchesManager.getCached();
        if (patches == null) {
            return false;
        }
        return patches.stream().anyMatch(itemPatches -> itemPatches.matchItem(item));
    }

    static {
        modDetectionNetworkChannel = Combatify.id("networking");
        state = Suppliers.memoize(() -> CombatifyState.COMBATIFY);
        isLoaded = false;
        mobConfigIsDirty = true;
        shields = new ArrayListExtensions();
        unmoddedPlayers = new ArrayListExtensions();
        moddedPlayers = new ArrayListExtensions();
        originalModifiers = (Map)Util.make((Object)new Object2ObjectOpenHashMap(), object2ObjectOpenHashMap -> object2ObjectOpenHashMap.defaultReturnValue((Object)ItemAttributeModifiers.EMPTY));
        isPlayerAttacking = new HashMap<UUID, Boolean>();
        defaultWeaponTypes = new HashMap<String, WeaponType>();
        defaultTypes = new HashMap<ResourceLocation, BlockingType>();
        registeredTypes = new HashMap<ResourceLocation, BlockingType>();
        CHARGED_REACH_ID = Combatify.id("charged_reach");
        HAS_BOOSTED_SPEED = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)Combatify.id("has_boosted_speed"));
    }

    public static enum CombatifyState implements StringRepresentable
    {
        VANILLA("Vanilla", "vanilla"),
        COMBATIFY("Combatify", "combatify"),
        CTS_8C("CTS 8C", "combat_test");

        public final String name;
        public final String key;

        private CombatifyState(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        public Component getComponent() {
            return Component.translatableWithFallback((String)("options.combatify_state." + this.key), (String)this.name);
        }

        public String toString() {
            return "CombatifyState{name='" + this.name + "'}";
        }
    }
}

