/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.DualAttackIndicatorStatus;
import net.atlas.combatify.config.ShieldIndicatorStatus;
import net.atlas.combatify.networking.ClientNetworkingHandler;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@Mod(value="combatify", dist={Dist.CLIENT})
@EventBusSubscriber(modid="combatify", value={Dist.CLIENT})
public class CombatifyClient {
    public static final ModelLayerLocation IRON_SHIELD_MODEL_LAYER = new ModelLayerLocation(Combatify.id("iron_shield"), "main");
    public static final ModelLayerLocation GOLDEN_SHIELD_MODEL_LAYER = new ModelLayerLocation(Combatify.id("golden_shield"), "main");
    public static final ModelLayerLocation DIAMOND_SHIELD_MODEL_LAYER = new ModelLayerLocation(Combatify.id("diamond_shield"), "main");
    public static final ModelLayerLocation NETHERITE_SHIELD_MODEL_LAYER = new ModelLayerLocation(Combatify.id("netherite_shield"), "main");
    public static final OptionInstance<Boolean> autoAttack = OptionInstance.createBoolean((String)"options.autoAttack", (boolean)true);
    public static final OptionInstance<Boolean> shieldCrouch = OptionInstance.createBoolean((String)"options.shieldCrouch", (boolean)true);
    public static final OptionInstance<TriState> rhythmicAttacks = new OptionInstance("options.rhythmicAttack", OptionInstance.noTooltip(), (component, object) -> switch (object) {
        default -> throw new MatchException(null, null);
        case TriState.TRUE -> CommonComponents.OPTION_ON;
        case TriState.FALSE -> CommonComponents.OPTION_OFF;
        case TriState.DEFAULT -> Component.translatable((String)"options.context_decided");
    }, (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TriState.values()), Codec.INT.xmap(ordinal -> switch (Mth.positiveModulo((int)ordinal, (int)3)) {
        case 0 -> TriState.FALSE;
        case 1 -> TriState.TRUE;
        default -> TriState.DEFAULT;
    }, Enum::ordinal)), (Object)TriState.DEFAULT, value -> {});
    public static final OptionInstance<TriState> augmentedArmHeight = new OptionInstance("options.augmentedArmHeight", OptionInstance.noTooltip(), (component, object) -> switch (object) {
        default -> throw new MatchException(null, null);
        case TriState.TRUE -> CommonComponents.OPTION_ON;
        case TriState.FALSE -> CommonComponents.OPTION_OFF;
        case TriState.DEFAULT -> Component.translatable((String)"options.context_decided");
    }, (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TriState.values()), Codec.INT.xmap(ordinal -> switch (Mth.positiveModulo((int)ordinal, (int)3)) {
        case 0 -> TriState.FALSE;
        case 1 -> TriState.TRUE;
        default -> TriState.DEFAULT;
    }, Enum::ordinal)), (Object)TriState.DEFAULT, value -> {});
    public static final OptionInstance<Combatify.CombatifyState> combatifyState = new OptionInstance("options.combatifyState", OptionInstance.noTooltip(), (component, state) -> state.getComponent(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Combatify.CombatifyState.values()), Codec.INT.xmap(ordinal -> switch (Mth.positiveModulo((int)ordinal, (int)3)) {
        case 0 -> Combatify.CombatifyState.VANILLA;
        case 1 -> Combatify.CombatifyState.CTS_8C;
        default -> Combatify.CombatifyState.COMBATIFY;
    }, Enum::ordinal)), (Object)Combatify.CombatifyState.COMBATIFY, value -> {});
    public static final OptionInstance<AttackIndicatorStatus> projectileChargeIndicator = new OptionInstance("options.projectileChargeIndicator", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(AttackIndicatorStatus.values()), Codec.INT.xmap(AttackIndicatorStatus::byId, AttackIndicatorStatus::getId)), (Object)AttackIndicatorStatus.OFF, value -> {});
    public static final OptionInstance<DualAttackIndicatorStatus> dualAttackIndicator = new OptionInstance("options.dualAttackIndicator", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(DualAttackIndicatorStatus.values()), Codec.INT.xmap(DualAttackIndicatorStatus::byId, DualAttackIndicatorStatus::getId)), (Object)DualAttackIndicatorStatus.OFF, value -> {});
    public static final OptionInstance<Double> attackIndicatorMaxValue = new OptionInstance("options.attackIndicatorMaxValue", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"options.attackIndicatorMaxValue.tooltip")), (optionText, value) -> value == 2.0 ? Objects.requireNonNull(Options.genericValueLabel((Component)optionText, (Component)Component.translatable((String)"options.attackIndicatorMaxValue.default"))) : Options.percentValueLabel((Component)optionText, (double)value), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 200).xmap(sliderValue -> (double)sliderValue / 100.0, value -> (int)(value * 100.0)), Codec.doubleRange((double)0.01, (double)2.0), (Object)2.0, value -> {});
    public static final OptionInstance<Double> attackIndicatorMinValue = new OptionInstance("options.attackIndicatorMinValue", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"options.attackIndicatorMinValue.tooltip")), (optionText, value) -> value == 1.3 ? Objects.requireNonNull(Options.genericValueLabel((Component)optionText, (Component)Component.translatable((String)"options.attackIndicatorMinValue.default"))) : Options.percentValueLabel((Component)optionText, (double)value), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 200).xmap(sliderValue -> (double)sliderValue / 100.0, value -> (int)(value * 100.0)), Codec.doubleRange((double)0.0, (double)2.0), (Object)1.3, value -> {});
    public static final OptionInstance<ShieldIndicatorStatus> shieldIndicator = new OptionInstance("options.shieldIndicator", OptionInstance.noTooltip(), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(ShieldIndicatorStatus.values()), Codec.INT.xmap(ShieldIndicatorStatus::byId, ShieldIndicatorStatus::getId)), (Object)ShieldIndicatorStatus.OFF, value -> {});

    public CombatifyClient(ModContainer container) {
        Combatify.LOGGER.info("Client init started.");
        ClientNetworkingHandler.init();
        Combatify.markState(() -> combatifyState.get());
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        if (Combatify.CONFIG.tieredShields().booleanValue()) {
            event.registerLayerDefinition(IRON_SHIELD_MODEL_LAYER, ShieldModel::createLayer);
            event.registerLayerDefinition(GOLDEN_SHIELD_MODEL_LAYER, ShieldModel::createLayer);
            event.registerLayerDefinition(DIAMOND_SHIELD_MODEL_LAYER, ShieldModel::createLayer);
            event.registerLayerDefinition(NETHERITE_SHIELD_MODEL_LAYER, ShieldModel::createLayer);
        }
    }
}

