/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.client;

import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientMethodHandler {
    public static HitResult redirectResult(@Nullable HitResult instance) {
        if (instance == null) {
            return null;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (Combatify.CONFIG.swingThroughGrass().booleanValue() && instance.getType() == HitResult.Type.BLOCK && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            Entity entity;
            Player minecraftPlayer = (Player)Objects.requireNonNull(minecraft.player);
            Entity player = Objects.requireNonNull(minecraft.getCameraEntity());
            double reach = MethodHandler.getCurrentAttackReachWithoutChargedReach(minecraftPlayer) + (Combatify.CONFIG.chargedReach() != false && !minecraftPlayer.isCrouching() ? MethodHandler.getChargedReach(minecraftPlayer.getItemInHand(InteractionHand.MAIN_HAND)) + 0.25 : 0.25);
            EntityHitResult rayTraceResult = MethodHandler.rayTraceEntity(player, 1.0f, reach);
            Entity entity2 = entity = rayTraceResult != null ? rayTraceResult.getEntity() : null;
            if (entity != null) {
                double dist = player.getEyePosition().distanceToSqr(MethodHandler.getNearestPointTo(entity.getBoundingBox(), player.getEyePosition()));
                if (dist > (reach *= reach)) {
                    return null;
                }
                double enemyDistance = player.distanceTo(entity);
                HitResult newResult = MethodHandler.pickCollisions(player, enemyDistance);
                if (newResult.getType() != HitResult.Type.MISS) {
                    return null;
                }
                return rayTraceResult;
            }
        }
        return null;
    }

    public static void animateBlockingBase(ModelPart arm, boolean rightHanded, float attackTime, float headXRot) {
        float h = Mth.sin((float)(attackTime * (float)Math.PI));
        float i = Mth.sin((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        arm.yRot = (!rightHanded ? -30.0f : 30.0f) * ((float)Math.PI / 180) - (0.1f - h * 0.6f);
        arm.xRot = arm.xRot * 0.5f - 0.9424779f + Mth.clamp((float)headXRot, (float)-1.3962634f, (float)0.43633232f);
        arm.xRot += h * 1.2f - i * 0.4f;
    }

    public static <T extends Mob> void swingWeaponDown(ModelPart rightArm, ModelPart leftArm, T mob, float attackTime, float ageInTicks, float headXRot) {
        float h = Mth.sin((float)(attackTime * (float)Math.PI));
        float i = Mth.sin((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.zRot = 0.0f;
        leftArm.zRot = 0.0f;
        if (mob.getMainArm() == HumanoidArm.RIGHT) {
            rightArm.yRot = 0.15707964f;
            leftArm.yRot = 0.36651915f;
            rightArm.xRot = -1.8849558f + Mth.cos((float)(ageInTicks * 0.09f)) * 0.15f;
            leftArm.xRot = leftArm.xRot * 0.5f - 0.9424779f + Mth.clamp((float)headXRot, (float)-1.3962634f, (float)0.43633232f);
            rightArm.xRot += h * 2.2f - i * 0.4f;
            leftArm.xRot += h * 1.2f - i * 0.4f;
        } else {
            rightArm.yRot = -0.36651915f;
            leftArm.yRot = -0.15707964f;
            rightArm.xRot = rightArm.xRot * 0.5f - 0.9424779f + Mth.clamp((float)headXRot, (float)-1.3962634f, (float)0.43633232f);
            leftArm.xRot = -1.8849558f + Mth.cos((float)(ageInTicks * 0.09f)) * 0.15f;
            rightArm.xRot += h * 1.2f - i * 0.4f;
            leftArm.xRot += h * 2.2f - i * 0.4f;
        }
        AnimationUtils.bobArms((ModelPart)rightArm, (ModelPart)leftArm, (float)ageInTicks);
    }

    public static <T extends Mob> void animateZombieArms(ModelPart leftArm, ModelPart rightArm, T mob, float attackTime, float ageInTicks, float headXRot) {
        float h = Mth.sin((float)(attackTime * (float)Math.PI));
        float i = Mth.sin((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.zRot = 0.0f;
        leftArm.zRot = 0.0f;
        boolean isRightHanded = mob.getMainArm() == HumanoidArm.RIGHT;
        ModelPart modelPart3 = isRightHanded ? rightArm : leftArm;
        ModelPart modelPart4 = isRightHanded ? leftArm : rightArm;
        modelPart3.yRot = -(0.1f - h * 0.6f);
        modelPart4.yRot = (!isRightHanded ? -30.0f : 30.0f) * ((float)Math.PI / 180) + (0.1f - h * 0.6f);
        modelPart3.xRot = -1.3962634f;
        modelPart4.xRot = modelPart4.xRot * 0.5f - 0.9424779f + Mth.clamp((float)headXRot, (float)-1.3962634f, (float)0.43633232f);
        rightArm.xRot += h * 1.2f - i * 0.4f;
        leftArm.xRot += h * 1.2f - i * 0.4f;
        AnimationUtils.bobArms((ModelPart)rightArm, (ModelPart)leftArm, (float)ageInTicks);
    }
}

