/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.custom;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingType;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.condition.AnyOf;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.atlas.combatify.util.blocking.condition.Unconditional;
import net.atlas.combatify.util.blocking.damage_parsers.DamageParser;
import net.atlas.combatify.util.blocking.damage_parsers.Nullify;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageBase;
import net.atlas.combatify.util.blocking.effect.PostBlockEffectWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableFloat;

public record Blocker(List<DamageParser> damageParsers, Tooltip tooltip, ResourceLocation blockingTypeLocation, float useSeconds, PostBlockEffectWrapper postBlockEffect, BlockingCondition blockingCondition) {
    public static final Blocker EMPTY = new Blocker(Collections.emptyList(), new Tooltip(Collections.emptyList(), Collections.emptyList(), false), ResourceLocation.withDefaultNamespace((String)"empty"), 0.0f, PostBlockEffectWrapper.DEFAULT, new AnyOf(Collections.emptyList()));
    public static final Blocker VANILLA_SHIELD = new Blocker(Collections.singletonList(Nullify.NULLIFY_ALL), new Tooltip(Collections.emptyList(), Collections.emptyList(), true), ResourceLocation.withDefaultNamespace((String)"shield"), 3600.0f, PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final Blocker NEW_SHIELD = new Blocker(List.of(PercentageBase.IGNORE_EXPLOSIONS_AND_PROJECTILES, Nullify.NULLIFY_EXPLOSIONS_AND_PROJECTILES), new Tooltip(Collections.singletonList(BlockingTypeInit.NEW_SHIELD_PROTECTION), Collections.singletonList(BlockingTypeInit.NEW_SHIELD_KNOCKBACK), true), ResourceLocation.withDefaultNamespace((String)"new_shield"), 3600.0f, PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final Codec<Blocker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DamageParser.CODEC.listOf().fieldOf("damage_parsers").forGetter(Blocker::damageParsers), (App)Tooltip.CODEC.forGetter(Blocker::tooltip), (App)BlockingType.ID_CODEC.fieldOf("type").forGetter(Blocker::blockingTypeLocation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("seconds", (Object)Float.valueOf(3600.0f)).forGetter(Blocker::useSeconds), (App)PostBlockEffectWrapper.CODEC.orElse((Object)PostBlockEffectWrapper.KNOCKBACK).forGetter(Blocker::postBlockEffect), (App)BlockingConditions.MAP_CODEC.orElse((Object)Unconditional.INSTANCE).forGetter(Blocker::blockingCondition)).apply((Applicative)instance, Blocker::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Blocker> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.fromCodecTrusted(DamageParser.CODEC)), Blocker::damageParsers, (StreamCodec)ByteBufCodecs.fromCodecTrusted((Codec)Tooltip.CODEC.codec()), Blocker::tooltip, (StreamCodec)ResourceLocation.STREAM_CODEC, Blocker::blockingTypeLocation, (StreamCodec)ByteBufCodecs.FLOAT, Blocker::useSeconds, (StreamCodec)ByteBufCodecs.fromCodecWithRegistriesTrusted((Codec)PostBlockEffectWrapper.CODEC.codec()), Blocker::postBlockEffect, BlockingCondition.STREAM_CODEC, Blocker::blockingCondition, Blocker::new);

    public Blocker withProtection(List<ComponentModifier.CombinedModifier> protection) {
        return new Blocker(this.damageParsers, new Tooltip(protection, this.tooltip.knockbackModifiers, this.tooltip.markBlocked), this.blockingTypeLocation, this.useSeconds, this.postBlockEffect, this.blockingCondition);
    }

    public Blocker withKnockback(List<ComponentModifier> knockback) {
        return new Blocker(this.damageParsers, new Tooltip(this.tooltip.protectionModifiers, knockback, this.tooltip.markBlocked), this.blockingTypeLocation, this.useSeconds, this.postBlockEffect, this.blockingCondition);
    }

    public BlockingType blockingType() {
        if (this.blockingTypeLocation.equals((Object)ResourceLocation.withDefaultNamespace((String)"empty"))) {
            return BlockingTypeInit.EMPTY;
        }
        return Combatify.registeredTypes.get(this.blockingTypeLocation);
    }

    public void doEffect(ServerLevel serverLevel, EquipmentSlot equipmentSlot, ItemStack blockingItem, LivingEntity target, LivingEntity attacker, DamageSource damageSource) {
        if (this.postBlockEffect.matches(Enchantment.damageContext((ServerLevel)serverLevel, (int)1, (Entity)target, (DamageSource)damageSource))) {
            LivingEntity applicable = switch (this.postBlockEffect.affected()) {
                default -> throw new MatchException(null, null);
                case EnchantmentTarget.ATTACKER, EnchantmentTarget.DAMAGING_ENTITY -> attacker;
                case EnchantmentTarget.VICTIM -> target;
            };
            this.postBlockEffect.effect().doEffect(serverLevel, new EnchantedItemInUse(blockingItem, equipmentSlot, target), attacker, damageSource, 1, applicable, applicable.position());
        }
        CustomEnchantmentHelper.applyPostBlockedEffects(serverLevel, target, attacker, damageSource);
        MethodHandler.disableShield(attacker, target, damageSource, blockingItem);
    }

    public int useTicks() {
        return (int)(this.useSeconds * 20.0f);
    }

    public void block(ServerLevel serverLevel, LivingEntity instance, DamageSource source, ItemStack itemStack, LocalFloatRef amount, LocalFloatRef protectedDamage, LocalBooleanRef blocked) {
        if (this.blockingCondition.canBlock(serverLevel, instance, itemStack, source, amount.get())) {
            if (MethodHandler.getBlockingType(itemStack).hasDelay() && Combatify.CONFIG.shieldDelay() > 0 && itemStack.getUseDuration(instance) - instance.getUseItemRemainingTicks() < Combatify.CONFIG.shieldDelay()) {
                Entity entity;
                if (Combatify.CONFIG.disableDuringShieldDelay().booleanValue() && (entity = source.getDirectEntity()) instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    MethodHandler.disableShield(attacker, instance, source, itemStack);
                }
                return;
            }
            this.completeBlock(serverLevel, instance, itemStack, source, amount, protectedDamage, blocked);
        }
    }

    public void completeBlock(ServerLevel serverLevel, LivingEntity instance, ItemStack blockingItem, DamageSource source, LocalFloatRef amount, LocalFloatRef protectedDamage, LocalBooleanRef wasBlocked) {
        int blockingLevel = (Integer)blockingItem.getOrDefault(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
        ComponentModifier.DataSet protection = new ComponentModifier.DataSet(0.0f, 0.0f);
        List<ComponentModifier.CombinedModifier> intermediaryProtection = this.tooltip.protectionModifiers().stream().filter(combinedModifier -> combinedModifier.matches(blockingItem)).toList();
        if (!intermediaryProtection.isEmpty()) {
            protection = intermediaryProtection.getFirst().tryCombineVal(intermediaryProtection, blockingLevel, instance.getRandom());
        }
        ComponentModifier.DataSet endProtection = CustomEnchantmentHelper.modifyShieldEffectiveness(blockingItem, instance.getRandom(), protection);
        this.damageParsers.forEach(damageParserConditionalEffect -> {
            protectedDamage.set(damageParserConditionalEffect.parse(amount.get(), endProtection, (Holder<DamageType>)source.typeHolder()));
            amount.set(Math.max(amount.get() - protectedDamage.get(), 0.0f));
        });
        MethodHandler.hurtCurrentlyUsedShield(instance, protectedDamage.get());
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            MethodHandler.blockedByShield(serverLevel, instance, livingEntity, source);
        }
        Entity entity2 = source.getDirectEntity();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class, SpectralArrow.class}, (Object)entity2, n)) {
                case 0: {
                    Arrow arrow = (Arrow)entity2;
                    if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((AbstractArrow)arrow)) {
                        n = 1;
                        continue block4;
                    }
                    MethodHandler.arrowDisable(instance, source, (AbstractArrow)arrow, blockingItem);
                    break block4;
                }
                case 1: {
                    SpectralArrow arrow = (SpectralArrow)entity2;
                    if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((AbstractArrow)arrow)) {
                        n = 2;
                        continue block4;
                    }
                    MethodHandler.arrowDisable(instance, source, (AbstractArrow)arrow, blockingItem);
                    break block4;
                }
            }
            break;
        }
        wasBlocked.set(this.tooltip.markBlocked);
    }

    public InteractionResult use(ItemStack itemStack, Level level, Player user, InteractionHand hand, InteractionResult original) {
        if (this.blockingTypeLocation.equals((Object)ResourceLocation.withDefaultNamespace((String)"empty"))) {
            return null;
        }
        if (original != InteractionResult.PASS) {
            return null;
        }
        if (!this.canUse(itemStack, level, user, hand)) {
            return null;
        }
        user.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public boolean canUse(ItemStack itemStack, Level level, Player user, InteractionHand hand) {
        return this.blockingCondition.canUse(itemStack, level, user, hand);
    }

    public boolean canShowInTooltip(ItemStack itemStack, Player player) {
        return this.blockingCondition.canShowInToolTip(itemStack, player);
    }

    public boolean canOverrideUseDurationAndAnimation(ItemStack itemStack) {
        return this.blockingCondition.overridesUseDurationAndAnimation(itemStack);
    }

    public record Tooltip(List<ComponentModifier.CombinedModifier> protectionModifiers, List<ComponentModifier> knockbackModifiers, boolean markBlocked) {
        public static MapCodec<Tooltip> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentModifier.CombinedModifier.CODEC.listOf().fieldOf("protection_modifiers").forGetter(Tooltip::protectionModifiers), (App)ComponentModifier.CODEC.listOf().optionalFieldOf("knockback_modifiers", Collections.emptyList()).forGetter(Tooltip::knockbackModifiers), (App)Codec.BOOL.fieldOf("mark_blocked").forGetter(Tooltip::markBlocked)).apply((Applicative)instance, Tooltip::new));

        public void appendTooltipInfo(Consumer<Component> writer, Player player, ItemStack stack) {
            List<ComponentModifier> intermediaryKnockback;
            List<Object> protection = Collections.emptyList();
            List<Object> knockback = Collections.emptyList();
            int blockingLevel = (Integer)stack.getOrDefault(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            List<ComponentModifier.CombinedModifier> intermediaryProtection = this.protectionModifiers.stream().filter(combinedModifier -> combinedModifier.matches(stack)).toList();
            if (!intermediaryProtection.isEmpty()) {
                protection = intermediaryProtection.getFirst().tryCombine(new ArrayList<ComponentModifier.CombinedModifier>(intermediaryProtection), blockingLevel, player.getRandom());
            }
            if (!(intermediaryKnockback = this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(stack)).toList()).isEmpty()) {
                knockback = intermediaryKnockback.getFirst().tryCombine(new ArrayList<ComponentModifier>(intermediaryKnockback), blockingLevel, player.getRandom());
            }
            if (protection.isEmpty() && knockback.isEmpty()) {
                return;
            }
            writer.accept(CommonComponents.EMPTY);
            writer.accept((Component)Component.translatableWithFallback((String)"item.modifiers.use", (String)"When used:").withStyle(ChatFormatting.GRAY));
            protection.forEach(component -> writer.accept((Component)CommonComponents.space().append(component).withStyle(ChatFormatting.DARK_GREEN)));
            knockback.forEach(component -> writer.accept((Component)CommonComponents.space().append(component).withStyle(ChatFormatting.DARK_GREEN)));
        }

        public float getShieldKnockbackResistanceValue(ItemStack itemStack, RandomSource randomSource) {
            int blockingLevel = (Integer)itemStack.getOrDefault(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            MutableFloat knockbackResistance = new MutableFloat(0.0f);
            this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(itemStack)).forEach(componentModifier -> knockbackResistance.setValue(componentModifier.modifyValue(knockbackResistance.getValue().floatValue(), blockingLevel, randomSource)));
            return knockbackResistance.getValue().floatValue();
        }
    }
}

