/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.item.WeaponType;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.generators.WeaponLevelBasedValue;
import net.atlas.defaulted.extension.ItemExtensions;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record WeaponStatsGenerator(List<WeaponLevelBasedValue> damage, List<WeaponLevelBasedValue> speed, List<WeaponLevelBasedValue> reach, Optional<ResourceLocation> damageIdOverride, Optional<ResourceLocation> speedIdOverride, Optional<ResourceLocation> reachIdOverride, List<ItemAttributeModifiers.Entry> additionalModifiers, boolean tieredDamage, boolean persistPrevious) implements PatchGenerator
{
    public static final MapCodec<WeaponStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_damage", Collections.emptyList()).forGetter(WeaponStatsGenerator::damage), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_speed", Collections.emptyList()).forGetter(WeaponStatsGenerator::speed), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_reach", Collections.emptyList()).forGetter(WeaponStatsGenerator::reach), (App)ResourceLocation.CODEC.optionalFieldOf("damage_id_override").forGetter(WeaponStatsGenerator::damageIdOverride), (App)ResourceLocation.CODEC.optionalFieldOf("speed_id_override").forGetter(WeaponStatsGenerator::speedIdOverride), (App)ResourceLocation.CODEC.optionalFieldOf("reach_id_override").forGetter(WeaponStatsGenerator::reachIdOverride), (App)ItemAttributeModifiers.Entry.CODEC.listOf().optionalFieldOf("additional_modifiers", Collections.emptyList()).forGetter(WeaponStatsGenerator::additionalModifiers), (App)Codec.BOOL.optionalFieldOf("apply_tier_to_damage", (Object)true).forGetter(WeaponStatsGenerator::tieredDamage), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(WeaponStatsGenerator::persistPrevious)).apply((Applicative)instance, WeaponStatsGenerator::new));

    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        ItemAttributeModifiers oldModifiers = (ItemAttributeModifiers)patchedDataComponentMap.get(DataComponents.ATTRIBUTE_MODIFIERS);
        ToolMaterialWrapper toolMaterialWrapper = ((ItemExtensions)item).defaulted$getToolMaterial();
        if (toolMaterialWrapper == null) {
            toolMaterialWrapper = Defaulted.DEFAULT_WRAPPER;
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        double damageModifier = 2.0 - Combatify.CONFIG.fistDamage();
        ResourceLocation damageID = this.damageIdOverride.orElse(Item.BASE_ATTACK_DAMAGE_ID);
        ResourceLocation speedID = this.speedIdOverride.orElse(WeaponType.BASE_ATTACK_SPEED_CTS_ID);
        ResourceLocation reachID = this.reachIdOverride.orElse(WeaponType.BASE_ATTACK_REACH_ID);
        AttributeModifier attackDamage = null;
        boolean hasDamage = false;
        if (!this.damage.isEmpty()) {
            hasDamage = true;
            attackDamage = new AttributeModifier(damageID, this.getTierModifier(toolMaterialWrapper, true, this.damage) + damageModifier, AttributeModifier.Operation.ADD_VALUE);
        }
        AttributeModifier attackSpeed = null;
        boolean hasSpeed = false;
        if (!this.speed.isEmpty()) {
            hasSpeed = true;
            attackSpeed = new AttributeModifier(speedID, this.getTierModifier(toolMaterialWrapper, false, this.speed), AttributeModifier.Operation.ADD_VALUE);
        }
        AttributeModifier attackReach = null;
        boolean hasReach = false;
        if (!this.reach.isEmpty()) {
            hasReach = true;
            attackReach = new AttributeModifier(reachID, this.getTierModifier(toolMaterialWrapper, false, this.reach), AttributeModifier.Operation.ADD_VALUE);
        }
        if (!hasDamage && !hasSpeed) {
            return;
        }
        for (ItemAttributeModifiers.Entry entry : this.additionalModifiers) {
            if (hasDamage && entry.matches(Attributes.ATTACK_DAMAGE, damageID) || hasSpeed && this.isSpeed(entry, speedID) || hasReach && entry.matches(Attributes.ENTITY_INTERACTION_RANGE, reachID)) continue;
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        if (this.persistPrevious && oldModifiers != null) {
            for (ItemAttributeModifiers.Entry entry : oldModifiers.modifiers()) {
                if (hasDamage && entry.matches(Attributes.ATTACK_DAMAGE, damageID) || hasSpeed && this.isSpeed(entry, speedID) || hasReach && entry.matches(Attributes.ENTITY_INTERACTION_RANGE, reachID)) continue;
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
        }
        if (hasDamage) {
            builder.add(Attributes.ATTACK_DAMAGE, attackDamage, EquipmentSlotGroup.MAINHAND);
        }
        if (hasSpeed) {
            builder.add(Attributes.ATTACK_SPEED, attackSpeed, EquipmentSlotGroup.MAINHAND);
        }
        if (hasReach) {
            builder.add(Attributes.ENTITY_INTERACTION_RANGE, attackReach, EquipmentSlotGroup.MAINHAND);
        }
        patchedDataComponentMap.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
    }

    private boolean isSpeed(ItemAttributeModifiers.Entry entry, ResourceLocation speedID) {
        boolean baseRet = entry.matches(Attributes.ATTACK_SPEED, speedID);
        if (speedID.equals((Object)WeaponType.BASE_ATTACK_SPEED_CTS_ID)) {
            baseRet |= entry.matches(Attributes.ATTACK_SPEED, Item.BASE_ATTACK_SPEED_ID);
        }
        return baseRet;
    }

    private double getTierModifier(ToolMaterialWrapper tier, boolean forDamage, List<WeaponLevelBasedValue> list) {
        if (forDamage) {
            for (WeaponLevelBasedValue value : list) {
                if (value instanceof WeaponLevelBasedValue.Unconditional) {
                    WeaponLevelBasedValue.Unconditional unconditional = (WeaponLevelBasedValue.Unconditional)value;
                    return unconditional.value() + (this.tieredDamage ? tier.attackDamageBonus() : 0.0f);
                }
                Float res = value.getResult(tier.weaponLevel(), this.tieredDamage);
                if (res == null) continue;
                return res.floatValue();
            }
        } else {
            for (WeaponLevelBasedValue value : list) {
                Float res = value.getResult(tier.weaponLevel(), true);
                if (res == null) continue;
                return res.floatValue();
            }
        }
        return 0.0;
    }

    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

