/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.util.ConfigRepresentable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AttackDecay
implements ConfigRepresentable<AttackDecay> {
    public static final AttackDecay DEFAULT = new AttackDecay(null, false, 0, 100, 20, 100, 0, 100);
    public static final StreamCodec<RegistryFriendlyByteBuf, AttackDecay> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AttackDecay>(){

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, AttackDecay projectileDamage) {
            registryFriendlyByteBuf.writeResourceLocation(projectileDamage.owner.heldValue.owner().name);
            registryFriendlyByteBuf.writeUtf(projectileDamage.owner.heldValue.name());
            registryFriendlyByteBuf.writeBoolean(projectileDamage.enabled.booleanValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.minCharge.intValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.maxCharge.intValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.minPercentageBase.intValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.maxPercentageBase.intValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.minPercentageEnchants.intValue());
            registryFriendlyByteBuf.writeVarInt(projectileDamage.maxPercentageEnchants.intValue());
        }

        @NotNull
        public AttackDecay decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            AtlasConfig config = (AtlasConfig)AtlasConfig.configs.get(registryFriendlyByteBuf.readResourceLocation());
            return new AttackDecay((AtlasConfig.ConfigHolder<AttackDecay>)((AtlasConfig.ConfigHolder)config.valueNameToConfigHolderMap.get(registryFriendlyByteBuf.readUtf())), registryFriendlyByteBuf.readBoolean(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readVarInt());
        }
    };
    public AtlasConfig.ConfigHolder<AttackDecay> owner;
    public Boolean enabled;
    public Integer minCharge;
    public Integer maxCharge;
    public Integer minPercentageBase;
    public Integer maxPercentageBase;
    public Integer minPercentageEnchants;
    public Integer maxPercentageEnchants;
    public static final Map<String, Field> fields = (Map)Util.make(new HashMap(), hashMap -> {
        try {
            hashMap.put("enabled", AttackDecay.class.getDeclaredField("enabled"));
            hashMap.put("minCharge", AttackDecay.class.getDeclaredField("minCharge"));
            hashMap.put("maxCharge", AttackDecay.class.getDeclaredField("maxCharge"));
            hashMap.put("minPercentageBase", AttackDecay.class.getDeclaredField("minPercentageBase"));
            hashMap.put("maxPercentageBase", AttackDecay.class.getDeclaredField("maxPercentageBase"));
            hashMap.put("minPercentageEnchants", AttackDecay.class.getDeclaredField("minPercentageEnchants"));
            hashMap.put("maxPercentageEnchants", AttackDecay.class.getDeclaredField("maxPercentageEnchants"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    });
    public static final BiFunction<AttackDecay, String, Component> convertFieldToComponent = (projectileDamage, string) -> {
        try {
            return Component.translatable((String)(projectileDamage.owner.getTranslationKey() + "." + string)).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf(projectileDamage.fieldRepresentingHolder((String)string).get(projectileDamage))));
        }
        catch (IllegalAccessException var3) {
            return Component.translatable((String)(projectileDamage.owner.getTranslationKey() + "." + string));
        }
    };
    public static final BiFunction<AttackDecay, String, Component> convertFieldToNameComponent = (projectileDamage, string) -> Component.translatable((String)(projectileDamage.owner.getTranslationKey() + "." + string));
    public static final BiFunction<AttackDecay, String, Component> convertFieldToValueComponent = (projectileDamage, string) -> {
        try {
            return Component.literal((String)String.valueOf(projectileDamage.fieldRepresentingHolder((String)string).get(projectileDamage)));
        }
        catch (IllegalAccessException var3) {
            return Component.translatable((String)(projectileDamage.owner.getTranslationKey() + "." + string));
        }
    };
    public Supplier<Component> resetTranslation = null;

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer minCharge() {
        return this.minCharge;
    }

    public Integer maxCharge() {
        return this.maxCharge;
    }

    public Integer minPercentageBase() {
        return this.minPercentageBase;
    }

    public Integer maxPercentageBase() {
        return this.maxPercentageBase;
    }

    public Integer minPercentageEnchants() {
        return this.minPercentageEnchants;
    }

    public Integer maxPercentageEnchants() {
        return this.maxPercentageEnchants;
    }

    public AttackDecay(AtlasConfig.ConfigHolder<AttackDecay> owner, Boolean enabled, Integer minCharge, Integer maxCharge, Integer minPercentageBase, Integer maxPercentageBase, Integer minPercentageEnchants, Integer maxPercentageEnchants) {
        this.owner = owner;
        this.enabled = enabled;
        this.minCharge = Mth.clamp((int)minCharge, (int)0, (int)200);
        this.maxCharge = Mth.clamp((int)maxCharge, (int)0, (int)200);
        this.minPercentageBase = Mth.clamp((int)minPercentageBase, (int)0, (int)200);
        this.maxPercentageBase = Mth.clamp((int)maxPercentageBase, (int)0, (int)200);
        this.minPercentageEnchants = Mth.clamp((int)minPercentageEnchants, (int)0, (int)200);
        this.maxPercentageEnchants = Mth.clamp((int)maxPercentageEnchants, (int)0, (int)200);
    }

    public Codec<AttackDecay> getCodec(AtlasConfig.ConfigHolder<AttackDecay> configHolder) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)false).forGetter(AttackDecay::enabled), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("minCharge", (Object)0).forGetter(AttackDecay::minCharge), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("maxCharge", (Object)100).forGetter(AttackDecay::maxCharge), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("minPercentageBase", (Object)20).forGetter(AttackDecay::minPercentageBase), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("maxPercentageBase", (Object)100).forGetter(AttackDecay::maxPercentageBase), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("minPercentageEnchants", (Object)0).forGetter(AttackDecay::minPercentageEnchants), (App)ExtraCodecs.intRange((int)0, (int)200).optionalFieldOf("maxPercentageEnchants", (Object)100).forGetter(AttackDecay::maxPercentageEnchants)).apply((Applicative)instance, (enabled, minCharge, maxCharge, minPercentageBase, maxPercentageBase, minPercentageEnchants, maxPercentageEnchants) -> new AttackDecay(configHolder, (Boolean)enabled, (Integer)minCharge, (Integer)maxCharge, (Integer)minPercentageBase, (Integer)maxPercentageBase, (Integer)minPercentageEnchants, (Integer)maxPercentageEnchants)));
    }

    public void setOwnerHolder(AtlasConfig.ConfigHolder<AttackDecay> owner) {
        this.owner = owner;
    }

    public List<String> fields() {
        return fields.keySet().stream().toList();
    }

    public Component getFieldValue(String name) {
        return convertFieldToValueComponent.apply(this, name);
    }

    public Component getFieldName(String name) {
        return convertFieldToNameComponent.apply(this, name);
    }

    public void listField(String name, Consumer<Component> input) {
        input.accept(convertFieldToComponent.apply(this, name));
    }

    public void listFields(Consumer<Component> input) {
        fields.keySet().forEach(string -> input.accept(convertFieldToComponent.apply(this, (String)string)));
    }

    public Field fieldRepresentingHolder(String name) {
        return fields.get(name);
    }

    public ArgumentType<?> argumentTypeRepresentingHolder(String name) {
        Object o;
        try {
            o = fields.get(name).get(this);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Integer.class}, (Object)object, n)) {
            case 0 -> {
                Boolean ignored = (Boolean)object;
                yield BoolArgumentType.bool();
            }
            case 1 -> {
                Integer ignored = (Integer)object;
                yield IntegerArgumentType.integer((int)0, (int)200);
            }
            default -> null;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public List<AbstractConfigListEntry<?>> transformIntoConfigEntries() {
        if (this.resetTranslation == null) {
            this.resetTranslation = () -> Component.translatable((String)this.owner.getTranslationResetKey());
        }
        ArrayList entries = new ArrayList();
        entries.add((AbstractConfigListEntry<?>)new BooleanListEntry(convertFieldToNameComponent.apply(this, "enabled"), this.enabled.booleanValue(), this.resetTranslation.get(), () -> false, enabled -> {
            this.enabled = enabled;
        }, this.setupTooltip(1, "enabled"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "minCharge"), this.minCharge, this.resetTranslation.get(), () -> 0, charge -> {
            this.minCharge = Mth.clamp((int)charge, (int)0, (int)200);
        }, this.setupTooltip(1, "minCharge"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "maxCharge"), this.maxCharge, this.resetTranslation.get(), () -> 100, charge -> {
            this.maxCharge = Mth.clamp((int)charge, (int)0, (int)200);
        }, this.setupTooltip(1, "maxCharge"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "minPercentageBase"), this.minPercentageBase, this.resetTranslation.get(), () -> 20, percent -> {
            this.minPercentageBase = Mth.clamp((int)percent, (int)0, (int)200);
        }, this.setupTooltip(3, "minPercentageBase"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "maxPercentageBase"), this.maxPercentageBase, this.resetTranslation.get(), () -> 100, percent -> {
            this.maxPercentageBase = Mth.clamp((int)percent, (int)0, (int)200);
        }, this.setupTooltip(3, "maxPercentageBase"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "minPercentageEnchants"), this.minPercentageEnchants, this.resetTranslation.get(), () -> 0, percent -> {
            this.minPercentageEnchants = Mth.clamp((int)percent, (int)0, (int)200);
        }, this.setupTooltip(2, "minPercentageEnchants"), false));
        entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "maxPercentageEnchants"), this.maxPercentageEnchants, this.resetTranslation.get(), () -> 100, percent -> {
            this.maxPercentageEnchants = Mth.clamp((int)percent, (int)0, (int)200);
        }, this.setupTooltip(2, "maxPercentageEnchants"), false));
        entries.forEach(entry -> entry.setEditable(!this.owner.serverManaged));
        return entries;
    }

    public Supplier<Optional<Component[]>> setupTooltip(int length, String field) {
        Component[] components = new Component[length];
        String key = this.owner.getTranslationKey() + "." + field;
        components[0] = Component.translatable((String)(key + ".tooltip"));
        for (int i = 1; i < length; ++i) {
            components[i] = Component.translatable((String)(key + ".tooltip." + i));
        }
        return () -> Optional.of(components);
    }
}

