/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.atlas.combatify.config.ConfigurableItemData;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ConfigurableEntityData(Optional<Integer> optionalAttackInterval, Optional<Double> optionalShieldDisableTime, Optional<Boolean> optionalIsMiscEntity) {
    public static final ConfigurableEntityData EMPTY = new ConfigurableEntityData(Optional.empty(), Optional.empty(), Optional.empty());
    public static final MapCodec<ConfigurableEntityData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("attack_interval").forGetter(ConfigurableEntityData::optionalAttackInterval), (App)Codec.DOUBLE.optionalFieldOf("shield_disable_time").forGetter(ConfigurableEntityData::optionalShieldDisableTime), (App)Codec.BOOL.optionalFieldOf("is_misc_entity").forGetter(ConfigurableEntityData::optionalIsMiscEntity)).apply((Applicative)instance, ConfigurableEntityData::new));
    public static final StreamCodec<? super ByteBuf, ConfigurableEntityData> ENTITY_DATA_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), ConfigurableEntityData::optionalAttackInterval, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.DOUBLE), ConfigurableEntityData::optionalShieldDisableTime, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL), ConfigurableEntityData::optionalIsMiscEntity, ConfigurableEntityData::new);

    public ConfigurableEntityData(Optional<Integer> optionalAttackInterval, Optional<Double> optionalShieldDisableTime, Optional<Boolean> optionalIsMiscEntity) {
        this.optionalAttackInterval = ConfigurableItemData.clamp(optionalAttackInterval, 0, 1000);
        this.optionalShieldDisableTime = ConfigurableItemData.clamp(optionalShieldDisableTime, 0.0, 10.0);
        this.optionalIsMiscEntity = optionalIsMiscEntity;
    }

    public Integer attackInterval() {
        return this.optionalAttackInterval.orElse(null);
    }

    public Double shieldDisableTime() {
        return this.optionalShieldDisableTime.orElse(null);
    }

    public Boolean isMiscEntity() {
        return this.optionalIsMiscEntity.orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableEntityData)) {
            return false;
        }
        ConfigurableEntityData that = (ConfigurableEntityData)o;
        return Objects.equals(this.optionalAttackInterval, that.optionalAttackInterval) && Objects.equals(this.optionalShieldDisableTime, that.optionalShieldDisableTime) && Objects.equals(this.optionalIsMiscEntity, that.optionalIsMiscEntity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.optionalAttackInterval, this.optionalShieldDisableTime, this.optionalIsMiscEntity);
    }
}

