/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;

public record ConfigurableItemData(Optional<Double> optionalUseDuration, Optional<Double> optionalCooldownSeconds) {
    public static final ConfigurableItemData EMPTY = new ConfigurableItemData((Double)null, null);
    public static final MapCodec<ConfigurableItemData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)0.05, (double)50.0).optionalFieldOf("use_seconds").forGetter(ConfigurableItemData::optionalUseDuration), (App)Codec.doubleRange((double)0.05, (double)50.0).optionalFieldOf("cooldown_seconds").forGetter(ConfigurableItemData::optionalCooldownSeconds)).apply((Applicative)instance, ConfigurableItemData::new));

    public ConfigurableItemData(Double useDuration, Double cooldownSeconds) {
        this(Optional.ofNullable(useDuration), Optional.ofNullable(cooldownSeconds));
    }

    public Double useDuration() {
        return this.optionalUseDuration.orElse(null);
    }

    public Double cooldownSeconds() {
        return this.optionalCooldownSeconds.orElse(null);
    }

    public static Optional<Integer> max(Optional<Integer> value, int min) {
        return value.map(integer -> Math.max(integer, min));
    }

    public static Optional<Double> max(Optional<Double> value, double min) {
        return value.map(val -> Math.max(val, min));
    }

    public static Optional<Integer> clamp(Optional<Integer> value, int min, int max) {
        return value.map(integer -> Math.min(Math.max(integer, min), max));
    }

    public static Optional<Double> clamp(Optional<Double> value, double min, double max) {
        return value.map(val -> Math.min(Math.max(val, min), max));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableItemData)) {
            return false;
        }
        ConfigurableItemData that = (ConfigurableItemData)o;
        return Objects.equals(this.optionalUseDuration, that.optionalUseDuration) && Objects.equals(this.optionalCooldownSeconds, that.optionalCooldownSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.optionalUseDuration, this.optionalCooldownSeconds);
    }
}

