/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import net.atlas.combatify.Combatify;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.QuadConsumer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import org.jetbrains.annotations.Nullable;

public enum KnockbackMode {
    VANILLA,
    OLD,
    CTS_8C,
    CTS_5,
    MIDAIR;


    public void runKnockback(LivingEntity target, @Nullable DamageSource source, double strength, double x, double z, QuadConsumer<LivingEntity, Double, Double, Double> vanillaCall) {
        boolean applyNonProjectileKB = false;
        if (this == MIDAIR && source == null) {
            applyNonProjectileKB = true;
        } else if (source != null) {
            applyNonProjectileKB = Combatify.CONFIG.fishingHookKB() != false && source.getDirectEntity() instanceof FishingHook;
        }
        switch (this.ordinal()) {
            case 4: {
                if (applyNonProjectileKB || !source.is(DamageTypeTags.IS_PROJECTILE)) {
                    MethodHandler.midairKnockback(target, strength, x, z);
                    break;
                }
                MethodHandler.knockback(target, strength, x, z);
                break;
            }
            case 2: {
                if (applyNonProjectileKB) {
                    MethodHandler.midairKnockback(target, strength, x, z);
                    break;
                }
                MethodHandler.knockback(target, strength, x, z);
                break;
            }
            case 3: {
                MethodHandler.combatTest5Knockback(target, strength, x, z);
                break;
            }
            case 0: {
                vanillaCall.accept(target, strength, x, z);
                break;
            }
            case 1: {
                MethodHandler.oldKnockback(target, strength, x, z);
            }
        }
    }
}

