/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config.wrapper;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.wrapper.GenericAPIWrapper;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface DataComponentMapWrapper<M extends DataComponentMap>
extends GenericAPIWrapper<M> {
    public RegistryOps<Tag> ops();

    public ResourceKey<Registry<DataComponentType<?>>> reg();

    default public <T> T get(String type) {
        DataComponentType dataComponentType = (DataComponentType)((HolderGetter)this.ops().getter(this.reg()).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.asLookup())).getOrThrow(ResourceKey.create(this.reg(), (ResourceLocation)ResourceLocation.parse((String)type))).value();
        return (T)((DataComponentMap)this.unwrap()).get(dataComponentType);
    }

    default public <T> T getOrDefault(String type, String defaultValue) {
        Object defaultVal;
        DataComponentType dataComponentType = (DataComponentType)((HolderGetter)this.ops().getter(this.reg()).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.asLookup())).getOrThrow(ResourceKey.create(this.reg(), (ResourceLocation)ResourceLocation.parse((String)type))).value();
        StringReader reader = new StringReader(defaultValue);
        try {
            Tag tag = new TagParser(reader).readValue();
            defaultVal = dataComponentType.codec().parse(this.ops(), (Object)tag).getOrThrow(s -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create());
        }
        catch (CommandSyntaxException e) {
            Combatify.LOGGER.error("Failed to decode default value obtained from a DataComponentMap in JavaScript! Exception: " + String.valueOf((Object)e));
            return (T)((DataComponentMap)this.unwrap()).get(dataComponentType);
        }
        return (T)((DataComponentMap)this.unwrap()).getOrDefault(dataComponentType, defaultVal);
    }
}

