/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config.wrapper;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.wrapper.DataComponentMapWrapper;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record PatchedDataComponentMapWrapper(RegistryOps<Tag> ops, ResourceKey<Registry<DataComponentType<?>>> reg, PatchedDataComponentMap value) implements DataComponentMapWrapper<PatchedDataComponentMap>
{
    public <T> void set(String type, String value) {
        Object val;
        DataComponentType dataComponentType = (DataComponentType)((HolderGetter)this.ops().getter(this.reg()).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.asLookup())).getOrThrow(ResourceKey.create(this.reg(), (ResourceLocation)ResourceLocation.parse((String)type))).value();
        StringReader reader = new StringReader(value);
        try {
            Tag tag = new TagParser(reader).readValue();
            val = dataComponentType.codec().parse(this.ops(), (Object)tag).getOrThrow(s -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create());
        }
        catch (CommandSyntaxException e) {
            Combatify.LOGGER.error("Failed to decode input to set the value of " + type + "! Exception: " + String.valueOf((Object)e));
            return;
        }
        this.unwrap().set(dataComponentType, val);
    }

    public <T> void remove(String type) {
        DataComponentType dataComponentType = (DataComponentType)((HolderGetter)this.ops().getter(this.reg()).orElse(BuiltInRegistries.DATA_COMPONENT_TYPE.asLookup())).getOrThrow(ResourceKey.create(this.reg(), (ResourceLocation)ResourceLocation.parse((String)type))).value();
        this.unwrap().remove(dataComponentType);
    }

    public void applyPatch(String patch) {
        DataComponentPatch val;
        StringReader reader = new StringReader(patch);
        try {
            Tag tag = new TagParser(reader).readValue();
            val = (DataComponentPatch)DataComponentPatch.CODEC.parse(this.ops(), (Object)tag).getOrThrow(s -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create());
        }
        catch (CommandSyntaxException e) {
            Combatify.LOGGER.error("Failed to decode data component patch! Exception: " + String.valueOf((Object)e));
            return;
        }
        this.unwrap().applyPatch(val);
    }

    @Override
    public PatchedDataComponentMap unwrap() {
        return this.value;
    }
}

