/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import java.util.List;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.item.WeaponType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LongSwordItem
extends TieredItem {
    public LongSwordItem(Tier tier, int weaponLevel, Item.Properties properties) {
        super(tier, properties.component(DataComponents.TOOL, (Object)LongSwordItem.createToolProperties()).component(CustomDataComponents.PIERCING_LEVEL, (Object)Float.valueOf(LongSwordItem.piercingLevelForTier(weaponLevel))).attributes(LongSwordItem.baseAttributeModifiers(weaponLevel, tier)));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers baseAttributeModifiers(int weaponLevel, Tier tier) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        WeaponType.LONGSWORD.addCombatAttributes(weaponLevel, tier, builder);
        return builder.build();
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public static float piercingLevelForTier(int weaponLevel) {
        return weaponLevel >= 4 ? 0.2f : (weaponLevel <= 1 ? 0.0f : 0.1f * (float)(weaponLevel - 1));
    }
}

