/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ArmourPiercingMode;
import net.atlas.combatify.config.JSImpl;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CombatRules.class})
public class CombatRulesMixin {
    @Inject(method={"getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F"}, at={@At(value="HEAD")})
    private static void changeArmourAndProtection(LivingEntity attacked, float f, DamageSource damageSource, float g, float h, CallbackInfoReturnable<Float> cir, @Local(ordinal=1, argsOnly=true) LocalFloatRef armour, @Local(ordinal=2, argsOnly=true) LocalFloatRef toughness) {
        Entity entity;
        if (Combatify.CONFIG.armourPiercingMode() == ArmourPiercingMode.APPLY_BEFORE_PERCENTAGE && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack held = livingEntity.getItemInHand(InteractionHand.MAIN_HAND);
            double d = MethodHandler.getPiercingLevel(held);
            Level level = attacked.level();
            if (!(level instanceof ServerLevel)) {
                d += (double)CustomEnchantmentHelper.getBreach(held, livingEntity.getRandom());
            } else {
                ServerLevel serverLevel = (ServerLevel)level;
                d += (double)CustomEnchantmentHelper.getArmorModifier(serverLevel, held, (Entity)attacked, damageSource);
            }
            livingEntity.combatify$setPiercingNegation(0.0);
            armour.set((float)((double)armour.get() * (1.0 - (d -= livingEntity.combatify$getPiercingNegation()))));
            toughness.set((float)((double)toughness.get() * (1.0 - d)));
        }
    }

    @ModifyReturnValue(method={"getDamageAfterAbsorb(Lnet/minecraft/world/entity/LivingEntity;FLnet/minecraft/world/damagesource/DamageSource;FF)F"}, at={@At(value="RETURN")})
    private static float changeArmourCalcs(float original, @Local(ordinal=0, argsOnly=true) float amount, @Local(ordinal=0, argsOnly=true) DamageSource damageSource, @Local(ordinal=1, argsOnly=true) float armour, @Local(ordinal=2, argsOnly=true) float toughness) {
        if (((JSImpl)Combatify.ITEMS.armourCalcs.get()).execFunc("shouldOverrideArmorProtection()", new Object[0])) {
            Level level;
            float result = (float)((JSImpl)Combatify.ITEMS.armourCalcs.get()).execGetterFunc(original, "armorProtection(damage, armor, armorToughness)", Float.valueOf(amount), Float.valueOf(armour), Float.valueOf(toughness));
            ItemStack itemStack = damageSource.getWeaponItem();
            if (itemStack != null && (level = damageSource.getEntity().level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                original = 1.0f - Mth.clamp((float)EnchantmentHelper.modifyArmorEffectiveness((ServerLevel)serverLevel, (ItemStack)itemStack, (Entity)damageSource.getEntity(), (DamageSource)damageSource, (float)result), (float)0.0f, (float)1.0f);
            } else {
                original = 1.0f - result;
            }
            original *= amount;
        }
        if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
            Combatify.LOGGER.info("Damage: " + amount + " Result: " + original);
        }
        return original;
    }

    @ModifyReturnValue(method={"getDamageAfterMagicAbsorb(FF)F"}, at={@At(value="RETURN")})
    private static float changeEnchant(float original, @Local(ordinal=0, argsOnly=true) float amount, @Local(ordinal=1, argsOnly=true) float enchantLevel) {
        if (((JSImpl)Combatify.ITEMS.armourCalcs.get()).execFunc("shouldOverrideEnchantmentProtection()", new Object[0])) {
            original = (float)((JSImpl)Combatify.ITEMS.armourCalcs.get()).execGetterFunc(original, "enchantmentProtection(damage, protectionLevel)", Float.valueOf(amount), Float.valueOf(enchantLevel));
        }
        return original;
    }
}

