/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.wrapper.FoodDataWrapper;
import net.atlas.combatify.config.wrapper.PlayerWrapper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class FoodDataMixin {
    @Unique
    private final FoodData foodData = (FoodData)FoodData.class.cast(this);

    @WrapMethod(method={"add(IF)V"})
    public void capAt20(int food, float saturation, Operation<Void> original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{food, Float.valueOf(saturation)});
            return;
        }
        boolean cancel = Combatify.CONFIG.getFoodImpl().execFunc("addFood(foodData, food, saturation)", new FoodDataWrapper(this.foodData), food, Float.valueOf(saturation));
        if (!cancel) {
            original.call(new Object[]{food, Float.valueOf(saturation)});
        }
    }

    @Inject(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTickExecuteJS(Player player, CallbackInfo ci) {
        boolean cancel = Combatify.CONFIG.getFoodImpl().execFunc("processHungerTick(foodData, player)", new FoodDataWrapper(this.foodData), new PlayerWrapper<Player>(player));
        if (cancel) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="CONSTANT", args={"intValue=18"})})
    public int changeConst(int original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return (int)Combatify.CONFIG.getFoodImpl().execGetterFunc(original, "getMinimumHealingLevel()", new Object[0]);
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="CONSTANT", args={"intValue=20"})})
    public int changeConst2(int original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.CONFIG.getFoodImpl().execFunc("canFastHeal(foodData, player)", new FoodDataWrapper(this.foodData), new PlayerWrapper<Player>(player)) || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return (int)Combatify.CONFIG.getFoodImpl().execGetterFunc(original, "getMinimumFastHealingLevel()", new Object[0]);
        }
        return 1000000;
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="CONSTANT", args={"intValue=10"}, ordinal=0)})
    public int redirectTickTimer(int original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return (int)(Combatify.CONFIG.getFoodImpl().execGetterFunc((double)original / 20.0, "getFastHealSeconds()", new Object[0]) * 20.0);
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="CONSTANT", args={"intValue=80"}, ordinal=0)})
    public int redirectTickTimer1(int original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return (int)(Combatify.CONFIG.getFoodImpl().execGetterFunc((double)original / 20.0, "getHealSeconds()", new Object[0]) * 20.0);
    }

    @ModifyExpressionValue(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="CONSTANT", args={"intValue=80"}, ordinal=1)})
    public int redirectTickTimer2(int original, @Local(ordinal=0, argsOnly=true) Player player) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return (int)(Combatify.CONFIG.getFoodImpl().execGetterFunc((double)original / 20.0, "getStarvationSeconds()", new Object[0]) * 20.0);
    }

    @WrapOperation(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V", ordinal=0)})
    public void modifyFastHealing(Player instance, float health, Operation<Void> original, @Share(value="shouldContinueVanillaHeal") LocalBooleanRef cont) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance, Float.valueOf(health)});
            return;
        }
        cont.set(Combatify.CONFIG.getFoodImpl().execFunc("fastHeal(foodData, player)", new FoodDataWrapper(this.foodData), new PlayerWrapper<Player>(instance)));
        if (!cont.get()) {
            original.call(new Object[]{instance, Float.valueOf(health)});
        }
    }

    @WrapOperation(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V", ordinal=0)})
    public void modifyFastHealing(FoodData instance, float exhaustion, Operation<Void> original, @Share(value="shouldContinueVanillaHeal") LocalBooleanRef cont) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance, Float.valueOf(exhaustion)});
            return;
        }
        if (!cont.get()) {
            original.call(new Object[]{instance, Float.valueOf(exhaustion)});
        }
    }

    @WrapOperation(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V", ordinal=1)})
    public void modifyNaturalHealing(Player instance, float health, Operation<Void> original, @Share(value="shouldContinueVanillaHeal") LocalBooleanRef cont) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance, Float.valueOf(health)});
            return;
        }
        cont.set(Combatify.CONFIG.getFoodImpl().execFunc("heal(foodData, player)", new FoodDataWrapper(this.foodData), new PlayerWrapper<Player>(instance)));
        if (!cont.get()) {
            original.call(new Object[]{instance, Float.valueOf(health)});
        }
    }

    @WrapOperation(method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V", ordinal=1)})
    public void modifyNaturalHealing(FoodData instance, float exhaustion, Operation<Void> original, @Share(value="shouldContinueVanillaHeal") LocalBooleanRef cont) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance, Float.valueOf(exhaustion)});
            return;
        }
        if (!cont.get()) {
            original.call(new Object[]{instance, Float.valueOf(exhaustion)});
        }
    }
}

