/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.custom.CanSweep;
import net.atlas.combatify.config.ConfigurableEntityData;
import net.atlas.combatify.config.wrapper.EntityWrapper;
import net.atlas.combatify.config.wrapper.LivingEntityWrapper;
import net.atlas.combatify.config.wrapper.PlayerWrapper;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.SweepAttackEvent;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1400)
public abstract class PlayerMixin
extends LivingEntity
implements PlayerExtensions {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_USES_SHIELD_CROUCH = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Shadow
    @Final
    protected static EntityDataAccessor<Byte> DATA_PLAYER_MODE_CUSTOMISATION;
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    public boolean missedAttackRecovery;
    @Unique
    @Final
    public float baseValue = 1.0f;
    @Unique
    boolean attacked;
    @Unique
    public final Player player = (Player)this;

    public PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract void doAutoAttackOnTouch(@NotNull LivingEntity var1);

    @Shadow
    public abstract float getAttackStrengthScale(float var1);

    @Shadow
    public abstract float getCurrentItemAttackStrengthDelay();

    @Shadow
    public abstract void attack(Entity var1);

    @Shadow
    public abstract double entityInteractionRange();

    @Shadow
    protected abstract float getEnchantedDamage(Entity var1, float var2, DamageSource var3);

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Shadow
    public abstract boolean hasContainerOpen();

    @Shadow
    public abstract void tick();

    @Shadow
    public abstract void resetAttackStrengthTicker();

    @Shadow
    public abstract void playSound(SoundEvent var1, float var2, float var3);

    @Shadow
    protected abstract boolean wantsToStopRiding();

    @Shadow
    public abstract void travel(Vec3 var1);

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    public void appendShieldOnCrouch(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)true);
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")})
    public void injectSnowballKb(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef originalDamage) {
        originalDamage.set(amount);
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    public void changeReturn(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef originalDamage) {
        boolean bl;
        boolean bl2 = bl = amount == 0.0f && originalDamage.get() <= 0.0f;
        if (bl && Combatify.CONFIG.snowballKB().booleanValue()) {
            cir.setReturnValue((Object)super.hurt(source, amount));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        Objects.requireNonNull(this.player.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(Combatify.CONFIG.fistDamage().doubleValue());
        Objects.requireNonNull(this.player.getAttribute(Attributes.ATTACK_SPEED)).setBaseValue(Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
        Objects.requireNonNull(this.player.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)).setBaseValue(Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0);
    }

    @ModifyExpressionValue(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="CONSTANT", args={"doubleValue=1.0"})})
    private static double changeAttack(double constant) {
        return Combatify.CONFIG.fistDamage();
    }

    @ModifyReturnValue(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder createAttributes(AttributeSupplier.Builder original) {
        return original.add(Attributes.ENTITY_INTERACTION_RANGE, Combatify.CONFIG.attackReach() != false ? 2.5 : 3.0).add(Attributes.ATTACK_SPEED, Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    public void addServerOnlyCheck(ItemStack itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<ItemEntity> cir) {
        if (Combatify.unmoddedPlayers.contains(this.player.getUUID())) {
            Combatify.isPlayerAttacking.put(this.player.getUUID(), false);
        }
    }

    @ModifyExpressionValue(method={"hurtCurrentlyUsedShield(F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getUsedItemHand()Lnet/minecraft/world/InteractionHand;")})
    public InteractionHand useCurrentBlockingHand(InteractionHand original) {
        return MethodHandler.getBlockingItem((LivingEntity)this.player).useHand() != null ? MethodHandler.getBlockingItem((LivingEntity)this.player).useHand() : original;
    }

    @ModifyExpressionValue(method={"hurtCurrentlyUsedShield(F)V"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z"))}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;useItem:Lnet/minecraft/world/item/ItemStack;")})
    public ItemStack useCurrentBlockingItem(ItemStack instance) {
        return !MethodHandler.getBlockingItem((LivingEntity)this.player).stack().isEmpty() ? MethodHandler.getBlockingItem((LivingEntity)this.player).stack() : instance;
    }

    @WrapOperation(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V")})
    public void redirectDurability(Player instance, Operation<Void> original) {
        block3: {
            block2: {
                if (Combatify.CONFIG.resetOnItemChange().booleanValue()) break block2;
                if (!Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) break block3;
            }
            this.resetAttackStrengthTicker(false, true, xva$0 -> {
                Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0});
            });
        }
    }

    @Inject(method={"blockUsingShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canDisableShield()Z")}, cancellable=true)
    public void blockUsingShield(@NotNull LivingEntity attacker, CallbackInfo ci) {
        ci.cancel();
    }

    public boolean combatify$hasEnabledShieldOnCrouch() {
        return (Boolean)this.entityData.get(DATA_PLAYER_USES_SHIELD_CROUCH);
    }

    @Override
    public void combatify$setShieldOnCrouch(boolean hasShieldOnCrouch) {
        this.entityData.set(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)hasShieldOnCrouch);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(Entity target, CallbackInfo ci) {
        if (!this.combatify$isAttackAvailable(this.baseValue)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    public void resetTicker(Entity target, CallbackInfo ci) {
        if (this.attacked) {
            boolean isMiscTarget = false;
            ConfigurableEntityData configurableEntityData = MethodHandler.forEntity(target);
            if (configurableEntityData != null && configurableEntityData.isMiscEntity() != null) {
                isMiscTarget = configurableEntityData.isMiscEntity();
            }
            this.combatify$resetAttackStrengthTicker(Combatify.CONFIG.improvedMiscEntityAttacks() == false || !isMiscTarget);
        }
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V")})
    public void stopReset(Player instance, Operation<Void> original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public void doThings(Entity target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) float attackDamageBonus) {
        this.attacked = true;
        if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            attackDamage.set((float)(this.isAutoSpinAttack() ? MethodHandler.calculateValueFromBase(this.player.getAttribute(Attributes.ATTACK_DAMAGE), this.autoSpinAttackDmg + attackDamageBonus) : MethodHandler.calculateValue(this.player.getAttribute(Attributes.ATTACK_DAMAGE), attackDamageBonus)));
        }
    }

    @ModifyExpressionValue(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public float redirectStrengthCheck(float original) {
        original = (float)Mth.clamp((double)original, (double)Combatify.CONFIG.attackDecayMinCharge(), (double)Combatify.CONFIG.attackDecayMaxCharge());
        return (Combatify.CONFIG.attackDecay() == false || this.missedAttackRecovery && (float)this.attackStrengthTicker > 4.0f) && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 1.0f : original;
    }

    @Inject(method={"resetAttackStrengthTicker()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void reset(CallbackInfo ci) {
        int chargeTicks = (int)this.getCurrentItemAttackStrengthDelay() * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1);
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || chargeTicks > this.attackStrengthMaxValue - this.attackStrengthTicker) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")})
    public void injectCrit(Entity target, CallbackInfo ci, @Local(ordinal=0) float attackDamage, @Local(ordinal=1) float enchantDamage, @Local(ordinal=2) float strengthScale, @Local(ordinal=3) LocalFloatRef combinedDamage, @Local(ordinal=2) LocalBooleanRef bl3) {
        EntityWrapper wrapper;
        boolean strengthAppliesToEnchants;
        if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            float originalAttackDamage = Combatify.CONFIG.strengthAppliesToEnchants() != false ? (float)(this.isAutoSpinAttack() ? MethodHandler.calculateValueFromBase(this.player.getAttribute(Attributes.ATTACK_DAMAGE), this.autoSpinAttackDmg + enchantDamage) : MethodHandler.calculateValue(this.player.getAttribute(Attributes.ATTACK_DAMAGE), enchantDamage /= strengthScale)) : (this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            attackDamage -= (float)((0.2 + (double)(strengthScale * strengthScale) * 0.8) * (double)(originalAttackDamage *= bl3.get() ? 1.5f : 1.0f));
            float adjScale = (float)(((double)strengthScale - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff());
            combinedDamage.set((attackDamage += (originalAttackDamage *= (float)(Combatify.CONFIG.attackDecayMinPercentageBase() + (double)(adjScale * adjScale) * Combatify.CONFIG.attackDecayMaxPercentageBaseDiff()))) + (enchantDamage *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)strengthScale - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff())));
        }
        boolean bl = strengthAppliesToEnchants = Combatify.CONFIG.strengthAppliesToEnchants() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA);
        if (strengthAppliesToEnchants) {
            combinedDamage.set(attackDamage);
        }
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || !Combatify.CONFIG.getCritImpl().execFunc("overrideCrit()", new Object[0])) {
            return;
        }
        if (bl3.get()) {
            if (strengthAppliesToEnchants) {
                combinedDamage.set(combinedDamage.get() / 1.5f);
            } else {
                attackDamage /= 1.5f;
            }
        }
        if (target instanceof Player) {
            Player p = (Player)target;
            wrapper = new PlayerWrapper<Player>(p);
        } else if (target instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)target;
            wrapper = new LivingEntityWrapper<LivingEntity>(l);
        } else {
            wrapper = new EntityWrapper<Entity>(target);
        }
        final MutableFloat finalAttackDamage = new MutableFloat(attackDamage);
        bl3.set(Combatify.CONFIG.getCritImpl().execFunc("runCrit(player, target, combinedDamage)", new PlayerWrapper<Player>(this.player), wrapper, strengthAppliesToEnchants ? combinedDamage : new LocalFloatRef(){

            public float get() {
                return finalAttackDamage.getValue().floatValue();
            }

            public void set(float v) {
                finalAttackDamage.setValue(v);
            }
        }));
        if (!strengthAppliesToEnchants) {
            combinedDamage.set(finalAttackDamage.getValue().floatValue() + enchantDamage);
        }
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void knockback(LivingEntity instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0) DamageSource damageSource) {
        Combatify.CONFIG.knockbackMode().runKnockback(instance, damageSource, d, e, f, (xva$0, xva$1, xva$2, xva$3) -> {
            Void cfr_ignored_0 = (Void)original.call(new Object[]{xva$0, xva$1, xva$2, xva$3});
        });
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/common/CommonHooks;fireSweepAttack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Z)Lnet/neoforged/neoforge/event/entity/player/SweepAttackEvent;")})
    public SweepAttackEvent createSweep(Player player, Entity target, boolean isVanillaSweep, Operation<SweepAttackEvent> original, @Local(ordinal=1) boolean bl2, @Local(ordinal=2) boolean bl3, @Local(ordinal=3) LocalBooleanRef bl4, @Local(ordinal=0) float attackDamage) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return (SweepAttackEvent)original.call(new Object[]{player, target, isVanillaSweep});
        }
        double d = this.getKnownMovement().horizontalDistanceSqr();
        double e = (double)this.getSpeed() * 2.5;
        boolean isSweepPossible = Combatify.CONFIG.sweepConditionsMatchMiss() != false || this.onGround();
        SweepAttackEvent event = (SweepAttackEvent)original.call(new Object[]{player, target, !bl3 && !bl2 && isSweepPossible && d < Mth.square((double)e) && this.checkSweepAttack()});
        boolean realSweep = event.isSweeping();
        if (realSweep) {
            AABB box = target.getBoundingBox().inflate(1.0, 0.25, 1.0);
            MethodHandler.sweepAttack(player, box, (float)MethodHandler.getCurrentAttackReach(player, 1.0f), attackDamage, (TriFunction<LivingEntity, Float, DamageSource, Float>)((TriFunction)(livingEntity, damage, damageSource) -> {
                float attackDamageBonus = this.getEnchantedDamage((Entity)livingEntity, damage.floatValue(), (DamageSource)damageSource) - damage.floatValue();
                if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    attackDamageBonus = (float)MethodHandler.calculateValueFromBase(player.getAttribute(Attributes.ATTACK_DAMAGE), attackDamageBonus);
                }
                if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    attackDamageBonus *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)this.getAttackStrengthScale(0.5f) - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff());
                }
                return Float.valueOf(damage.floatValue() + attackDamageBonus);
            }), target);
        }
        return event;
    }

    @ModifyExpressionValue(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="flag2", local={@Local(type=boolean.class, ordinal=3)})
    @Expression(value={"flag2 != false"})
    public boolean resweep(boolean original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return false;
    }

    @Override
    public void combatify$attackAir() {
        if (this.combatify$isAttackAvailable(this.baseValue)) {
            this.combatify$customSwing(InteractionHand.MAIN_HAND);
            float attackDamage = (float)this.player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            if (attackDamage > 0.0f && this.checkSweepAttack() && Combatify.CONFIG.canSweepOnMiss().booleanValue()) {
                float currentAttackReach = (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f);
                double dirX = (double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))) * 2.0;
                double dirZ = (double)Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 2.0;
                AABB sweepBox = this.player.getBoundingBox().inflate(1.0, 0.25, 1.0).move(dirX, 0.0, dirZ);
                if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                    Combatify.LOGGER.info("Swept");
                }
                MethodHandler.sweepAttack(this.player, sweepBox, currentAttackReach, attackDamage, (TriFunction<LivingEntity, Float, DamageSource, Float>)((TriFunction)(livingEntity, damage, damageSource) -> {
                    float attackDamageBonus = this.getEnchantedDamage((Entity)livingEntity, damage.floatValue(), (DamageSource)damageSource) - damage.floatValue();
                    if (Combatify.CONFIG.strengthAppliesToEnchants().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                        attackDamageBonus = (float)MethodHandler.calculateValueFromBase(this.player.getAttribute(Attributes.ATTACK_DAMAGE), attackDamageBonus);
                    }
                    if (Combatify.CONFIG.attackDecay().booleanValue() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                        attackDamageBonus *= (float)(Combatify.CONFIG.attackDecayMinPercentageEnchants() + ((double)this.getAttackStrengthScale(0.5f) - Combatify.CONFIG.attackDecayMinCharge()) / Combatify.CONFIG.attackDecayMaxChargeDiff() * Combatify.CONFIG.attackDecayMaxPercentageEnchantsDiff());
                    }
                    return Float.valueOf(damage.floatValue() + attackDamageBonus);
                }), null);
            }
            this.combatify$resetAttackStrengthTicker(false);
        }
    }

    @Override
    public void combatify$customSwing(InteractionHand interactionHand) {
        this.swing(interactionHand, false);
    }

    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(hit, false, Player::resetAttackStrengthTicker);
    }

    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(hit, force, Player::resetAttackStrengthTicker);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean hit, boolean force, Consumer<Player> vanillaReset) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            vanillaReset.accept(this.player);
            return;
        }
        boolean bl = this.missedAttackRecovery = !hit && Combatify.CONFIG.missedAttackRecovery() != false;
        if (Combatify.CONFIG.attackSpeed() == false && this.getAttributeValue(Attributes.ATTACK_SPEED) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack().booleanValue()) {
            return;
        }
        int chargeTicks = (int)this.getCurrentItemAttackStrengthDelay() * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1);
        if (force || chargeTicks > this.attackStrengthMaxValue - this.attackStrengthTicker) {
            if (Combatify.CONFIG.enableDebugLogging().booleanValue()) {
                Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            }
            this.attackStrengthMaxValue = chargeTicks;
            this.attackStrengthTicker = 0;
        }
    }

    @ModifyExpressionValue(method={"getCurrentItemAttackStrengthDelay()F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D")})
    public double modifyAttackSpeed(double original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        hasVanilla.set((this.getAttribute(Attributes.ATTACK_SPEED).getModifier(Item.BASE_ATTACK_SPEED_ID) != null || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C));
        double mod = Combatify.CONFIG.hasteFix() == false ? 1.5 : MethodHandler.calculateValueFromBase(this.getAttribute(Attributes.ATTACK_SPEED), 1.5);
        double speed = original - mod;
        if (hasVanilla.get() || speed <= 0.0) {
            speed += mod;
        }
        return Mth.clamp((double)speed, (double)0.1, (double)1024.0);
    }

    @ModifyReturnValue(method={"getCurrentItemAttackStrengthDelay()F"}, at={@At(value="RETURN")})
    public float modifyAttackTicks(float original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        return hasVanilla.get() ? original : (float)Math.round(original);
    }

    @ModifyExpressionValue(method={"getAttackStrengthScale(F)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getCurrentItemAttackStrengthDelay()F")})
    public float modifyMaxCharge(float original) {
        return Combatify.CONFIG.resetOnItemChange() != false || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? (float)((int)original * (Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2 : 1)) : (float)this.attackStrengthMaxValue;
    }

    @ModifyReturnValue(method={"getAttackStrengthScale(F)F"}, at={@At(value="RETURN")})
    public float modifyAttackStrengthScale(float original) {
        float charge;
        float f = charge = Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f;
        if (this.attackStrengthMaxValue == 0) {
            return charge;
        }
        return charge * original;
    }

    public boolean combatify$isAttackAvailable(float baseTime) {
        if (this.getAttackStrengthScale(baseTime) < 1.0f && !Combatify.CONFIG.canAttackEarly().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return this.missedAttackRecovery && (float)this.attackStrengthTicker + baseTime > 4.0f;
        }
        return true;
    }

    @Unique
    protected boolean checkSweepAttack() {
        boolean sweep;
        float charge = Combatify.CONFIG.chargedAttacks() != false ? 1.95f : 0.9f;
        boolean sweepingItem = ((CanSweep)this.getMainHandItem().getOrDefault(CustomDataComponents.CAN_SWEEP, (Object)CanSweep.DISABLED)).enabled();
        boolean bl = sweep = this.getAttackStrengthScale(this.baseValue) > charge && (this.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) > 0.0 || sweepingItem);
        if (!Combatify.CONFIG.sweepWithSweeping().booleanValue()) {
            return sweepingItem && sweep;
        }
        return sweep;
    }

    @Override
    public boolean combatify$getMissedAttackRecovery() {
        return this.missedAttackRecovery;
    }

    @ModifyReturnValue(method={"entityInteractionRange()D"}, at={@At(value="RETURN")})
    public double getCurrentAttackReach(double original) {
        return MethodHandler.getCurrentAttackReach(this.player, 0.0f);
    }
}

