/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.util.CombatUtil;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleInteract(Lnet/minecraft/network/protocol/game/ServerboundInteractPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectPlayer(ServerboundInteractPacket packet, CallbackInfo ci) {
        if (!this.player.combatify$isAttackAvailable(1.0f)) {
            ci.cancel();
        }
        if (Combatify.unmoddedPlayers.contains(this.player.getUUID())) {
            if (this.player.combatify$isRetainingAttack()) {
                this.player.level().playSound(null, this.player.getX(), this.player.getY(), this.player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.player.getSoundSource(), 1.0f, 1.0f);
                ci.cancel();
                return;
            }
            if (!this.player.combatify$isAttackAvailable(0.0f)) {
                float var1 = this.player.getAttackStrengthScale(0.0f);
                if (var1 < 0.8f) {
                    this.player.level().playSound(null, this.player.getX(), this.player.getY(), this.player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.player.getSoundSource(), 1.0f, 1.0f);
                    this.player.combatify$resetAttackStrengthTicker(!this.player.combatify$getMissedAttackRecovery());
                    ci.cancel();
                }
                if (var1 < 1.0f) {
                    this.player.combatify$setRetainAttack(true);
                    ci.cancel();
                }
            }
        }
    }

    @WrapOperation(method={"handleInteract(Lnet/minecraft/network/protocol/game/ServerboundInteractPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;canInteractWithEntity(Lnet/minecraft/world/phys/AABB;D)Z")})
    public boolean redirectCheck(ServerPlayer instance, AABB aabb, double v, Operation<Boolean> original, @Local(ordinal=0) Entity entity) {
        boolean result;
        if (entity instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)entity;
            result = CombatUtil.allowReach(this.player, target);
        } else {
            result = (Boolean)original.call(new Object[]{instance, aabb, v});
        }
        if (Combatify.unmoddedPlayers.contains(this.player.getUUID()) && !result) {
            this.player.combatify$attackAir();
        }
        return result;
    }
}

