/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.CombatifyClient;
import net.atlas.combatify.config.DualAttackIndicatorStatus;
import net.atlas.combatify.config.ShieldIndicatorStatus;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_LEFT_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_left_indicator_background");
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_LEFT_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_left_indicator_progress");
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_RIGHT_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_right_indicator_background");
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_RIGHT_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_right_indicator_progress");
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_SIDE_FULL_PICK_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_side_indicator_full_pick");
    @Unique
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_SIDE_CHARGED_PICK_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_side_indicator_charged_pick");
    @Unique
    private static final ResourceLocation CROSSHAIR_SHIELD_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_shield_indicator_full");
    @Unique
    private static final ResourceLocation CROSSHAIR_SHIELD_INDICATOR_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_shield_indicator_disabled");
    @Unique
    private static final ResourceLocation CROSSHAIR_SPECIAL_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_special_indicator_full");
    @Unique
    private static final ResourceLocation HOTBAR_SPECIAL_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_special_indicator_full");
    @Unique
    private static final ResourceLocation HOTBAR_ATTACK_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_attack_indicator_full");
    @Unique
    private static final ResourceLocation HOTBAR_SHIELD_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_shield_indicator_full");
    @Unique
    private static final ResourceLocation HOTBAR_SHIELD_INDICATOR_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/hotbar_shield_indicator_disabled");
    @Final
    @Shadow
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE;
    @Final
    @Shadow
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
    @Final
    @Shadow
    private static ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE;
    @Final
    @Shadow
    private static ResourceLocation HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE;
    @Final
    @Shadow
    private static ResourceLocation HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private DebugScreenOverlay debugOverlay;

    @Shadow
    protected abstract boolean canRenderCrosshairForSpectator(HitResult var1);

    @Inject(method={"renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")})
    private void renderCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Options options = this.minecraft.options;
        if (options.getCameraType().isFirstPerson()) {
            assert (this.minecraft.gameMode != null);
            assert (this.minecraft.player != null);
            if (this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR || this.canRenderCrosshairForSpectator(this.minecraft.hitResult)) {
                boolean bl;
                boolean bl2 = bl = this.debugOverlay.showDebugScreen() && !this.minecraft.player.isReducedDebugInfo() && (Boolean)options.reducedDebugInfo().get() == false;
                if (!bl) {
                    boolean shieldIndicatorEnabled;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    int yPos = guiGraphics.guiHeight() / 2 - 7 + 16;
                    int xPos = guiGraphics.guiWidth() / 2 - 8;
                    boolean isShieldCooldown = this.isShieldOnCooldown();
                    boolean bl3 = shieldIndicatorEnabled = CombatifyClient.shieldIndicator.get() == ShieldIndicatorStatus.CROSSHAIR && this.shieldNonDelayed();
                    if (shieldIndicatorEnabled && isShieldCooldown) {
                        guiGraphics.blitSprite(CROSSHAIR_SHIELD_INDICATOR_DISABLED_SPRITE, xPos, yPos, 16, 16);
                    } else if (shieldIndicatorEnabled && this.minecraft.player.isBlocking()) {
                        guiGraphics.blitSprite(CROSSHAIR_SHIELD_INDICATOR_FULL_SPRITE, xPos, yPos, 16, 16);
                    }
                    MutableInt mutableYPos = new MutableInt(yPos);
                    if (!((AttackIndicatorStatus)options.attackIndicator().get()).equals((Object)AttackIndicatorStatus.CROSSHAIR) && ((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.CROSSHAIR)) {
                        this.renderProjectileChargeOnCrosshair(guiGraphics, (Player)this.minecraft.player, xPos, mutableYPos);
                    }
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    @Inject(method={"renderCrosshair(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F")}, cancellable=true)
    public void renderCrosshair1(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        boolean shieldIndicatorEnabled;
        boolean isShieldCooldown = this.isShieldOnCooldown();
        boolean bl = shieldIndicatorEnabled = CombatifyClient.shieldIndicator.get() == ShieldIndicatorStatus.CROSSHAIR && this.shieldNonDelayed();
        assert (this.minecraft.player != null);
        if (shieldIndicatorEnabled && isShieldCooldown) {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        if (shieldIndicatorEnabled && this.minecraft.player.isBlocking()) {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        int yPos = guiGraphics.guiHeight() / 2 - 7 + 16;
        int xPos = guiGraphics.guiWidth() / 2 - 8;
        MutableInt mutableYPos = new MutableInt(yPos);
        float attackStrengthScale = this.minecraft.player.getAttackStrengthScale(0.0f);
        if (((DualAttackIndicatorStatus)((Object)CombatifyClient.dualAttackIndicator.get())).isOn() && Combatify.CONFIG.chargedAttacks().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            boolean shouldPick = false;
            EntityHitResult hitResult = this.minecraft.hitResult instanceof EntityHitResult ? (EntityHitResult)this.minecraft.hitResult : null;
            Entity entity = this.minecraft.crosshairPickEntity = hitResult != null ? hitResult.getEntity() : this.minecraft.crosshairPickEntity;
            if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && (((DualAttackIndicatorStatus)((Object)CombatifyClient.dualAttackIndicator.get())).equals((Object)DualAttackIndicatorStatus.SIDE) ? this.minecraft.player.combatify$isAttackAvailable(0.0f) : (double)attackStrengthScale >= 1.0)) {
                shouldPick = this.minecraft.player.getEyePosition().distanceTo(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), this.minecraft.player.getEyePosition())) <= MethodHandler.getCurrentAttackReach((Player)this.minecraft.player, 0.0f);
                shouldPick &= this.minecraft.crosshairPickEntity.isAlive();
            }
            if (CombatifyClient.dualAttackIndicator.get() == DualAttackIndicatorStatus.BOTTOM) {
                if (attackStrengthScale < 2.0f) {
                    if (shouldPick) {
                        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, mutableYPos.getAndAdd(8), 16, 16);
                    } else {
                        this.renderCrosshairProgress(guiGraphics, xPos, mutableYPos.getAndAdd(8), attackStrengthScale);
                    }
                    this.renderCrosshairProgress(guiGraphics, xPos, mutableYPos.getAndAdd(8), (attackStrengthScale - 1.3f) / 0.70000005f);
                } else if (shouldPick) {
                    double reachLimited = MethodHandler.getCurrentAttackReachWithoutChargedReach((Player)this.minecraft.player);
                    if (this.minecraft.player.getEyePosition().distanceToSqr(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), this.minecraft.player.getEyePosition())) < reachLimited * reachLimited) {
                        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, mutableYPos.getAndAdd(8), 16, 16);
                    } else {
                        this.renderCrosshairProgress(guiGraphics, xPos, mutableYPos.getAndAdd(8), 1.0f);
                    }
                    guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, mutableYPos.getAndAdd(8), 16, 16);
                } else if (((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.CROSSHAIR)) {
                    this.renderProjectileChargeOnCrosshair(guiGraphics, (Player)this.minecraft.player, xPos, mutableYPos);
                }
            } else {
                HumanoidArm humanoidArm = this.minecraft.player.getMainArm();
                yPos = (guiGraphics.guiHeight() - 11) / 2;
                int crosshairYPos = (guiGraphics.guiHeight() - 15) / 2;
                int crosshairXPos = (guiGraphics.guiWidth() - 15) / 2;
                xPos = crosshairXPos - 2;
                int sideXPos = crosshairXPos + 13;
                if (attackStrengthScale < 2.0f) {
                    float chargeRatio = (attackStrengthScale - 1.3f) / 0.70000005f;
                    if (shouldPick) {
                        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_SIDE_FULL_PICK_SPRITE, crosshairXPos, crosshairYPos, 15, 15);
                    }
                    this.renderSideCrosshairProgress(guiGraphics, humanoidArm, xPos, yPos, attackStrengthScale, chargeRatio, true);
                    this.renderSideCrosshairProgress(guiGraphics, humanoidArm, sideXPos, yPos, attackStrengthScale, chargeRatio, false);
                } else if (shouldPick) {
                    double reachLimited = MethodHandler.getCurrentAttackReachWithoutChargedReach((Player)this.minecraft.player);
                    if (this.minecraft.player.getEyePosition().distanceToSqr(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), this.minecraft.player.getEyePosition())) < reachLimited * reachLimited) {
                        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_SIDE_FULL_PICK_SPRITE, crosshairXPos, crosshairYPos, 15, 15);
                    } else {
                        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_SIDE_CHARGED_PICK_SPRITE, crosshairXPos, crosshairYPos, 15, 15);
                    }
                    this.renderSideCrosshairProgress(guiGraphics, humanoidArm, xPos, yPos, 1.0f, 1.0f, true);
                    this.renderSideCrosshairProgress(guiGraphics, humanoidArm, sideXPos, yPos, 1.0f, 1.0f, false);
                }
                xPos = guiGraphics.guiWidth() / 2 - 8;
                if (((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.CROSSHAIR)) {
                    this.renderProjectileChargeOnCrosshair(guiGraphics, (Player)this.minecraft.player, xPos, mutableYPos);
                }
            }
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        float maxIndicator = Math.min(((Double)CombatifyClient.attackIndicatorMaxValue.get()).floatValue(), Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f);
        float minIndicator = Math.min(((Double)CombatifyClient.attackIndicatorMinValue.get()).floatValue(), Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f);
        if (minIndicator == maxIndicator) {
            minIndicator = 0.0f;
        }
        boolean shouldPick = false;
        EntityHitResult hitResult = this.minecraft.hitResult instanceof EntityHitResult ? (EntityHitResult)this.minecraft.hitResult : null;
        Entity entity = this.minecraft.crosshairPickEntity = hitResult != null ? hitResult.getEntity() : this.minecraft.crosshairPickEntity;
        if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && attackStrengthScale >= maxIndicator) {
            shouldPick = this.minecraft.player.getEyePosition().distanceTo(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), this.minecraft.player.getEyePosition())) <= MethodHandler.getCurrentAttackReach((Player)this.minecraft.player, 0.0f);
            shouldPick &= this.minecraft.crosshairPickEntity.isAlive();
        }
        if (shouldPick) {
            guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, mutableYPos.getAndAdd(8), 16, 16);
        } else if (attackStrengthScale > minIndicator && attackStrengthScale < maxIndicator) {
            this.renderCrosshairProgress(guiGraphics, xPos, mutableYPos.getAndAdd(8), (attackStrengthScale - minIndicator) / (maxIndicator - minIndicator + 5.0E-8f));
        } else if (((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.CROSSHAIR)) {
            this.renderProjectileChargeOnCrosshair(guiGraphics, (Player)this.minecraft.player, xPos, mutableYPos);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        ci.cancel();
    }

    @Inject(method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getAttackStrengthScale(F)F")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void renderHotbar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci, Player player, ItemStack itemStack, HumanoidArm humanoidArm, int i) {
        boolean shieldIndicatorEnabled;
        boolean isShieldCooldown = this.isShieldOnCooldown();
        boolean bl = shieldIndicatorEnabled = CombatifyClient.shieldIndicator.get() == ShieldIndicatorStatus.HOTBAR && this.shieldNonDelayed();
        assert (this.minecraft.player != null);
        if (shieldIndicatorEnabled && isShieldCooldown) {
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        if (shieldIndicatorEnabled && this.minecraft.player.isBlocking()) {
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        int yPos = guiGraphics.guiHeight() - 20;
        int xPos = i + 91 + 6;
        if (humanoidArm == HumanoidArm.RIGHT) {
            xPos = i - 91 - 22;
        }
        MutableInt mutableXPos = new MutableInt(xPos);
        int offset = humanoidArm == HumanoidArm.RIGHT ? -20 : 20;
        float attackStrengthScale = this.minecraft.player.getAttackStrengthScale(0.0f);
        if (((DualAttackIndicatorStatus)((Object)CombatifyClient.dualAttackIndicator.get())).isOn() && Combatify.CONFIG.chargedAttacks().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            boolean shouldPick = false;
            EntityHitResult hitResult = this.minecraft.hitResult instanceof EntityHitResult ? (EntityHitResult)this.minecraft.hitResult : null;
            Entity entity = this.minecraft.crosshairPickEntity = hitResult != null ? hitResult.getEntity() : this.minecraft.crosshairPickEntity;
            if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && (double)attackStrengthScale >= 1.0) {
                shouldPick = player.getEyePosition().distanceTo(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), player.getEyePosition())) <= MethodHandler.getCurrentAttackReach(player, 0.0f);
                shouldPick &= this.minecraft.crosshairPickEntity.isAlive();
            }
            if (attackStrengthScale < 2.0f) {
                if (shouldPick) {
                    guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, mutableXPos.getAndAdd(offset), yPos, 18, 18);
                } else {
                    this.renderHotbarProgress(guiGraphics, mutableXPos.getAndAdd(offset), yPos, attackStrengthScale);
                }
                this.renderHotbarProgress(guiGraphics, mutableXPos.getAndAdd(offset), yPos, (attackStrengthScale - 1.3f) / 0.70000005f);
            } else if (shouldPick) {
                double reachLimited = MethodHandler.getCurrentAttackReachWithoutChargedReach(player);
                if (player.getEyePosition().distanceToSqr(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), player.getEyePosition())) <= reachLimited * reachLimited) {
                    guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, mutableXPos.getAndAdd(offset), yPos, 18, 18);
                } else {
                    this.renderHotbarProgress(guiGraphics, mutableXPos.getAndAdd(offset), yPos, 1.0f);
                }
                guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, mutableXPos.getAndAdd(offset), yPos, 18, 18);
            } else if (((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.HOTBAR)) {
                this.renderProjectileChargeOnHotbar(guiGraphics, player, mutableXPos, yPos, humanoidArm == HumanoidArm.RIGHT);
            }
            RenderSystem.disableBlend();
            ci.cancel();
            return;
        }
        float maxIndicator = Math.min(((Double)CombatifyClient.attackIndicatorMaxValue.get()).floatValue(), Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f);
        float minIndicator = Math.min(((Double)CombatifyClient.attackIndicatorMinValue.get()).floatValue(), Combatify.CONFIG.chargedAttacks() != false && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? 2.0f : 1.0f);
        if (minIndicator == maxIndicator) {
            minIndicator = 0.0f;
        }
        boolean shouldPick = false;
        EntityHitResult hitResult = this.minecraft.hitResult instanceof EntityHitResult ? (EntityHitResult)this.minecraft.hitResult : null;
        Entity entity = this.minecraft.crosshairPickEntity = hitResult != null ? hitResult.getEntity() : this.minecraft.crosshairPickEntity;
        if (this.minecraft.crosshairPickEntity != null && this.minecraft.crosshairPickEntity instanceof LivingEntity && attackStrengthScale >= maxIndicator) {
            shouldPick = player.getEyePosition().distanceTo(MethodHandler.getNearestPointTo(this.minecraft.crosshairPickEntity.getBoundingBox(), player.getEyePosition())) <= MethodHandler.getCurrentAttackReach(player, 0.0f);
            shouldPick &= this.minecraft.crosshairPickEntity.isAlive();
        }
        if (shouldPick) {
            guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, mutableXPos.getAndAdd(offset), yPos, 18, 18);
        } else if (attackStrengthScale > minIndicator && attackStrengthScale < maxIndicator) {
            this.renderHotbarProgress(guiGraphics, mutableXPos.getAndAdd(offset), yPos, (attackStrengthScale - minIndicator) / (maxIndicator - minIndicator + 5.0E-8f));
        } else if (((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.HOTBAR)) {
            this.renderProjectileChargeOnHotbar(guiGraphics, player, mutableXPos, yPos, humanoidArm == HumanoidArm.RIGHT);
        }
        RenderSystem.disableBlend();
        ci.cancel();
    }

    @Inject(method={"renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void renderHotbar1(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci, Player player, ItemStack itemStack, HumanoidArm humanoidArm, int i) {
        RenderSystem.enableBlend();
        int yPos = guiGraphics.guiHeight() - 20;
        int xPos = i + 91 + 6;
        assert (this.minecraft.player != null);
        if (humanoidArm == HumanoidArm.RIGHT) {
            xPos = i - 91 - 22;
        }
        boolean shieldIndicatorEnabled = CombatifyClient.shieldIndicator.get() == ShieldIndicatorStatus.HOTBAR && this.shieldNonDelayed();
        boolean isShieldCooldown = this.isShieldOnCooldown();
        if (shieldIndicatorEnabled && isShieldCooldown) {
            guiGraphics.blitSprite(HOTBAR_SHIELD_INDICATOR_DISABLED_SPRITE, xPos, yPos, 18, 18);
        } else if (shieldIndicatorEnabled && this.minecraft.player.isBlocking()) {
            guiGraphics.blitSprite(HOTBAR_SHIELD_INDICATOR_FULL_SPRITE, xPos, yPos, 18, 18);
        }
        MutableInt mutableXPos = new MutableInt(xPos);
        if (!((AttackIndicatorStatus)this.minecraft.options.attackIndicator().get()).equals((Object)AttackIndicatorStatus.HOTBAR) && ((AttackIndicatorStatus)CombatifyClient.projectileChargeIndicator.get()).equals((Object)AttackIndicatorStatus.HOTBAR)) {
            this.renderProjectileChargeOnHotbar(guiGraphics, player, mutableXPos, yPos, humanoidArm == HumanoidArm.RIGHT);
        }
        RenderSystem.disableBlend();
    }

    @Unique
    private void renderProjectileChargeOnHotbar(GuiGraphics guiGraphics, Player player, MutableInt mutableXPos, int yPos, boolean right) {
        ItemStack useItem = player.getUseItem();
        int time = useItem.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks();
        Item item = useItem.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BowItem.class, CrossbowItem.class, TridentItem.class}, (Object)item2, n)) {
            case 0: {
                BowItem ignored = (BowItem)item2;
                float power = BowItem.getPowerForTime((int)time);
                int xPos = mutableXPos.getAndAdd(right ? -20 : 20);
                if (power < 1.0f) {
                    this.renderHotbarProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                if (!(MethodHandler.getFatigueForTime(time) <= 0.5f)) break;
                if (Combatify.CONFIG.bowFatigue().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    float fatigueProgress = 1.0f - (float)(time - 20) / 40.0f;
                    this.renderHotbarProgress(guiGraphics, xPos, yPos, fatigueProgress);
                    int indicatorXPos = xPos + 1;
                    int indicatorYPos = yPos + 1;
                    guiGraphics.blitSprite(HOTBAR_SPECIAL_INDICATOR_FULL_SPRITE, indicatorXPos, indicatorYPos, 5, 5);
                    break;
                }
                guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 18, 18);
                break;
            }
            case 1: {
                CrossbowItem ignored = (CrossbowItem)item2;
                float power = (float)time / (float)CrossbowItem.getChargeDuration((ItemStack)useItem, (LivingEntity)player);
                int xPos = mutableXPos.getAndAdd(right ? -20 : 20);
                if (power < 1.0f) {
                    this.renderHotbarProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 18, 18);
                break;
            }
            case 2: {
                TridentItem ignored = (TridentItem)item2;
                float power = (float)time / 10.0f;
                int xPos = mutableXPos.getAndAdd(right ? -20 : 20);
                if (power < 1.0f) {
                    this.renderHotbarProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 18, 18);
                break;
            }
        }
    }

    @Unique
    private void renderProjectileChargeOnCrosshair(GuiGraphics guiGraphics, Player player, int xPos, MutableInt mutableYPos) {
        ItemStack useItem = player.getUseItem();
        int time = useItem.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks();
        Item item = useItem.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BowItem.class, CrossbowItem.class, TridentItem.class}, (Object)item2, n)) {
            case 0: {
                BowItem ignored = (BowItem)item2;
                float power = BowItem.getPowerForTime((int)time);
                int yPos = mutableYPos.getAndAdd(8);
                if (power < 1.0f) {
                    this.renderCrosshairProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                if (!(MethodHandler.getFatigueForTime(time) <= 0.5f)) break;
                if (Combatify.CONFIG.bowFatigue().booleanValue() && !Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
                    float fatigueProgress = 1.0f - (float)(time - 20) / 40.0f;
                    this.renderCrosshairProgress(guiGraphics, xPos, yPos, fatigueProgress);
                    int indicatorXPos = guiGraphics.guiWidth() / 2 - 1;
                    int indicatorYPos = yPos + 4;
                    guiGraphics.blitSprite(CROSSHAIR_SPECIAL_INDICATOR_FULL_SPRITE, indicatorXPos, indicatorYPos, 3, 3);
                    break;
                }
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 16, 16);
                break;
            }
            case 1: {
                CrossbowItem ignored = (CrossbowItem)item2;
                float power = (float)time / (float)CrossbowItem.getChargeDuration((ItemStack)useItem, (LivingEntity)player);
                int yPos = mutableYPos.getAndAdd(8);
                if (power < 1.0f) {
                    this.renderCrosshairProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 16, 16);
                break;
            }
            case 2: {
                TridentItem ignored = (TridentItem)item2;
                float power = (float)time / 10.0f;
                int yPos = mutableYPos.getAndAdd(8);
                if (power < 1.0f) {
                    this.renderCrosshairProgress(guiGraphics, xPos, yPos, power);
                    break;
                }
                guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, xPos, yPos, 16, 16);
                break;
            }
        }
    }

    @Unique
    private void renderSideCrosshairProgress(GuiGraphics guiGraphics, HumanoidArm humanoidArm, int xPos, int yPos, float fastRatio, float chargeRatio, boolean left) {
        float ratio = humanoidArm == (left ? HumanoidArm.RIGHT : HumanoidArm.LEFT) ? fastRatio : chargeRatio;
        int height = (int)Mth.clamp((float)(ratio * 12.0f), (float)0.0f, (float)11.0f);
        guiGraphics.blitSprite(left ? CROSSHAIR_ATTACK_INDICATOR_LEFT_BACKGROUND_SPRITE : CROSSHAIR_ATTACK_INDICATOR_RIGHT_BACKGROUND_SPRITE, xPos, yPos, 4, 11);
        guiGraphics.blitSprite(left ? CROSSHAIR_ATTACK_INDICATOR_LEFT_PROGRESS_SPRITE : CROSSHAIR_ATTACK_INDICATOR_RIGHT_PROGRESS_SPRITE, 4, 11, 0, 11 - height, xPos, yPos + 11 - height, 4, height);
    }

    @Unique
    private void renderCrosshairProgress(GuiGraphics guiGraphics, int xPos, int yPos, float ratio) {
        int height = (int)Mth.clamp((float)(ratio * 17.0f), (float)0.0f, (float)16.0f);
        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, xPos, yPos, 16, 4);
        guiGraphics.blitSprite(CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, xPos, yPos, height, 4);
    }

    @Unique
    private void renderHotbarProgress(GuiGraphics guiGraphics, int xPos, int yPos, float ratio) {
        int height = (int)Mth.clamp((float)(ratio * 19.0f), (float)0.0f, (float)18.0f);
        guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_BACKGROUND_SPRITE, xPos, yPos, 18, 18);
        guiGraphics.blitSprite(HOTBAR_ATTACK_INDICATOR_PROGRESS_SPRITE, 18, 18, 0, 18 - height, xPos, yPos + 18 - height, 18, height);
    }

    @Unique
    public boolean isShieldOnCooldown() {
        assert (this.minecraft.player != null);
        ItemStack offHandStack = this.minecraft.player.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack mainHandStack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean offHandShieldCooldown = this.minecraft.player.getCooldowns().isOnCooldown(offHandStack.getItem()) && !MethodHandler.getBlockingType(offHandStack).isEmpty();
        boolean mainHandShieldCooldown = this.minecraft.player.getCooldowns().isOnCooldown(mainHandStack.getItem()) && !MethodHandler.getBlockingType(mainHandStack).isEmpty();
        return offHandShieldCooldown || mainHandShieldCooldown;
    }

    @Unique
    public boolean shieldNonDelayed() {
        if (this.minecraft.player == null) {
            return true;
        }
        ItemStack itemStack = MethodHandler.getBlockingItem((LivingEntity)this.minecraft.player).stack();
        return !MethodHandler.getBlockingType(itemStack).hasDelay() || Combatify.CONFIG.shieldDelay() <= 0 || itemStack.getUseDuration((LivingEntity)this.minecraft.player) - this.minecraft.player.getUseItemRemainingTicks() >= Combatify.CONFIG.shieldDelay();
    }
}

