/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.authlib.GameProfile;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.CombatifyClient;
import net.atlas.combatify.config.wrapper.PlayerWrapper;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer
implements PlayerExtensions {
    @Unique
    boolean wasShieldBlocking = false;
    @Unique
    InteractionHand shieldBlockingHand = InteractionHand.OFF_HAND;
    @Shadow
    @Final
    public ClientPacketListener connection;
    @Unique
    @Final
    public Minecraft minecraft = Minecraft.getInstance();
    @Unique
    LocalPlayer thisPlayer = (LocalPlayer)this;

    public LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Shadow
    public abstract void startUsingItem(@NotNull InteractionHand var1);

    @Shadow
    public abstract boolean isUsingItem();

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    @Environment(value=EnvType.CLIENT)
    public void injectSneakShield(CallbackInfo ci) {
        boolean isBlocking;
        if (this.level().hasChunkAt(this.getBlockX(), this.getBlockZ()) && (isBlocking = this.isBlocking()) != this.wasShieldBlocking) {
            this.wasShieldBlocking = isBlocking;
            if (isBlocking) {
                this.shieldBlockingHand = MethodHandler.getBlockingItem((LivingEntity)this.thisPlayer).useHand();
            }
            if (isBlocking && !this.isUsingItem()) {
                this.minecraft.gameRenderer.itemInHandRenderer.itemUsed(this.shieldBlockingHand);
            }
        }
    }

    @Override
    public void combatify$customSwing(InteractionHand interactionHand) {
        this.swing(interactionHand, false);
        this.connection.send((Packet)new ServerboundSwingPacket(interactionHand));
    }

    @ModifyExpressionValue(method={"hasEnoughFoodToStartSprinting()Z"}, at={@At(value="CONSTANT", args={"floatValue=6.0F"})})
    public float modifyFoodRequirement(float original) {
        return Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) ? original : (float)Combatify.CONFIG.getFoodImpl().execGetterFunc(original, "getMinimumSprintLevel(player)", new PlayerWrapper<LocalPlayer>(this.thisPlayer));
    }

    @Redirect(method={"hurtTo(F)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/player/LocalPlayer;invulnerableTime:I", opcode=181, ordinal=0))
    private void syncInvulnerability(LocalPlayer player, int x) {
        player.invulnerableTime = x / 2;
    }

    @ModifyExpressionValue(method={"canStartSprinting()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z")})
    private boolean isShieldCrouching(boolean original) {
        return original || this.isBlocking();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return (Boolean)CombatifyClient.shieldCrouch.get();
    }
}

