/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.CombatifyClient;
import net.atlas.combatify.client.ShieldMaterial;
import net.atlas.combatify.item.TieredShieldItem;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntityWithoutLevelRenderer.class})
public class RendererMixin {
    @Unique
    private ShieldModel modelIronShield;
    @Unique
    private ShieldModel modelGoldenShield;
    @Unique
    private ShieldModel modelDiamondShield;
    @Unique
    private ShieldModel modelNetheriteShield;
    @Final
    @Shadow
    private EntityModelSet entityModelSet;

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="HEAD")})
    private void setModelNetheriteShield(CallbackInfo ci) {
        if (Combatify.CONFIG.tieredShields().booleanValue()) {
            this.modelIronShield = new ShieldModel(this.entityModelSet.bakeLayer(CombatifyClient.IRON_SHIELD_MODEL_LAYER));
            this.modelGoldenShield = new ShieldModel(this.entityModelSet.bakeLayer(CombatifyClient.GOLDEN_SHIELD_MODEL_LAYER));
            this.modelDiamondShield = new ShieldModel(this.entityModelSet.bakeLayer(CombatifyClient.DIAMOND_SHIELD_MODEL_LAYER));
            this.modelNetheriteShield = new ShieldModel(this.entityModelSet.bakeLayer(CombatifyClient.NETHERITE_SHIELD_MODEL_LAYER));
        }
    }

    @Inject(method={"renderByItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="HEAD")})
    private void mainRender(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, CallbackInfo ci) {
        if (Combatify.CONFIG.tieredShields().booleanValue()) {
            if (stack.is(TieredShieldItem.IRON_SHIELD)) {
                RendererMixin.renderExtra(poseStack, this.modelIronShield, ShieldMaterial.IRON_SHIELD, stack.getComponents(), itemDisplayContext, stack, multiBufferSource, i, j);
            }
            if (stack.is(TieredShieldItem.GOLD_SHIELD)) {
                RendererMixin.renderExtra(poseStack, this.modelGoldenShield, ShieldMaterial.GOLDEN_SHIELD, stack.getComponents(), itemDisplayContext, stack, multiBufferSource, i, j);
            }
            if (stack.is(TieredShieldItem.DIAMOND_SHIELD)) {
                RendererMixin.renderExtra(poseStack, this.modelDiamondShield, ShieldMaterial.DIAMOND_SHIELD, stack.getComponents(), itemDisplayContext, stack, multiBufferSource, i, j);
            }
            if (stack.is(TieredShieldItem.NETHERITE_SHIELD)) {
                RendererMixin.renderExtra(poseStack, this.modelNetheriteShield, ShieldMaterial.NETHERITE_SHIELD, stack.getComponents(), itemDisplayContext, stack, multiBufferSource, i, j);
            }
        }
    }

    @Unique
    private static void renderExtra(PoseStack poseStack, ShieldModel model, ShieldMaterial material, DataComponentMap dataComponentMap, ItemDisplayContext itemDisplayContext, ItemStack itemStack, MultiBufferSource multiBufferSource, int i, int j) {
        BannerPatternLayers bannerPatternLayers = dataComponentMap != null ? (BannerPatternLayers)dataComponentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyeColor = dataComponentMap != null ? (DyeColor)dataComponentMap.get(DataComponents.BASE_COLOR) : null;
        boolean hasBanner = !bannerPatternLayers.layers().isEmpty() || dyeColor != null;
        poseStack.pushPose();
        poseStack.scale(1.0f, -1.0f, -1.0f);
        Material result = material.choose(hasBanner);
        VertexConsumer vertexConsumer = result.sprite().wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)model.renderType(result.atlasLocation()), (itemDisplayContext == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)itemStack.hasFoil()));
        model.handle().render(poseStack, vertexConsumer, i, j);
        if (hasBanner) {
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (int)j, (ModelPart)model.plate(), (Material)result, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternLayers, (boolean)itemStack.hasFoil());
        } else {
            model.plate().render(poseStack, vertexConsumer, i, j);
        }
        poseStack.popPose();
    }
}

