/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.networking;

import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ItemConfig;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import org.jetbrains.annotations.NotNull;

public class NetworkingHandler {
    public NetworkingHandler() {
        PayloadTypeRegistry.playC2S().register(ServerboundMissPacket.TYPE, ServerboundMissPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundClientInformationExtensionPacket.TYPE, ServerboundClientInformationExtensionPacket.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ServerboundClientInformationExtensionPacket.TYPE, ServerboundClientInformationExtensionPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(RemainingUseSyncPacket.TYPE, RemainingUseSyncPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateBridgingStatusPacket.TYPE, UpdateBridgingStatusPacket.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ClientboundClientInformationRetrievalPacket.TYPE, ClientboundClientInformationRetrievalPacket.CODEC);
        ServerPlayConnectionEvents.DISCONNECT.register(Combatify.modDetectionNetworkChannel, (handler, server) -> {
            if (Combatify.unmoddedPlayers.contains(handler.player.getUUID())) {
                Combatify.unmoddedPlayers.remove(handler.player.getUUID());
                Combatify.isPlayerAttacking.remove(handler.player.getUUID());
            }
            Combatify.moddedPlayers.remove(handler.player.getUUID());
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundMissPacket.TYPE, (packet, context) -> {
            ServerPlayer player = context.player().connection.getPlayer();
            ServerLevel serverLevel = player.serverLevel();
            player.resetLastActionTime();
            if (!serverLevel.getWorldBorder().isWithinBounds(player.blockPosition())) {
                return;
            }
            player.combatify$attackAir();
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ServerboundClientInformationExtensionPacket.TYPE, (payload, context) -> {
            context.networkHandler().combatify$setShieldOnCrouch(payload.useShieldOnCrouch);
            context.networkHandler().finishCurrentTask(ClientRetrievalTask.TYPE);
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundClientInformationExtensionPacket.TYPE, (payload, context) -> context.player().connection.getPlayer().combatify$setShieldOnCrouch(payload.useShieldOnCrouch));
        ServerPlayConnectionEvents.JOIN.register(Combatify.modDetectionNetworkChannel, (handler, sender, server) -> {
            boolean bl;
            boolean bl2 = bl = Combatify.CONFIG.configOnlyWeapons() != false || Combatify.CONFIG.letVanillaConnect() == false;
            if (!ServerPlayNetworking.canSend((ServerPlayer)handler.player, RemainingUseSyncPacket.TYPE)) {
                if (bl) {
                    handler.player.connection.disconnect((Component)Component.literal((String)"Combatify needs to be installed on the client to join this server!"));
                    return;
                }
                Combatify.unmoddedPlayers.add(handler.player.getUUID());
                Combatify.isPlayerAttacking.put(handler.player.getUUID(), true);
                Combatify.LOGGER.info("Unmodded player joined: " + String.valueOf(handler.player.getUUID()));
                return;
            }
            Combatify.moddedPlayers.add(handler.player.getUUID());
        });
        ServerLifecycleEvents.SERVER_STARTED.register(Combatify.modDetectionNetworkChannel, server -> {
            Combatify.ITEMS = new ItemConfig();
        });
    }

    public record ServerboundMissPacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ServerboundMissPacket> TYPE = new CustomPacketPayload.Type(Combatify.id("miss_attack"));
        public static final StreamCodec<FriendlyByteBuf, ServerboundMissPacket> CODEC = CustomPacketPayload.codec(ServerboundMissPacket::write, ServerboundMissPacket::new);

        public ServerboundMissPacket(FriendlyByteBuf buf) {
            this();
        }

        public void write(FriendlyByteBuf buf) {
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record ServerboundClientInformationExtensionPacket(boolean useShieldOnCrouch) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ServerboundClientInformationExtensionPacket> TYPE = new CustomPacketPayload.Type(Combatify.id("client_extras"));
        public static final StreamCodec<FriendlyByteBuf, ServerboundClientInformationExtensionPacket> CODEC = CustomPacketPayload.codec(ServerboundClientInformationExtensionPacket::write, ServerboundClientInformationExtensionPacket::new);

        public ServerboundClientInformationExtensionPacket(FriendlyByteBuf buf) {
            this(buf.readBoolean());
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeBoolean(this.useShieldOnCrouch);
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record RemainingUseSyncPacket(int id, int ticks) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RemainingUseSyncPacket> TYPE = new CustomPacketPayload.Type(Combatify.id("remaining_use_ticks"));
        public static final StreamCodec<FriendlyByteBuf, RemainingUseSyncPacket> CODEC = CustomPacketPayload.codec(RemainingUseSyncPacket::write, RemainingUseSyncPacket::new);

        public RemainingUseSyncPacket(FriendlyByteBuf buf) {
            this(buf.readVarInt(), buf.readInt());
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeVarInt(this.id);
            buf.writeInt(this.ticks);
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record UpdateBridgingStatusPacket(boolean enableBridging) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<UpdateBridgingStatusPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"update_status"));
        public static final StreamCodec<FriendlyByteBuf, UpdateBridgingStatusPacket> CODEC = CustomPacketPayload.codec(UpdateBridgingStatusPacket::write, UpdateBridgingStatusPacket::new);

        public UpdateBridgingStatusPacket(FriendlyByteBuf buf) {
            this(buf.readBoolean());
        }

        public void write(FriendlyByteBuf buf) {
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record ClientboundClientInformationRetrievalPacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientboundClientInformationRetrievalPacket> TYPE = new CustomPacketPayload.Type(Combatify.id("client_retrieval"));
        public static final StreamCodec<FriendlyByteBuf, ClientboundClientInformationRetrievalPacket> CODEC = CustomPacketPayload.codec(ClientboundClientInformationRetrievalPacket::write, ClientboundClientInformationRetrievalPacket::new);

        public ClientboundClientInformationRetrievalPacket(FriendlyByteBuf buf) {
            this();
        }

        public void write(FriendlyByteBuf buf) {
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record ClientRetrievalTask() implements ConfigurationTask
    {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(Combatify.id("client_info_retrieval").toString());

        public void start(Consumer<Packet<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)new ClientboundClientInformationRetrievalPacket()));
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }
}

