/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;

public record ComponentModifier(Component tooltipComponent, EnchantmentValueEffect modifier, Optional<BlockingCondition> showInTooltip, float componentValueFactor) {
    public static final Codec<ComponentModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("tooltip").forGetter(ComponentModifier::tooltipComponent), (App)EnchantmentValueEffect.CODEC.fieldOf("modifier").forGetter(ComponentModifier::modifier), (App)BlockingConditions.MAP_CODEC.codec().optionalFieldOf("show_in_tooltip").forGetter(ComponentModifier::showInTooltip), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("tooltip_value_factor", (Object)Float.valueOf(1.0f)).forGetter(ComponentModifier::componentValueFactor)).apply((Applicative)instance, ComponentModifier::new));
    public static final Codec<ComponentModifier> NO_CONDITION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("tooltip", (Object)Component.empty()).forGetter(ComponentModifier::tooltipComponent), (App)EnchantmentValueEffect.CODEC.fieldOf("modifier").forGetter(ComponentModifier::modifier), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("tooltip_value_factor", (Object)Float.valueOf(1.0f)).forGetter(ComponentModifier::componentValueFactor)).apply((Applicative)instance, ComponentModifier::new));

    public ComponentModifier(Component tooltipComponent, EnchantmentValueEffect modifier, BlockingCondition showInTooltip, float componentValueFactor) {
        this(tooltipComponent, modifier, Optional.of(showInTooltip), componentValueFactor);
    }

    public ComponentModifier(Component tooltipComponent, EnchantmentValueEffect modifier, float componentValueFactor) {
        this(tooltipComponent, modifier, Optional.empty(), componentValueFactor);
    }

    public float modifyValue(float value, int blockingLevel, RandomSource randomSource) {
        return this.modifier.process(blockingLevel, randomSource, value);
    }

    public boolean matches(ItemStack itemStack) {
        return this.showInTooltip.isEmpty() || this.showInTooltip.get().appliesComponentModifier(itemStack);
    }

    public static Component buildComponent(Component base, float val) {
        ComponentContents componentContents = base.copy().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            Object[] args = new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(val)};
            args = Arrays.copyOf(args, translatableContents.getArgs().length + 1);
            int i = 1;
            for (Object o : translatableContents.getArgs()) {
                if (i >= args.length) break;
                args[i] = o;
                ++i;
            }
            TranslatableContents copiedContents = new TranslatableContents(translatableContents.getKey(), translatableContents.getFallback(), args);
            return MutableComponent.create((ComponentContents)copiedContents);
        }
        return base;
    }

    public List<Component> tryCombine(List<ComponentModifier> others, int blockingLevel, RandomSource randomSource) {
        ArrayList<Component> res = new ArrayList<Component>();
        float val = 0.0f;
        for (int i = others.size() - 1; i >= 0; --i) {
            ComponentModifier other = others.get(i);
            if (!this.tooltipComponent.equals((Object)other.tooltipComponent) || this.componentValueFactor != other.componentValueFactor) continue;
            val = other.modifyValue(val, blockingLevel, randomSource);
            others.remove(i);
        }
        if ((val *= this.componentValueFactor) > 0.0f) {
            res.add(ComponentModifier.buildComponent(this.tooltipComponent, val));
        }
        if (!others.isEmpty()) {
            res.addAll(others.getFirst().tryCombine(others, blockingLevel, randomSource));
        }
        return res;
    }

    public float tryCombineVal(List<ComponentModifier> others, int blockingLevel, RandomSource randomSource) {
        float val = 0.0f;
        for (ComponentModifier other : others) {
            val = other.modifyValue(val, blockingLevel, randomSource);
        }
        return val;
    }

    public record DataSet(float addValue, float multiplyValue) {
    }

    public record CombinedModifier(ComponentModifier base, ComponentModifier factor, Optional<BlockingCondition> showInTooltip) {
        public static Codec<CombinedModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NO_CONDITION_CODEC.fieldOf("base").forGetter(CombinedModifier::base), (App)NO_CONDITION_CODEC.fieldOf("factor").forGetter(CombinedModifier::factor), (App)BlockingConditions.MAP_CODEC.codec().optionalFieldOf("show_in_tooltip").forGetter(CombinedModifier::showInTooltip)).apply((Applicative)instance, CombinedModifier::new));

        public DataSet modifyValues(DataSet val, int blockingLevel, RandomSource randomSource) {
            return new DataSet(this.base.modifyValue(val.addValue, blockingLevel, randomSource), this.factor.modifyValue(val.multiplyValue, blockingLevel, randomSource));
        }

        public List<Component> tryCombine(List<CombinedModifier> others, int blockingLevel, RandomSource randomSource) {
            ArrayList<ComponentModifier> res = new ArrayList<ComponentModifier>();
            for (CombinedModifier other : others) {
                if (!other.base.tooltipComponent.equals((Object)Component.empty())) {
                    res.add(other.base);
                }
                if (other.factor.tooltipComponent.equals((Object)Component.empty())) continue;
                res.add(other.factor);
            }
            if (!res.isEmpty()) {
                return ((ComponentModifier)res.getFirst()).tryCombine(res, blockingLevel, randomSource);
            }
            return Collections.emptyList();
        }

        public DataSet tryCombineVal(List<CombinedModifier> others, int blockingLevel, RandomSource randomSource) {
            DataSet val = new DataSet(0.0f, 0.0f);
            for (CombinedModifier other : others) {
                val = other.modifyValues(val, blockingLevel, randomSource);
            }
            return val;
        }

        public boolean matches(ItemStack itemStack) {
            return this.showInTooltip.isEmpty() || this.showInTooltip.get().appliesComponentModifier(itemStack);
        }

        public static CombinedModifier createFactorOnly(ComponentModifier factor, Optional<BlockingCondition> showInTooltip) {
            return new CombinedModifier(new ComponentModifier((Component)Component.empty(), (EnchantmentValueEffect)new AddValue((LevelBasedValue)new LevelBasedValue.Constant(0.0f)), Optional.empty(), 1.0f), factor, showInTooltip);
        }

        public static CombinedModifier createBaseOnly(ComponentModifier base, Optional<BlockingCondition> showInTooltip) {
            return new CombinedModifier(base, new ComponentModifier((Component)Component.empty(), (EnchantmentValueEffect)new AddValue((LevelBasedValue)new LevelBasedValue.Constant(0.0f)), Optional.empty(), 1.0f), showInTooltip);
        }
    }
}

