/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ItemMatches(ItemPredicate predicate, boolean invert) implements BlockingCondition
{
    public static final Codec<ItemPredicate> ITEM_PREDICATE_CODEC_NO_ITEMS = RecordCodecBuilder.create(instance -> instance.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("count", (Object)MinMaxBounds.Ints.ANY).forGetter(ItemPredicate::count), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(ItemPredicate::components), (App)ItemSubPredicate.CODEC.optionalFieldOf("predicates", Map.of()).forGetter(ItemPredicate::subPredicates)).apply((Applicative)instance, (ints, dataComponentPredicate, typeItemSubPredicateMap) -> new ItemPredicate(Optional.empty(), ints, dataComponentPredicate, typeItemSubPredicateMap)));
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"item_matches");
    public static final MapCodec<ItemMatches> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ITEM_PREDICATE_CODEC_NO_ITEMS.fieldOf("predicate").forGetter(ItemMatches::predicate), (App)Codec.BOOL.optionalFieldOf("invert", (Object)false).forGetter(ItemMatches::invert)).apply((Applicative)instance, ItemMatches::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemMatches> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodecTrusted(ITEM_PREDICATE_CODEC_NO_ITEMS), ItemMatches::predicate, (StreamCodec)ByteBufCodecs.BOOL, ItemMatches::invert, ItemMatches::new);

    @Override
    public boolean canBlock(ServerLevel serverLevel, LivingEntity instance, ItemStack blockingItem, DamageSource source, float amount) {
        return this.predicate.test(blockingItem) != this.invert;
    }

    @Override
    public boolean canUse(ItemStack itemStack, Level level, Player player, InteractionHand interactionHand) {
        return this.predicate.test(itemStack) != this.invert;
    }

    @Override
    public boolean canShowInToolTip(ItemStack itemStack, Player player) {
        return this.predicate.test(itemStack) != this.invert;
    }

    @Override
    public boolean overridesUseDurationAndAnimation(ItemStack itemStack) {
        return this.predicate.test(itemStack) != this.invert;
    }

    @Override
    public boolean appliesComponentModifier(ItemStack itemStack) {
        return this.predicate.test(itemStack) != this.invert;
    }

    @Override
    public MapCodec<? extends BlockingCondition> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static void mapStreamCodec(Map<ResourceLocation, StreamCodec<RegistryFriendlyByteBuf, BlockingCondition>> map) {
        map.put(ID, (StreamCodec<RegistryFriendlyByteBuf, BlockingCondition>)STREAM_CODEC.map(itemMatches -> itemMatches, blockingCondition -> (ItemMatches)blockingCondition));
    }
}

