/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.damage_parsers;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.damage_parsers.DamageParser;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public record PercentageBase(List<TagPredicate<DamageType>> requirements, boolean enforceAll) implements DamageParser
{
    public static final DamageParser ALL = new PercentageBase(Collections.emptyList(), true);
    public static final DamageParser IGNORE_EXPLOSIONS_AND_PROJECTILES = new PercentageBase(List.of(TagPredicate.isNot((TagKey)DamageTypeTags.IS_EXPLOSION), TagPredicate.isNot((TagKey)DamageTypeTags.IS_PROJECTILE)), true);
    public static final MapCodec<PercentageBase> CODEC = DamageParser.mapCodec(PercentageBase::new);

    @Override
    public float parse(float originalValue, ComponentModifier.DataSet protection, Holder<DamageType> damageType) {
        float subVal = originalValue - protection.addValue();
        subVal = Math.max(subVal, 0.0f);
        if (this.allAre(damageType)) {
            return Math.min(originalValue, protection.addValue() + subVal * protection.multiplyValue());
        }
        return 0.0f;
    }

    @Override
    public MapCodec<? extends DamageParser> codec() {
        return CODEC;
    }
}

