/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.Vec3;

public record KnockbackEntity(LevelBasedValue strength, boolean force, boolean inverseDirection) implements PostBlockEffect
{
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"knockback_entity");
    public static final MapCodec<KnockbackEntity> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.optionalFieldOf("strength", (Object)LevelBasedValue.constant((float)0.5f)).forGetter(KnockbackEntity::strength), (App)Codec.BOOL.optionalFieldOf("force", (Object)false).forGetter(KnockbackEntity::force), (App)Codec.BOOL.optionalFieldOf("inverse_direction", (Object)false).forGetter(KnockbackEntity::inverseDirection)).apply((Applicative)instance, KnockbackEntity::new));

    public KnockbackEntity() {
        this((LevelBasedValue)LevelBasedValue.constant((float)0.5f), false, false);
    }

    @Override
    public void doEffect(ServerLevel serverLevel, EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, DamageSource damageSource, int enchantmentLevel, LivingEntity toApply, Vec3 position) {
        assert (enchantedItemInUse.owner() != null);
        Vec3 targetPosition = this.getPosition(enchantedItemInUse, attacker, toApply, position, this.inverseDirection);
        Vec3 attackerPosition = this.getPosition(enchantedItemInUse, attacker, toApply, position, !this.inverseDirection);
        double x = targetPosition.x() - attackerPosition.x();
        double z = targetPosition.z() - attackerPosition.z();
        if (this.force) {
            toApply.hurtMarked = true;
        }
        Combatify.CONFIG.knockbackMode().runKnockback(toApply, null, this.strength.calculate(enchantmentLevel), x, z, LivingEntity::knockback);
    }

    private Vec3 getPosition(EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, LivingEntity toApply, Vec3 position, boolean inverse) {
        if (!inverse) {
            return toApply.equals((Object)attacker) ? enchantedItemInUse.owner().position() : position;
        }
        return toApply.equals((Object)attacker) ? position : enchantedItemInUse.owner().position();
    }

    @Override
    public MapCodec<? extends PostBlockEffect> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

