/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.combatify.util.blocking.effect.DoNothing;
import net.atlas.combatify.util.blocking.effect.KnockbackEntity;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.atlas.combatify.util.blocking.effect.PostBlockEffects;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record PostBlockEffectWrapper(EnchantmentTarget affected, PostBlockEffect effect, Optional<LootItemCondition> requirements) {
    public static final PostBlockEffectWrapper DEFAULT = new PostBlockEffectWrapper(EnchantmentTarget.ATTACKER, new DoNothing(), Optional.empty());
    public static final PostBlockEffectWrapper KNOCKBACK = new PostBlockEffectWrapper(EnchantmentTarget.ATTACKER, new KnockbackEntity(), Optional.empty());
    public static final MapCodec<PostBlockEffectWrapper> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnchantmentTarget.CODEC.optionalFieldOf("affected", (Object)EnchantmentTarget.ATTACKER).forGetter(PostBlockEffectWrapper::affected), (App)PostBlockEffects.CODEC.fieldOf("effect").forGetter(PostBlockEffectWrapper::effect), (App)ConditionalEffect.conditionCodec((LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).optionalFieldOf("requirements").forGetter(PostBlockEffectWrapper::requirements)).apply((Applicative)instance, PostBlockEffectWrapper::new));

    public boolean matches(LootContext lootContext) {
        return this.requirements.map(lootItemCondition -> lootItemCondition.test((Object)lootContext)).orElse(true);
    }
}

