/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util.blocking.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.combatify.util.blocking.effect.PostBlockEffect;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public record RunFunction(ResourceLocation function) implements PostBlockEffect
{
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"run_function");
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<RunFunction> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("function").forGetter(RunFunction::function)).apply((Applicative)instance, RunFunction::new));

    @Override
    public void doEffect(ServerLevel serverLevel, EnchantedItemInUse enchantedItemInUse, LivingEntity attacker, DamageSource damageSource, int enchantmentLevel, LivingEntity toApply, Vec3 position) {
        MinecraftServer minecraftServer = serverLevel.getServer();
        ServerFunctionManager serverFunctionManager = minecraftServer.getFunctions();
        Optional optional = serverFunctionManager.get(this.function);
        if (optional.isPresent()) {
            CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withPermission(2).withSuppressedOutput().withEntity((Entity)toApply).withLevel(serverLevel).withPosition(position).withRotation(toApply.getRotationVector());
            serverFunctionManager.execute((CommandFunction)optional.get(), commandSourceStack);
        } else {
            LOGGER.error("Blocking effect run_function failed for non-existent function {}", (Object)this.function);
        }
    }

    @Override
    public MapCodec<? extends PostBlockEffect> type() {
        return MAP_CODEC;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

