/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.custom;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingType;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.condition.AnyOf;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.atlas.combatify.util.blocking.condition.Unconditional;
import net.atlas.combatify.util.blocking.damage_parsers.DamageParser;
import net.atlas.combatify.util.blocking.damage_parsers.Nullify;
import net.atlas.combatify.util.blocking.damage_parsers.PercentageBase;
import net.atlas.combatify.util.blocking.effect.PostBlockEffectWrapper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1679;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9699;
import net.minecraft.class_9703;
import org.apache.commons.lang3.mutable.MutableFloat;

public record Blocker(List<DamageParser> damageParsers, Tooltip tooltip, class_2960 blockingTypeLocation, float useSeconds, PostBlockEffectWrapper postBlockEffect, BlockingCondition blockingCondition) {
    public static final Blocker EMPTY = new Blocker(Collections.emptyList(), new Tooltip(Collections.emptyList(), Collections.emptyList(), false), class_2960.method_60656((String)"empty"), 0.0f, PostBlockEffectWrapper.DEFAULT, new AnyOf(Collections.emptyList()));
    public static final Blocker VANILLA_SHIELD = new Blocker(Collections.singletonList(Nullify.NULLIFY_ALL), new Tooltip(Collections.emptyList(), Collections.emptyList(), true), class_2960.method_60656((String)"shield"), 3600.0f, PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final Blocker NEW_SHIELD = new Blocker(List.of(PercentageBase.IGNORE_EXPLOSIONS_AND_PROJECTILES, Nullify.NULLIFY_EXPLOSIONS_AND_PROJECTILES), new Tooltip(Collections.singletonList(BlockingTypeInit.NEW_SHIELD_PROTECTION), Collections.singletonList(BlockingTypeInit.NEW_SHIELD_KNOCKBACK), true), class_2960.method_60656((String)"new_shield"), 3600.0f, PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final Codec<Blocker> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DamageParser.CODEC.listOf().fieldOf("damage_parsers").forGetter(Blocker::damageParsers), (App)Tooltip.CODEC.forGetter(Blocker::tooltip), (App)BlockingType.ID_CODEC.fieldOf("type").forGetter(Blocker::blockingTypeLocation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("seconds", (Object)Float.valueOf(3600.0f)).forGetter(Blocker::useSeconds), (App)PostBlockEffectWrapper.CODEC.orElse((Object)PostBlockEffectWrapper.KNOCKBACK).forGetter(Blocker::postBlockEffect), (App)BlockingConditions.MAP_CODEC.orElse((Object)Unconditional.INSTANCE).forGetter(Blocker::blockingCondition)).apply((Applicative)instance, Blocker::new));
    public static final class_9139<class_9129, Blocker> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_9135.method_57987(DamageParser.CODEC)), Blocker::damageParsers, (class_9139)class_9135.method_57987((Codec)Tooltip.CODEC.codec()), Blocker::tooltip, (class_9139)class_2960.field_48267, Blocker::blockingTypeLocation, (class_9139)class_9135.field_48552, Blocker::useSeconds, (class_9139)class_9135.method_58002((Codec)PostBlockEffectWrapper.CODEC.codec()), Blocker::postBlockEffect, BlockingCondition.STREAM_CODEC, Blocker::blockingCondition, Blocker::new);

    public Blocker withProtection(List<ComponentModifier.CombinedModifier> protection) {
        return new Blocker(this.damageParsers, new Tooltip(protection, this.tooltip.knockbackModifiers, this.tooltip.markBlocked), this.blockingTypeLocation, this.useSeconds, this.postBlockEffect, this.blockingCondition);
    }

    public Blocker withKnockback(List<ComponentModifier> knockback) {
        return new Blocker(this.damageParsers, new Tooltip(this.tooltip.protectionModifiers, knockback, this.tooltip.markBlocked), this.blockingTypeLocation, this.useSeconds, this.postBlockEffect, this.blockingCondition);
    }

    public BlockingType blockingType() {
        if (this.blockingTypeLocation.equals((Object)class_2960.method_60656((String)"empty"))) {
            return BlockingTypeInit.EMPTY;
        }
        return Combatify.registeredTypes.get(this.blockingTypeLocation);
    }

    public void doEffect(class_3218 serverLevel, class_1304 equipmentSlot, class_1799 blockingItem, class_1309 target, class_1309 attacker, class_1282 damageSource) {
        if (this.postBlockEffect.matches(class_1887.method_60040((class_3218)serverLevel, (int)1, (class_1297)target, (class_1282)damageSource))) {
            class_1309 applicable = switch (this.postBlockEffect.affected()) {
                default -> throw new MatchException(null, null);
                case class_9703.field_51683, class_9703.field_51684 -> attacker;
                case class_9703.field_51685 -> target;
            };
            this.postBlockEffect.effect().doEffect(serverLevel, new class_9699(blockingItem, equipmentSlot, target), attacker, damageSource, 1, applicable, applicable.method_19538());
        }
        CustomEnchantmentHelper.applyPostBlockedEffects(serverLevel, target, attacker, damageSource);
        MethodHandler.disableShield(attacker, target, damageSource, blockingItem);
    }

    public int useTicks() {
        return (int)(this.useSeconds * 20.0f);
    }

    public void block(class_3218 serverLevel, class_1309 instance, class_1282 source, class_1799 itemStack, LocalFloatRef amount, LocalFloatRef protectedDamage, LocalBooleanRef blocked) {
        if (this.blockingCondition.canBlock(serverLevel, instance, itemStack, source, amount.get())) {
            if (MethodHandler.getBlockingType(itemStack).hasDelay() && Combatify.CONFIG.shieldDelay() > 0 && itemStack.method_7935(instance) - instance.method_6014() < Combatify.CONFIG.shieldDelay()) {
                class_1297 class_12972;
                if (Combatify.CONFIG.disableDuringShieldDelay().booleanValue() && (class_12972 = source.method_5526()) instanceof class_1309) {
                    class_1309 attacker = (class_1309)class_12972;
                    MethodHandler.disableShield(attacker, instance, source, itemStack);
                }
                return;
            }
            this.completeBlock(serverLevel, instance, itemStack, source, amount, protectedDamage, blocked);
        }
    }

    public void completeBlock(class_3218 serverLevel, class_1309 instance, class_1799 blockingItem, class_1282 source, LocalFloatRef amount, LocalFloatRef protectedDamage, LocalBooleanRef wasBlocked) {
        int blockingLevel = (Integer)blockingItem.method_57825(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
        ComponentModifier.DataSet protection = new ComponentModifier.DataSet(0.0f, 0.0f);
        List<ComponentModifier.CombinedModifier> intermediaryProtection = this.tooltip.protectionModifiers().stream().filter(combinedModifier -> combinedModifier.matches(blockingItem)).toList();
        if (!intermediaryProtection.isEmpty()) {
            protection = intermediaryProtection.getFirst().tryCombineVal(intermediaryProtection, blockingLevel, instance.method_59922());
        }
        ComponentModifier.DataSet endProtection = CustomEnchantmentHelper.modifyShieldEffectiveness(blockingItem, instance.method_59922(), protection);
        this.damageParsers.forEach(damageParserConditionalEffect -> {
            protectedDamage.set(damageParserConditionalEffect.parse(amount.get(), endProtection, (class_6880<class_8110>)source.method_48793()));
            amount.set(Math.max(amount.get() - protectedDamage.get(), 0.0f));
        });
        MethodHandler.hurtCurrentlyUsedShield(instance, protectedDamage.get());
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            MethodHandler.blockedByShield(serverLevel, instance, livingEntity, source);
        }
        class_1297 class_12973 = source.method_5526();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1667.class, class_1679.class}, (Object)class_12973, n)) {
                case 0: {
                    class_1667 arrow = (class_1667)class_12973;
                    if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((class_1665)arrow)) {
                        n = 1;
                        continue block4;
                    }
                    MethodHandler.arrowDisable(instance, source, (class_1665)arrow, blockingItem);
                    break block4;
                }
                case 1: {
                    class_1679 arrow = (class_1679)class_12973;
                    if (!Combatify.CONFIG.arrowDisableMode().satisfiesConditions((class_1665)arrow)) {
                        n = 2;
                        continue block4;
                    }
                    MethodHandler.arrowDisable(instance, source, (class_1665)arrow, blockingItem);
                    break block4;
                }
            }
            break;
        }
        wasBlocked.set(this.tooltip.markBlocked);
    }

    public class_1269 use(class_1799 itemStack, class_1937 level, class_1657 user, class_1268 hand, class_1269 original) {
        if (this.blockingTypeLocation.equals((Object)class_2960.method_60656((String)"empty"))) {
            return null;
        }
        if (original != class_1269.field_5811) {
            return null;
        }
        if (!this.canUse(itemStack, level, user, hand)) {
            return null;
        }
        user.method_6019(hand);
        return class_1269.field_21466;
    }

    public boolean canUse(class_1799 itemStack, class_1937 level, class_1657 user, class_1268 hand) {
        return this.blockingCondition.canUse(itemStack, level, user, hand);
    }

    public boolean canShowInTooltip(class_1799 itemStack, class_1657 player) {
        return this.blockingCondition.canShowInToolTip(itemStack, player);
    }

    public boolean canOverrideUseDurationAndAnimation(class_1799 itemStack) {
        return this.blockingCondition.overridesUseDurationAndAnimation(itemStack);
    }

    public record Tooltip(List<ComponentModifier.CombinedModifier> protectionModifiers, List<ComponentModifier> knockbackModifiers, boolean markBlocked) {
        public static MapCodec<Tooltip> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentModifier.CombinedModifier.CODEC.listOf().fieldOf("protection_modifiers").forGetter(Tooltip::protectionModifiers), (App)ComponentModifier.CODEC.listOf().optionalFieldOf("knockback_modifiers", Collections.emptyList()).forGetter(Tooltip::knockbackModifiers), (App)Codec.BOOL.fieldOf("mark_blocked").forGetter(Tooltip::markBlocked)).apply((Applicative)instance, Tooltip::new));

        public void appendTooltipInfo(Consumer<class_2561> writer, class_1657 player, class_1799 stack) {
            List<ComponentModifier> intermediaryKnockback;
            List<Object> protection = Collections.emptyList();
            List<Object> knockback = Collections.emptyList();
            int blockingLevel = (Integer)stack.method_57825(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            List<ComponentModifier.CombinedModifier> intermediaryProtection = this.protectionModifiers.stream().filter(combinedModifier -> combinedModifier.matches(stack)).toList();
            if (!intermediaryProtection.isEmpty()) {
                protection = intermediaryProtection.getFirst().tryCombine(new ArrayList<ComponentModifier.CombinedModifier>(intermediaryProtection), blockingLevel, player.method_59922());
            }
            if (!(intermediaryKnockback = this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(stack)).toList()).isEmpty()) {
                knockback = intermediaryKnockback.getFirst().tryCombine(new ArrayList<ComponentModifier>(intermediaryKnockback), blockingLevel, player.method_59922());
            }
            if (protection.isEmpty() && knockback.isEmpty()) {
                return;
            }
            writer.accept(class_5244.field_39003);
            writer.accept((class_2561)class_2561.method_48321((String)"item.modifiers.use", (String)"When used:").method_27692(class_124.field_1080));
            protection.forEach(component -> writer.accept((class_2561)class_5244.method_48320().method_10852(component).method_27692(class_124.field_1077)));
            knockback.forEach(component -> writer.accept((class_2561)class_5244.method_48320().method_10852(component).method_27692(class_124.field_1077)));
        }

        public float getShieldKnockbackResistanceValue(class_1799 itemStack, class_5819 randomSource) {
            int blockingLevel = (Integer)itemStack.method_57825(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            MutableFloat knockbackResistance = new MutableFloat(0.0f);
            this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(itemStack)).forEach(componentModifier -> knockbackResistance.setValue(componentModifier.modifyValue(knockbackResistance.getValue().floatValue(), blockingLevel, randomSource)));
            return knockbackResistance.getValue().floatValue();
        }
    }
}

