/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import net.atlas.combatify.annotation.mixin.Incompatible;
import net.atlas.combatify.annotation.mixin.ModSpecific;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        Logger logger = LogManager.getLogger((String)"Combatify");
        try {
            ClassNode mixin = MixinService.getService().getBytecodeProvider().getClassNode(mixinClassName, false);
            if (this.mentionsActiveMods(Incompatible.class, mixin)) {
                logger.warn("[{}] Mod \"{}\" is marked incompatible with mixin \"{}\", cancelling application.", (Object)this.getClass().getSimpleName(), (Object)this.getFirstMentionedActiveMod(Incompatible.class, mixin), (Object)mixinClassName);
                return false;
            }
            if (this.hasAnnotation(ModSpecific.class, mixin)) {
                if (this.mentionsActiveMods(ModSpecific.class, mixin)) {
                    logger.info("[{}] Loading mod-specific mixin \"{}\" since mod \"{}\" is present.", (Object)this.getClass().getSimpleName(), (Object)mixinClassName, (Object)this.getFirstMentionedActiveMod(ModSpecific.class, mixin));
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass, ClassNode mixin) {
        return Annotations.getInvisible((ClassNode)mixin, annotationClass) != null;
    }

    public String getFirstMentionedActiveMod(Class<? extends Annotation> annotationClass, ClassNode mixin) {
        List values;
        FabricLoader fabricLoader = FabricLoader.getInstance();
        AnnotationNode annotationNode = Annotations.getInvisible((ClassNode)mixin, annotationClass);
        if (annotationNode == null || (values = annotationNode.values) == null) {
            return null;
        }
        for (int i = 0; i < values.size(); i += 2) {
            Object pValue;
            Object pKey = values.get(i);
            Object v0 = pValue = values.size() > i + 1 ? values.get(i + 1) : null;
            if (!"value".equals(pKey) || !(pValue instanceof List)) continue;
            for (String modId : (List)pValue) {
                if (!fabricLoader.isModLoaded(modId)) continue;
                return modId;
            }
        }
        return null;
    }

    public boolean mentionsActiveMods(Class<? extends Annotation> annotationClass, ClassNode mixin) {
        return this.getFirstMentionedActiveMod(annotationClass, mixin) != null;
    }
}

