/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.component.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingType;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.ComponentModifier;
import net.atlas.combatify.util.blocking.condition.AnyOf;
import net.atlas.combatify.util.blocking.condition.BlockingCondition;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.atlas.combatify.util.blocking.condition.Unconditional;
import net.atlas.combatify.util.blocking.effect.PostBlockEffectWrapper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9699;
import net.minecraft.class_9703;
import org.apache.commons.lang3.mutable.MutableFloat;

public record ExtendedBlockingData(Tooltip tooltip, class_2960 blockingTypeLocation, PostBlockEffectWrapper postBlockEffect, BlockingCondition blockingCondition, boolean hasBanner) {
    public static final ExtendedBlockingData EMPTY = new ExtendedBlockingData(new Tooltip(Collections.emptyList(), Collections.emptyList()), class_2960.method_60656((String)"empty"), PostBlockEffectWrapper.DEFAULT, new AnyOf(Collections.emptyList()));
    public static final ExtendedBlockingData VANILLA_SHIELD = new ExtendedBlockingData(new Tooltip(Collections.emptyList(), Collections.emptyList()), class_2960.method_60656((String)"shield"), PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final ExtendedBlockingData NEW_SHIELD = new ExtendedBlockingData(new Tooltip(Collections.singletonList(BlockingTypeInit.NEW_SHIELD_PROTECTION), Collections.singletonList(BlockingTypeInit.NEW_SHIELD_KNOCKBACK)), class_2960.method_60656((String)"new_shield"), PostBlockEffectWrapper.KNOCKBACK, Unconditional.INSTANCE);
    public static final Codec<ExtendedBlockingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Tooltip.CODEC.forGetter(ExtendedBlockingData::tooltip), (App)BlockingType.ID_CODEC.fieldOf("type").forGetter(ExtendedBlockingData::blockingTypeLocation), (App)PostBlockEffectWrapper.CODEC.orElse((Object)PostBlockEffectWrapper.KNOCKBACK).forGetter(ExtendedBlockingData::postBlockEffect), (App)BlockingConditions.MAP_CODEC.orElse((Object)Unconditional.INSTANCE).forGetter(ExtendedBlockingData::blockingCondition), (App)Codec.BOOL.optionalFieldOf("considers_banner", (Object)false).forGetter(ExtendedBlockingData::hasBanner)).apply((Applicative)instance, ExtendedBlockingData::new));
    public static final class_9139<class_9129, ExtendedBlockingData> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.method_57987((Codec)Tooltip.CODEC.codec()), ExtendedBlockingData::tooltip, (class_9139)class_2960.field_48267, ExtendedBlockingData::blockingTypeLocation, (class_9139)class_9135.method_58002((Codec)PostBlockEffectWrapper.CODEC.codec()), ExtendedBlockingData::postBlockEffect, BlockingCondition.STREAM_CODEC, ExtendedBlockingData::blockingCondition, (class_9139)class_9135.field_48547, ExtendedBlockingData::hasBanner, ExtendedBlockingData::new);

    public ExtendedBlockingData(Tooltip tooltip, class_2960 blockingTypeLocation, PostBlockEffectWrapper postBlockEffect, BlockingCondition blockingCondition) {
        this(tooltip, blockingTypeLocation, postBlockEffect, blockingCondition, false);
    }

    public ExtendedBlockingData withProtection(List<ComponentModifier.CombinedModifier> protection) {
        return new ExtendedBlockingData(new Tooltip(protection, this.tooltip.knockbackModifiers), this.blockingTypeLocation, this.postBlockEffect, this.blockingCondition);
    }

    public ExtendedBlockingData withKnockback(List<ComponentModifier> knockback) {
        return new ExtendedBlockingData(new Tooltip(this.tooltip.protectionModifiers, knockback), this.blockingTypeLocation, this.postBlockEffect, this.blockingCondition);
    }

    public BlockingType blockingType() {
        if (this.blockingTypeLocation.equals((Object)class_2960.method_60656((String)"empty"))) {
            return BlockingTypeInit.EMPTY;
        }
        return Combatify.registeredTypes.get(this.blockingTypeLocation);
    }

    public void doEffect(class_3218 serverLevel, class_1304 equipmentSlot, class_1799 blockingItem, class_1309 target, class_1309 attacker, class_1282 damageSource) {
        if (this.postBlockEffect.matches(class_1887.method_60040((class_3218)serverLevel, (int)1, (class_1297)target, (class_1282)damageSource))) {
            class_1309 applicable = switch (this.postBlockEffect.affected()) {
                default -> throw new MatchException(null, null);
                case class_9703.field_51683, class_9703.field_51684 -> attacker;
                case class_9703.field_51685 -> target;
            };
            this.postBlockEffect.effect().doEffect(serverLevel, new class_9699(blockingItem, equipmentSlot, target), attacker, damageSource, 1, applicable, applicable.method_73189());
        }
        CustomEnchantmentHelper.applyPostBlockedEffects(serverLevel, target, attacker, damageSource);
        MethodHandler.tryDisable(serverLevel, attacker, target, damageSource, blockingItem);
    }

    public boolean canUse(class_1799 itemStack, class_1937 level, class_1657 user, class_1268 hand) {
        boolean stillRequiresCharge;
        boolean bl = stillRequiresCharge = Combatify.CONFIG.shieldOnlyWhenCharged() != false && user.method_7261(1.0f) < (float)Combatify.CONFIG.shieldChargePercentage().intValue() / 100.0f && this.blockingType().requireFullCharge();
        if (stillRequiresCharge) {
            return false;
        }
        return this.blockingCondition.canUse(itemStack, level, user, hand);
    }

    public boolean canShowInTooltip(class_1799 itemStack, class_1657 player) {
        return this.blockingCondition.canShowInToolTip(itemStack, player);
    }

    public record Tooltip(List<ComponentModifier.CombinedModifier> protectionModifiers, List<ComponentModifier> knockbackModifiers) {
        public static MapCodec<Tooltip> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentModifier.CombinedModifier.CODEC.listOf().fieldOf("protection_modifiers").forGetter(Tooltip::protectionModifiers), (App)ComponentModifier.CODEC.listOf().optionalFieldOf("knockback_modifiers", Collections.emptyList()).forGetter(Tooltip::knockbackModifiers)).apply((Applicative)instance, Tooltip::new));

        public void appendTooltipInfo(Consumer<class_2561> writer, class_1657 player, class_1799 stack) {
            List<ComponentModifier> intermediaryKnockback;
            List<Object> protection = Collections.emptyList();
            List<Object> knockback = Collections.emptyList();
            int blockingLevel = (Integer)stack.method_58695(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            List<ComponentModifier.CombinedModifier> intermediaryProtection = this.protectionModifiers.stream().filter(combinedModifier -> combinedModifier.matches(stack)).toList();
            if (!intermediaryProtection.isEmpty()) {
                protection = intermediaryProtection.getFirst().tryCombine(new ArrayList<ComponentModifier.CombinedModifier>(intermediaryProtection), blockingLevel, player.method_59922());
            }
            if (!(intermediaryKnockback = this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(stack)).toList()).isEmpty()) {
                knockback = intermediaryKnockback.getFirst().tryCombine(new ArrayList<ComponentModifier>(intermediaryKnockback), blockingLevel, player.method_59922());
            }
            if (protection.isEmpty() && knockback.isEmpty()) {
                return;
            }
            writer.accept(class_5244.field_39003);
            writer.accept((class_2561)class_2561.method_48321((String)"item.modifiers.use", (String)"When used:").method_27692(class_124.field_1080));
            protection.forEach(component -> writer.accept((class_2561)class_5244.method_48320().method_10852(component).method_27692(class_124.field_1077)));
            knockback.forEach(component -> writer.accept((class_2561)class_5244.method_48320().method_10852(component).method_27692(class_124.field_1077)));
        }

        public float getShieldKnockbackResistanceValue(class_1799 itemStack, class_5819 randomSource) {
            int blockingLevel = (Integer)itemStack.method_58695(CustomDataComponents.BLOCKING_LEVEL, (Object)1);
            MutableFloat knockbackResistance = new MutableFloat(0.0f);
            this.knockbackModifiers.stream().filter(componentModifier -> componentModifier.matches(itemStack)).forEach(componentModifier -> knockbackResistance.setValue(componentModifier.modifyValue(knockbackResistance.getValue().floatValue(), blockingLevel, randomSource)));
            return knockbackResistance.getValue().floatValue();
        }
    }
}

