/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.function.Supplier;
import net.atlas.combatify.config.ConfigSynchronizer;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ForgeConfig;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.enchantment.DefendingEnchantment;
import net.atlas.combatify.enchantment.EnchantmentRegistry;
import net.atlas.combatify.enchantment.PiercingEnchantment;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.ServerPlayerExtensions;
import net.atlas.combatify.extensions.Tierable;
import net.atlas.combatify.item.ItemRegistry;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.networking.PacketRegistration;
import net.atlas.combatify.networking.S2CConfigPacket;
import net.atlas.combatify.util.ArrayListExtensions;
import net.atlas.combatify.util.BlockingType;
import net.atlas.combatify.util.EmptyBlockingType;
import net.atlas.combatify.util.HitResultRotationEntry;
import net.atlas.combatify.util.NewShieldBlockingType;
import net.atlas.combatify.util.PrefixLogger;
import net.atlas.combatify.util.ShieldBlockingType;
import net.atlas.combatify.util.SwordBlockingType;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@Mod(value="combatify")
@Mod.EventBusSubscriber(modid="combatify", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Combatify {
    public static final String MOD_ID = "combatify";
    public static ForgeConfig CONFIG;
    public static ItemConfig ITEMS;
    public static Supplier<CombatifyState> state;
    public static final List<TieredShieldItem> shields;
    public static final List<UUID> unmoddedPlayers;
    public static final Map<UUID, Boolean> isPlayerAttacking;
    public static final Map<UUID, Boolean> finalizingAttack;
    public static final Map<UUID, Timer> scheduleHitResult;
    public static Map<String, BlockingType> registeredTypes;
    public static final PrefixLogger LOGGER;
    public static final BlockingType SWORD;
    public static final BlockingType SHIELD;
    public static final BlockingType NEW_SHIELD;
    public static final BlockingType EMPTY;

    public static void markState(Supplier<CombatifyState> state) {
        Combatify.state = state;
    }

    public static CombatifyState getState() {
        return state.get();
    }

    public Combatify(FMLJavaModLoadingContext context) {
        Combatify.initConfig();
        IEventBus bus = context.getModEventBus();
        if (((Boolean)Combatify.CONFIG.configOnlyWeapons.get()).booleanValue()) {
            ItemRegistry.registerWeapons(bus);
        }
        if (((Boolean)Combatify.CONFIG.tieredShields.get()).booleanValue()) {
            TieredShieldItem.init(bus);
        }
        if (((Boolean)Combatify.CONFIG.piercer.get()).booleanValue()) {
            PiercingEnchantment.registerEnchants();
        }
        if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
            DefendingEnchantment.registerEnchants();
        }
        if (((Boolean)Combatify.CONFIG.piercer.get()).booleanValue() || ((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
            EnchantmentRegistry.registerAllEnchants(bus);
        }
        bus.addListener(this::commonSetup);
        bus.addListener(this::interModEnqueue);
        bus.addListener(EventPriority.LOW, this::onAddToRegistry);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void interModEnqueue(InterModEnqueueEvent event) {
        LOGGER.info("Config init started.");
        ITEMS = new ItemConfig();
        IForgeRegistry items = ForgeRegistries.ITEMS;
        for (Item item : items) {
            ((ItemExtensions)item).modifyAttributeModifiers();
        }
        for (Item item : Combatify.ITEMS.configuredItems.keySet()) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.stackSize == null) continue;
            ((ItemExtensions)item).setStackSize(configurableItemData.stackSize);
        }
        MobEffects.f_19600_.m_19472_(Attributes.f_22281_, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        MobEffects.f_19613_.m_19472_(Attributes.f_22281_, "22653B89-116E-49DC-9B6B-9971489B5BE5", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        LOGGER.info("Loaded items config.");
    }

    public void onAddToRegistry(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256728_)) {
            ForgeRegistry fReg = (ForgeRegistry)event.getForgeRegistry();
            ResourceLocation src = new ResourceLocation("generic.attack_reach");
            ResourceLocation dst = new ResourceLocation("forge", "entity_reach");
            fReg.addAlias(src, dst);
        }
    }

    @SubscribeEvent
    public void playerAttackBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        Player player;
        if (unmoddedPlayers.contains(event.getEntity().m_20148_()) && finalizingAttack.get(event.getEntity().m_20148_()).booleanValue() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((ServerPlayerExtensions)serverPlayer).getPresentResult();
            float xRot = serverPlayer.m_146909_();
            float yRot = serverPlayer.m_6080_();
            HitResult hitResult = ((ServerPlayerExtensions)serverPlayer).getOldHitResults().stream().filter(hitResultRotEntry -> hitResultRotEntry.shouldAccept(xRot, yRot)).min((firstResultRotEntry, secondResultRotEntry) -> firstResultRotEntry.compareTo((HitResultRotationEntry)secondResultRotEntry, xRot, yRot)).map(HitResultRotationEntry::hitResult).orElse(null);
            if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
                event.setCancellationResult(InteractionResult.FAIL);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void playerUseItemEvent(PlayerInteractEvent.RightClickItem event) {
        if (unmoddedPlayers.contains(event.getEntity().m_20148_())) {
            isPlayerAttacking.put(event.getEntity().m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void playerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (unmoddedPlayers.contains(event.getEntity().m_20148_())) {
            isPlayerAttacking.put(event.getEntity().m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void playerUseNothingEvent(PlayerInteractEvent.RightClickEmpty event) {
        if (unmoddedPlayers.contains(event.getEntity().m_20148_())) {
            isPlayerAttacking.put(event.getEntity().m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void playerUseEntityEvent(PlayerInteractEvent.EntityInteract event) {
        if (unmoddedPlayers.contains(event.getEntity().m_20148_())) {
            isPlayerAttacking.put(event.getEntity().m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void playerUseEntitySpecificEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        if (unmoddedPlayers.contains(event.getEntity().m_20148_())) {
            isPlayerAttacking.put(event.getEntity().m_20148_(), false);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean bl = (Boolean)Combatify.CONFIG.configOnlyWeapons.get() != false || (Boolean)Combatify.CONFIG.defender.get() != false || (Boolean)Combatify.CONFIG.piercer.get() != false || (Boolean)Combatify.CONFIG.letVanillaConnect.get() == false;
            boolean isModLoaded = NetworkRegistry.getClientNonVanillaNetworkMods().contains(MOD_ID);
            if (isModLoaded) {
                if (bl) {
                    serverPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"Combatify needs to be installed on the client to join this server!"));
                    return;
                }
                unmoddedPlayers.add(serverPlayer.m_20148_());
                isPlayerAttacking.put(serverPlayer.m_20148_(), true);
                finalizingAttack.put(serverPlayer.m_20148_(), true);
                scheduleHitResult.put(serverPlayer.m_20148_(), new Timer());
                LOGGER.info("Unmodded player joined: " + String.valueOf(serverPlayer.m_20148_()));
                return;
            }
            if (unmoddedPlayers.contains(serverPlayer.m_20148_())) {
                unmoddedPlayers.remove(serverPlayer.m_20148_());
                isPlayerAttacking.remove(serverPlayer.m_20148_());
                finalizingAttack.remove(serverPlayer.m_20148_());
            }
            LOGGER.info("Sending server config values to client");
            PacketRegistration.MAIN.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new S2CConfigPacket());
        }
    }

    @SubscribeEvent
    public void disconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && unmoddedPlayers.contains((serverPlayer = (ServerPlayer)player).m_20148_())) {
            Timer timer = scheduleHitResult.get(serverPlayer.m_20148_());
            timer.cancel();
            timer.purge();
        }
    }

    @SubscribeEvent
    public void attributeModifier(ItemAttributeModifierEvent event) {
        EquipmentSlot equipmentSlot = event.getSlotType();
        Item item = event.getItemStack().m_41720_();
        if (Combatify.ITEMS.configuredItems.containsKey(item) && equipmentSlot == EquipmentSlot.MAINHAND) {
            List modifiers;
            ArrayList<Integer> indexes;
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.type != null) {
                Tiers tiers;
                if (event.getModifiers().containsKey((Object)Attributes.f_22281_)) {
                    indexes = new ArrayList<Integer>();
                    modifiers = event.getModifiers().get((Object)Attributes.f_22281_).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != Item.f_41374_) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier(Attributes.f_22281_, (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                if (event.getModifiers().containsKey((Object)Attributes.f_22283_)) {
                    indexes = new ArrayList();
                    modifiers = event.getModifiers().get((Object)Attributes.f_22283_).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != Item.f_41375_ && modifier.m_22209_() != WeaponType.BASE_ATTACK_SPEED_CTS_UUID) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier(Attributes.f_22283_, (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                if (event.getModifiers().containsKey(ForgeMod.ENTITY_REACH.get())) {
                    indexes = new ArrayList();
                    modifiers = event.getModifiers().get((Object)((Attribute)ForgeMod.ENTITY_REACH.get())).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != WeaponType.BASE_ATTACK_REACH_UUID) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier((Attribute)ForgeMod.ENTITY_REACH.get(), (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                ArrayListMultimap modMap = ArrayListMultimap.create();
                WeaponType weaponType = configurableItemData.type;
                if (item instanceof TieredItem) {
                    TieredItem tieredItem = (TieredItem)item;
                    tiers = tieredItem.m_43314_();
                } else if (item instanceof Tierable) {
                    Tierable tierable = (Tierable)item;
                    tiers = tierable.getTier();
                } else {
                    tiers = Tiers.NETHERITE;
                }
                weaponType.addCombatAttributes((Tier)tiers, (ArrayListMultimap<Attribute, AttributeModifier>)modMap);
                this.putAll(event, (Multimap)modMap);
            }
            if (configurableItemData.damage != null) {
                if (event.getModifiers().containsKey((Object)Attributes.f_22281_)) {
                    indexes = new ArrayList();
                    modifiers = event.getModifiers().get((Object)Attributes.f_22281_).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != Item.f_41374_) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier(Attributes.f_22281_, (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                event.addModifier(Attributes.f_22281_, new AttributeModifier(Item.f_41374_, "Config modifier", configurableItemData.damage - (double)((Boolean)Combatify.CONFIG.fistDamage.get() != false ? 1 : 2), AttributeModifier.Operation.ADDITION));
            }
            if (configurableItemData.speed != null) {
                if (event.getModifiers().containsKey((Object)Attributes.f_22283_)) {
                    indexes = new ArrayList();
                    modifiers = event.getModifiers().get((Object)Attributes.f_22283_).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != Item.f_41375_ && modifier.m_22209_() != WeaponType.BASE_ATTACK_SPEED_CTS_UUID) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier(Attributes.f_22283_, (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                event.addModifier(Attributes.f_22283_, new AttributeModifier(WeaponType.BASE_ATTACK_SPEED_CTS_UUID, "Config modifier", configurableItemData.speed - (Double)Combatify.CONFIG.baseHandAttackSpeed.get(), AttributeModifier.Operation.ADDITION));
            }
            if (configurableItemData.reach != null) {
                if (event.getModifiers().containsKey(ForgeMod.ENTITY_REACH.get())) {
                    indexes = new ArrayList();
                    modifiers = event.getModifiers().get((Object)((Attribute)ForgeMod.ENTITY_REACH.get())).stream().toList();
                    for (AttributeModifier modifier : modifiers) {
                        if (modifier.m_22209_() != WeaponType.BASE_ATTACK_REACH_UUID) continue;
                        indexes.add(modifiers.indexOf(modifier));
                    }
                    if (!indexes.isEmpty()) {
                        for (Integer index : indexes) {
                            event.removeModifier((Attribute)ForgeMod.ENTITY_REACH.get(), (AttributeModifier)modifiers.get(index));
                        }
                    }
                }
                event.addModifier((Attribute)ForgeMod.ENTITY_REACH.get(), new AttributeModifier(WeaponType.BASE_ATTACK_REACH_UUID, "Config modifier", configurableItemData.reach - 2.5, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @CanIgnoreReturnValue
    public <K extends Attribute, V extends AttributeModifier> boolean putAll(ItemAttributeModifierEvent event, Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= event.addModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
        }
        return changed;
    }

    public static void initConfig() {
        CONFIG = new ForgeConfig();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ConfigSynchronizer.init();
        LOGGER.info("Init started.");
        DispenserBlock.m_52672_((ItemLike)Items.f_42713_, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(Level world, Position position, ItemStack stack) {
                ThrownTrident trident = new ThrownTrident(EntityType.f_20487_, world);
                trident.f_37555_ = stack.m_41777_();
                trident.m_20343_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                trident.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return trident;
            }
        });
        IForgeRegistry items = ForgeRegistries.ITEMS;
        for (Item item : items) {
            ((ItemExtensions)item).modifyAttributeModifiers();
        }
        new PacketRegistration().init();
    }

    public static <T extends BlockingType> T registerBlockingType(T blockingType) {
        registeredTypes.put(blockingType.getName(), blockingType);
        return blockingType;
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        state = Suppliers.memoize(() -> CombatifyState.COMBATIFY);
        shields = new ArrayListExtensions<TieredShieldItem>();
        unmoddedPlayers = new ArrayListExtensions<UUID>();
        isPlayerAttacking = new HashMap<UUID, Boolean>();
        finalizingAttack = new HashMap<UUID, Boolean>();
        scheduleHitResult = new HashMap<UUID, Timer>();
        registeredTypes = new HashMap<String, BlockingType>();
        LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify"));
        SWORD = Combatify.registerBlockingType(new SwordBlockingType("sword").setToolBlocker(true).setDisablement(false).setCrouchable(false).setBlockHit(true).setRequireFullCharge(false).setSwordBlocking(true));
        SHIELD = Combatify.registerBlockingType(new ShieldBlockingType("shield"));
        NEW_SHIELD = Combatify.registerBlockingType(new NewShieldBlockingType("new_shield").setKbMechanics(false));
        EMPTY = new EmptyBlockingType("empty").setDisablement(false).setCrouchable(false).setRequireFullCharge(false).setKbMechanics(false);
    }

    public static enum CombatifyState implements StringRepresentable
    {
        VANILLA("Vanilla", "vanilla"),
        COMBATIFY("Combatify", "combatify"),
        CTS_8C("CTS 8C", "combat_test");

        public final String name;
        public final String key;

        private CombatifyState(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @NotNull
        public String m_7912_() {
            return this.key;
        }

        public Component getComponent() {
            return Component.m_264568_((String)("options.combatify_state." + this.key), (String)this.name);
        }

        public String toString() {
            return "CombatifyState{name='" + this.name + "'}";
        }
    }
}

