/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.mojang.serialization.Codec;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.Arrays;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ShieldIndicatorStatus;
import net.atlas.combatify.item.ItemRegistry;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.util.ArrayListExtensions;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="combatify", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CombatifyClient {
    public static final OptionInstance<Boolean> autoAttack = OptionInstance.m_231525_((String)"options.autoAttack", (boolean)true);
    public static final OptionInstance<Boolean> shieldCrouch = OptionInstance.m_231525_((String)"options.shieldCrouch", (boolean)true);
    public static final OptionInstance<Boolean> rhythmicAttacks = OptionInstance.m_231525_((String)"options.rhythmicAttack", (boolean)true);
    public static final OptionInstance<Boolean> protectionIndicator = OptionInstance.m_231525_((String)"options.protIndicator", (boolean)false);
    public static final OptionInstance<Boolean> fishingRodLegacy = OptionInstance.m_231525_((String)"options.fishingRodLegacy", (boolean)false);
    public static final OptionInstance<Double> attackIndicatorMaxValue = new OptionInstance("options.attackIndicatorMaxValue", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.attackIndicatorMaxValue.tooltip")), (optionText, value) -> value == 2.0 ? Objects.requireNonNull(Options.m_231921_((Component)optionText, (Component)Component.m_237115_((String)"options.attackIndicatorMaxValue.default"))) : CombatifyClient.percentValueLabel(optionText, value), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 200).m_231657_(sliderValue -> (double)sliderValue / 100.0, value -> (int)(value * 100.0)), Codec.doubleRange((double)0.01, (double)2.0), (Object)2.0, value -> {});
    public static final OptionInstance<Double> attackIndicatorMinValue = new OptionInstance("options.attackIndicatorMinValue", OptionInstance.m_231535_((Component)Component.m_237115_((String)"options.attackIndicatorMinValue.tooltip")), (optionText, value) -> value == 1.3 ? Objects.requireNonNull(Options.m_231921_((Component)optionText, (Component)Component.m_237115_((String)"options.attackIndicatorMinValue.default"))) : CombatifyClient.percentValueLabel(optionText, value), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 200).m_231657_(sliderValue -> (double)sliderValue / 100.0, value -> (int)(value * 100.0)), Codec.doubleRange((double)0.0, (double)2.0), (Object)1.3, value -> {});
    public static final OptionInstance<Combatify.CombatifyState> combatifyState = new OptionInstance("options.combatifyState", OptionInstance.m_231498_(), (component, state) -> state.getComponent(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(Combatify.CombatifyState.values()), Codec.INT.xmap(ordinal -> switch (Mth.m_14100_((int)ordinal, (int)2)) {
        case 0 -> Combatify.CombatifyState.CTS_8C;
        default -> Combatify.CombatifyState.COMBATIFY;
    }, Enum::ordinal)), (Object)Combatify.CombatifyState.COMBATIFY, value -> {});
    public static final OptionInstance<ShieldIndicatorStatus> shieldIndicator = new OptionInstance("options.shieldIndicator", OptionInstance.m_231498_(), OptionInstance.m_231546_(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(ShieldIndicatorStatus.values()), Codec.INT.xmap(ShieldIndicatorStatus::byId, ShieldIndicatorStatus::m_35965_)), (Object)ShieldIndicatorStatus.OFF, value -> {});

    private static Component percentValueLabel(Component arg, double d) {
        return Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{arg, (int)(d * 100.0)});
    }

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> MidnightConfig.getScreen((Screen)parent, (String)"combatify")));
        Combatify.markState(() -> combatifyState.m_231551_());
    }

    @SubscribeEvent
    public static void onCreativeTabBuild(BuildCreativeModeTabContentsEvent event) {
        int i;
        ArrayListExtensions<ItemLike> arrayListExtensions;
        if (event.getTabKey() == CreativeModeTabs.f_256797_ && ((Boolean)Combatify.CONFIG.configOnlyWeapons.get()).booleanValue()) {
            arrayListExtensions = new ArrayListExtensions<ItemLike>();
            arrayListExtensions.addAll(Items.f_42393_, (ItemLike)ItemRegistry.WOODEN_KNIFE.get(), (ItemLike)ItemRegistry.STONE_KNIFE.get(), (ItemLike)ItemRegistry.IRON_KNIFE.get(), (ItemLike)ItemRegistry.GOLD_KNIFE.get(), (ItemLike)ItemRegistry.DIAMOND_KNIFE.get(), (ItemLike)ItemRegistry.NETHERITE_KNIFE.get(), (ItemLike)ItemRegistry.WOODEN_LONGSWORD.get(), (ItemLike)ItemRegistry.STONE_LONGSWORD.get(), (ItemLike)ItemRegistry.IRON_LONGSWORD.get(), (ItemLike)ItemRegistry.GOLD_LONGSWORD.get(), (ItemLike)ItemRegistry.DIAMOND_LONGSWORD.get(), (ItemLike)ItemRegistry.NETHERITE_LONGSWORD.get());
            for (i = 1; i < arrayListExtensions.size(); ++i) {
                event.getEntries().putAfter((Object)new ItemStack((ItemLike)arrayListExtensions.get(i - 1)), (Object)new ItemStack((ItemLike)arrayListExtensions.get(i)), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.f_256797_ && ((Boolean)Combatify.CONFIG.tieredShields.get()).booleanValue()) {
            arrayListExtensions = new ArrayListExtensions();
            arrayListExtensions.addAll(Items.f_42740_, (ItemLike)TieredShieldItem.IRON_SHIELD.get(), (ItemLike)TieredShieldItem.GOLD_SHIELD.get(), (ItemLike)TieredShieldItem.DIAMOND_SHIELD.get(), (ItemLike)TieredShieldItem.NETHERITE_SHIELD.get());
            for (i = 1; i < arrayListExtensions.size(); ++i) {
                event.getEntries().putAfter((Object)new ItemStack((ItemLike)arrayListExtensions.get(i - 1)), (Object)new ItemStack((ItemLike)arrayListExtensions.get(i)), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

